/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class TimerAndCalendarFireUntilHaltTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession;
    private KieBase kbase;
    private CountDownLatch stoppedLatch;
    private PseudoClockScheduler timeService;
    private RecordingRulesListener listener;
    private CountDownLatch startingLatch;
    private FactHandle triggerHandle;

    public TimerAndCalendarFireUntilHaltTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @After
    public void after() throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testTimerRuleFires() throws Exception {
        String drl = "// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend";
        this.setupKSessionFor("// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend");
        this.startEngine();
        this.activateRule();
        this.advanceTimerOneSecond();
        Awaitility.await().until(this.ruleHasFired("TimerRule", 1));
    }

    @Test(timeout=10000L)
    public void testTimerRuleHaltStopsFiring() throws Exception {
        String drl = "// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend";
        this.setupKSessionFor("// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend");
        this.startEngine();
        this.activateRule();
        this.advanceTimerOneSecond();
        Awaitility.await().until(this.ruleHasFired("TimerRule", 1));
        this.stopEngine();
        this.advanceTimerOneSecond();
        this.checkForASecondThat(this.ruleHasFired("TimerRule", 1));
    }

    @Test(timeout=10000L)
    public void testTimerRuleRestartsAfterStop() throws Exception {
        String drl = "// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend";
        this.setupKSessionFor("// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend");
        this.startEngine();
        this.activateRule();
        this.advanceTimerOneSecond();
        Awaitility.await().until(this.ruleHasFired("TimerRule", 1));
        this.stopEngine();
        this.startEngine();
        this.advanceTimerOneSecond();
        this.checkForASecondThat(this.ruleHasFired("TimerRule", 2));
    }

    private void checkForASecondThat(Callable<Boolean> predicate) throws Exception {
        int i;
        for (i = 0; i < 100; ++i) {
            if (predicate.call().booleanValue()) {
                System.out.println(this.listener.timesRulesHasFired("TimerRule"));
                break;
            }
            Thread.sleep(10L);
            System.out.println(this.listener.timesRulesHasFired("TimerRule"));
            System.out.println("Still not true");
        }
        for (i = 0; i < 100; ++i) {
            if (!predicate.call().booleanValue()) {
                System.out.println("False again");
                Assert.fail();
            }
            Thread.sleep(10L);
            System.out.println("Still true");
        }
    }

    @Test(timeout=10000L)
    public void testTimerRuleDoesRestartsIfNoLongerHolds() throws Exception {
        String drl = "// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend";
        this.setupKSessionFor("// fire once, for a String, create an Integer\nrule TimerRule\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"trigger\" )\nthen\n    insert( new Integer(1) );\nend");
        this.startEngine();
        this.activateRule();
        this.advanceTimerOneSecond();
        Awaitility.await().until(this.ruleHasFired("TimerRule", 1));
        this.stopEngine();
        this.disactivateRule();
        this.startEngine();
        this.advanceTimerOneSecond();
        this.checkForASecondThat(this.ruleHasFired("TimerRule", 1));
    }

    private void setupKSessionFor(String drl) {
        this.kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration();
        this.ksession = this.kbase.newKieSession(kieSessionConfiguration, null);
        this.listener = new RecordingRulesListener();
        this.ksession.addEventListener((AgendaEventListener)this.listener);
        this.timeService = (PseudoClockScheduler)this.ksession.getSessionClock();
    }

    private void startEngine() throws InterruptedException {
        this.startingLatch = new CountDownLatch(1);
        this.stoppedLatch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            this.startingLatch.countDown();
            this.ksession.fireUntilHalt();
            this.stoppedLatch.countDown();
        });
        t.start();
        this.startingLatch.await();
    }

    private void stopEngine() throws InterruptedException {
        this.ksession.halt();
        this.stoppedLatch.await();
    }

    private Callable<Boolean> ruleHasFired(String ruleName, int times) {
        return () -> this.listener.timesRulesHasFired(ruleName) == times;
    }

    private void advanceTimerOneSecond() {
        this.timeService.advanceTime(1L, TimeUnit.SECONDS);
    }

    private void activateRule() {
        this.triggerHandle = this.ksession.insert((Object)"trigger");
    }

    private void disactivateRule() {
        this.ksession.delete(this.triggerHandle);
    }

    private final class RecordingRulesListener
    extends DefaultAgendaEventListener {
        private Map<String, Integer> firedRules = new HashMap<String, Integer>();

        private RecordingRulesListener() {
        }

        public int timesRulesHasFired(String ruleName) {
            if (this.firedRules.containsKey(ruleName)) {
                return this.firedRules.get(ruleName);
            }
            return 0;
        }

        public void afterMatchFired(AfterMatchFiredEvent event) {
            String ruleName = event.getMatch().getRule().getName();
            if (!this.firedRules.containsKey(ruleName)) {
                this.firedRules.put(ruleName, 0);
            }
            this.firedRules.put(ruleName, this.firedRules.get(ruleName) + 1);
        }
    }
}

