/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.beliefsystem.abductive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.BeliefSystemType;
import org.drools.core.QueryResultsImpl;
import org.drools.core.SessionConfiguration;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.abductive.Abducible;
import org.drools.core.beliefsystem.defeasible.Defeasible;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.runtime.rule.impl.FlatQueryResults;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;

@RunWith(value=Parameterized.class)
public class AbductionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AbductionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false, (boolean)true);
    }

    protected KieSession getSessionFromString(String drlString, KieBaseOption ... options) {
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlString});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])options);
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ((SessionConfiguration)ksConf).setBeliefSystemType(BeliefSystemType.DEFEASIBLE);
        return kbase.newKieSession(ksConf, null);
    }

    @Test
    public void testAbductiveLogicWithConstructorArgs() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Foo \n   @Abducible \n   id : Integer @key \n   name : String @key \n   value : double \n   flag : boolean \nend \nquery foo() \n   @Abductive( target=Foo.class ) \nend \nquery foo2( Integer $i, String $name ) \n   @Abductive( target=Foo.class ) \n   $i := Integer() from new Integer( 4 ) \n   $name := String() end \nquery foo3( Integer $i, String $name, double $val, boolean $bool ) \n   @Abductive( target=Foo.class ) \nend \nrule Init    salience 9999 when then    System.out.println( 'Foo zero is in' ); \n   insert( new Foo() ); \nend rule R1 when    $fx : foo() then    list.add( 1 ); end \nrule R2 when    foo2( 4, $n ; ) then    list.add( 2 ); end \nrule R3 when    foo3( 42, \"test2\", $dbl, $bool ; ) then    list.add( 3 ); end \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)"john");
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">> " + o);
        }
        System.err.println(list);
        Assert.assertEquals(Arrays.asList(1, 2, 3), list);
    }

    @Test
    public void testAbductiveLogicWithSelectiveConstructorArgs() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Foo \n   @Abducible \n   id : String @key \n   name : String @key \n   value : double \n   flag : boolean \nend \nquery foo( String $name, double $val, String $x ) \n   @Abductive( target=Foo.class, args={ $x, $name } ) \nend \nrule R3 when    $f := foo( \"name_test\", 99.0, \"id_0\" ; ) then    list.add( $f ); end \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        FactType type = session.getKieBase().getFactType("org.drools.abductive.test", "Foo");
        for (Object o : session.getObjects()) {
            if (!type.getFactClass().isInstance(o)) continue;
            Assert.assertEquals((Object)"id_0", (Object)type.get(o, "id"));
            Assert.assertEquals((Object)"name_test", (Object)type.get(o, "name"));
            Assert.assertEquals((Object)0.0, (Object)type.get(o, "value"));
        }
        System.err.println(list);
    }

    @Test
    public void testAbductiveLogicWithNonExistingArgsMapping() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Foo \n   @Abducible \n   id : String @key \n   name : String @key \nend \nquery foo( String $name ) \n   @Abductive( target=Foo.class, args={ $missing, $name } ) \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{droolsSource});
        Results res = kieBuilder.getResults();
        Assert.assertEquals((long)1L, (long)res.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
    }

    @Test
    public void testAbductiveLogicWithWrongTypeArgsMapping() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Foo \n   @Abducible \n   id : String @key \n   name : String @key \nend \nquery foo( String $name, int $x ) \n   @Abductive( target=Foo.class, args={ $x, $name } ) \nend \nrule R0 when    $f := foo( \"name_test\", 99 ; ) then    list.add( $f ); end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{droolsSource});
        Results res = kieBuilder.getResults();
        Assert.assertEquals((long)1L, (long)res.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
    }

    @Test
    public void testBindNonAbductiveQueryError() {
        String droolsSource = "package org.drools.abductive.test; \nquery foo() \nend \nrule R1 when    $x : foo( ) then end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{droolsSource});
        Results res = kieBuilder.getResults();
        Assert.assertTrue((boolean)res.hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testAbducedReturnBinding() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.Map map; \ndeclare Foo \n   @Abducible \n   id : Integer @key \nend \nquery foo( Integer $i ) \n   @Abductive( target=Foo.class ) \n   $i := Integer() end \nrule R1 when    $x : foo( $v ; ) then    map.put( $v, $x ); end \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        HashMap map = new HashMap();
        session.setGlobal("map", map);
        session.insert((Object)3);
        session.insert((Object)42);
        session.insert((Object)11);
        session.fireAllRules();
        System.out.println(map);
        Assert.assertTrue((boolean)map.keySet().containsAll(Arrays.asList(3, 42, 11)));
        FactType foo = session.getKieBase().getFactType("org.drools.abductive.test", "Foo");
        for (Object k : map.keySet()) {
            Object val = map.get(k);
            Assert.assertSame((Object)foo.getFactClass(), val.getClass());
            Assert.assertEquals(k, (Object)foo.get(val, "id"));
        }
    }

    @Test
    public void testAbducedKnownClass() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Bean.class.getCanonicalName() + ";global java.util.Map map; \nquery foo( Integer $i ) \n   @Abductive( target=Bean.class ) \n   $i := Integer() end \nrule R1 when    $x : foo( $v ; ) then    map.put( $v, $x ); end \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        HashMap map = new HashMap();
        session.setGlobal("map", map);
        session.insert((Object)42);
        session.fireAllRules();
        System.out.println(map);
        Assert.assertTrue((boolean)map.containsKey(42));
        Assert.assertEquals((Object)new Bean(42), map.get(42));
    }

    @Test
    public void testAbducedWithStatus() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Bean.class.getCanonicalName() + ";global java.util.Map map; \nquery foo( Integer $i ) \n   @Abductive( target=Bean.class ) \n   $i := Integer() end \nrule R1 when    $x : foo( $v ; ) then    map.put( $v, $x ); end \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        HashMap map = new HashMap();
        session.setGlobal("map", map);
        session.insert((Object)42);
        session.insert((Object)11);
        Bean b = new Bean(11);
        session.insert((Object)b);
        session.fireAllRules();
        System.out.println(map);
        Assert.assertTrue((boolean)map.keySet().containsAll(Arrays.asList(11, 42)));
        Assert.assertEquals((long)2L, (long)map.size());
        Bean b11 = (Bean)map.get(11);
        InternalFactHandle f11 = (InternalFactHandle)session.getFactHandle((Object)b11);
        Assert.assertSame((Object)b, (Object)b11);
        Bean b42 = (Bean)map.get(42);
        InternalFactHandle f42 = (InternalFactHandle)session.getFactHandle((Object)b42);
        Assert.assertEquals((long)2L, (long)f42.getEqualityKey().getStatus());
    }

    @Test
    public void testAbductiveLogicUnlinking() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Foo \n   @Abducible \n   id : Integer @key \nend \nquery foo( Integer $i ) \n   @Abductive( target=Foo.class ) \nend \nrule R1 when    foo( 42 ; )    Foo( 42 ; ) then    list.add( 1 ); end \nrule R2 when    foo( 24 ; )    String()    Foo( 24 ; ) then    list.add( 2 ); end \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        session.insert((Object)"test");
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">> " + o);
        }
        System.err.println(list);
        Assert.assertEquals(Arrays.asList(1, 2), list);
    }

    @Test
    public void testAbductiveLogicNoConstructorFoundError() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Foo \n   @Abducible \n   id : Integer @key \nend \nquery foo( String $x ) \n   @Abductive( target=Foo.class ) \nend \nrule R1 when    $x : foo( \"x\" ; ) then    list.add( $x ); end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{droolsSource});
        Results res = kieBuilder.getResults();
        Assert.assertEquals((long)1L, (long)res.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
    }

    @Test
    public void testQueryTwice() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Foo \n   @Abducible \n   id : String @key \nend \nquery foo1( String $x ) \n   @Abductive( target=Foo.class ) \nend \nquery foo2( String $x ) \n   @Abductive( target=Foo.class ) \nend \nrule R1 when    $x := ?foo1( \"x\" ; )    $x := ?foo2( \"x\" ; ) then    System.out.println( 'aaaa' );    list.add( $x ); end \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">> " + o);
        }
        System.err.println(list);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testAbductiveLogicSprinklerAndRainExample() {
        KieSession session;
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nimport " + Defeasible.class.getName() + "; \nglobal java.util.List list; \ndeclare Sunny id : int @key end \ndeclare WetGrass @Abducible id : int @key end \ndeclare Rain @Abducible id : int @key end \ndeclare Sprinkler @Abducible id : int @key end \nquery wetGrass() \n   @Abductive( target=WetGrass.class ) \n   rain() or sprinkler() \nend \nquery rain() \n   @Abductive( target=Rain.class ) \n   @Defeasible end \nquery sprinkler() \n   @Abductive( target=Sprinkler.class ) \n   @Defeasible end \nrule SunIntegrityConstraint \n@Direct \nwhen \n   Sunny()then \n   insertLogical( new Rain(), 'neg' ); \nend \nrule Facts \nwhen \nthen \n insert( new Sunny( 0 ) ); \nend \nrule Raaain \nwhen    $r : Rain( _.neg ) then \n   list.add( 'no_rain_check' ); \nend \nrule Main_1\nwhen \n   wetGrass() \n   (      Sprinkler() do[sprk] \n     or \n     Rain() do[rain] \n     or \n     Rain( _.neg ) do[norn] \n   ) \nthen \nthen[sprk] \n   list.add( 'sprinkler' ); \n   System.out.println( \"The grass is wet because the sprinkler is on \" ); \nthen[rain] \n   list.add( 'rain' ); \n    System.out.println( \"The grass is wet because it's raining! \" ); \nthen[norn] \n   list.add( 'not rain' ); \n   System.out.println( \"The grass can't be wet due to rain, it's sunny today!!! \" ); \nend \n";
        try {
            System.setProperty("drools.negatable", "on");
            session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        }
        finally {
            System.setProperty("drools.negatable", "off");
        }
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("sprinkler"));
        Assert.assertTrue((boolean)list.contains("not rain"));
        Assert.assertTrue((boolean)list.contains("no_rain_check"));
        Assert.assertEquals((long)3L, (long)session.getObjects().size());
        int i = 0;
        Iterator it = session.getObjects().iterator();
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        Assert.assertEquals((long)3L, (long)i);
    }

    @Test
    public void testAbductiveFactory() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Root id : String @key end \ndeclare TypeA extends Root @Abducible end \ndeclare TypeB extends Root @Abducible end \nquery factory( String $type, String $arg, Root $out ) \n   ( String( this == \"A\" ) from $type      and     $out := typeA( $arg ; )    )    or    ( String( this == \"B\" ) from $type      and      $out := typeB( $arg ; )    ) end \nquery typeA( String $x ) \n   @Abductive( target=TypeA.class ) \nend \nquery typeB( String $x ) \n   @Abductive( target=TypeB.class ) \nend \nrule Main\nwhen \n   $s : String()    factory( $s, \"foo\", $x ; )    Root( id == \"foo\" ) from $x then \n   System.out.println( \">>>>>\" + $x ); \n   list.add( $x ); \nend \n";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)"A");
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"TypeA", (Object)list.get(0).getClass().getSimpleName());
    }

    @Test
    public void testQueryAPIs() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Abducible.class.getName() + "; \ndeclare Foo    @Abducible    id : String end query foo( String $s )    @Abductive( target=Foo.class ) \nend \n query bar( String $s, Foo $foo )    $foo := Foo() end \n rule MoveAround when    $s : String()    $f : foo( $s ; )    bar( $s, $f ; ) then    delete( $s );    System.out.println( 'Foo ' + $f ); end ";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        session.insert((Object)"faa");
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">>> " + o);
        }
        Assert.assertEquals((long)1L, (long)session.getObjects().size());
        Query q1 = session.getKieBase().getQuery("org.drools.abductive.test", "foo");
        Query q2 = session.getKieBase().getQuery("org.drools.abductive.test", "bar");
        Assertions.assertThat((Object)q1).isNotNull();
        Assertions.assertThat((Object)q2).isNotNull();
        FlatQueryResults q10res = new FlatQueryResults((QueryResultsImpl)session.getQueryResults("foo", new Object[]{"foo", null}));
        FlatQueryResults q11res = new FlatQueryResults((QueryResultsImpl)session.getQueryResults("foo", new Object[]{"foo", Variable.v}));
        FlatQueryResults q20res = new FlatQueryResults((QueryResultsImpl)session.getQueryResults("bar", new Object[]{"foo", Variable.v}));
        Assert.assertEquals((long)1L, (long)q10res.size());
        Assert.assertEquals((long)1L, (long)q11res.size());
        Assert.assertEquals((long)1L, (long)q20res.size());
        QueryResultsRow row10 = (QueryResultsRow)q10res.iterator().next();
        QueryResultsRow row11 = (QueryResultsRow)q11res.iterator().next();
        QueryResultsRow row20 = (QueryResultsRow)q20res.iterator().next();
        Assert.assertEquals((Object)"foo", (Object)row10.get("$s"));
        Assert.assertEquals((Object)"foo", (Object)row11.get("$s"));
        Assert.assertEquals((Object)"foo", (Object)row20.get("$s"));
        Object foo = row20.get("$foo");
        Assert.assertSame((Object)foo, session.getObjects().iterator().next());
        Assert.assertNull((Object)row11.get(""));
    }

    @Test
    public void testCitizenshipExample() {
        String droolsSource = "package org.drools.abductive.test; \ndeclare CitizenUS    name : String @key end declare Parent    parent : String @key    child : String @key end declare BornUS @Abducible name : String @key end declare BornOutsideUS @Abducible name : String @key end declare ResidentUS @Abducible name : String @key end declare NaturalizedUS @Abducible name : String @key end declare RegisteredUS @Abducible name : String @key end query extractCitizen( CitizenUS $cit )    $cit := CitizenUS() end query citizen( String $name )    @Abductive( target=CitizenUS.class )    bornUS( $name ; )    or    ( bornOutsideUS( $name ; ) and residentUS( $name ; ) and naturalizedUS( $name ; ) )    or    ( bornOutsideUS( $name ; ) and Parent( $parent, $name ; ) and CitizenUS( $parent ; ) and registeredUS( $name ; ) ) end query bornUS( String $name ) @Abductive( target=BornUS.class ) end query bornOutsideUS( String $name ) @Abductive( target=BornOutsideUS.class ) end query residentUS( String $name ) @Abductive( target=ResidentUS.class ) end query naturalizedUS( String $name ) @Abductive( target=NaturalizedUS.class ) end query registeredUS( String $name ) @Abductive( target=RegisteredUS.class ) end rule Facts when then    insert( new CitizenUS( 'Mary' ) );    insert( new Parent( 'Mary', 'John' ) );    insertLogical( new ResidentUS( 'John' ), 'neg' ); end rule CheckCitizen when    $cit : ?citizen( 'John' ; ) then    System.out.println( 'John is a citizen ' + $cit ); end ";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        session.fireAllRules();
        FactType type = session.getKieBase().getFactType("org.drools.abductive.test", "CitizenUS");
        for (Object o : session.getObjects()) {
            System.out.println(">>> " + o);
            if (!o.getClass().equals(type.getFactClass())) continue;
            InternalFactHandle h = (InternalFactHandle)session.getFactHandle(o);
            String name = (String)type.get(o, "name");
            if ("Mary".equals(name)) {
                Assert.assertNull((Object)h.getEqualityKey().getBeliefSet());
                continue;
            }
            if (!"John".equals(name)) continue;
            BeliefSet bs = h.getEqualityKey().getBeliefSet();
            Assert.assertTrue((boolean)bs.isPositive());
            Assert.assertEquals((long)2L, (long)bs.size());
        }
    }

    @Test
    @Ignore(value="Not implemented yet")
    public void testGenesExplanationBackTracking() {
        String droolsSource = "package org.drools.abductive.test; \nimport org.kie.api.runtime.rule.Match;\ndeclare Amount    enz : String @key    level : String @key end query feed( String $enz )    $enz := String() from 'lactose'    ?make( 'permease' ; )    ?make( 'galactosidase' ; ) end query make( String $enz )    ?code( $gen, $enz ; ) and ?express( $gen ; ) end query code( String $gen, String $enz )    ( $gen := String() from 'lacY' and $enz := String() from 'permease' )    or    ( $gen := String() from 'lacZ' and $enz := String() from 'galactosidase' ) end query express( String $gen )   ( ?amount( 'glucose', 'low' ; ) and ?amount( 'lactose', 'hi' ; ) )   or   ( ?amount( 'glucose', 'medium' ; ) and ?amount( 'lactose', 'medium' ; ) ) end query amount( String $enz, String $lev ) @Abductive( target=Amount.class ) end rule Check when    ?feed( 'lactose' ; ) then    System.out.println( 'YES' ); end rule Match when    $m : Match( rule.name != 'Match' ) then   System.out.println( $m ); end  ";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">>> " + o);
        }
    }

    @Test
    @Ignore(value="Not implemented yet")
    public void testBacktracking() {
        String droolsSource = "package org.drools.abductive.test; \nimport org.kie.api.runtime.rule.Match;\ndeclare Foo @Abducible    id : Integer @key end query bar( Integer $id )    @Abductive( target=Foo.class, backtracking=true )    $id := Integer() end rule Check when    bar( $i ; ) then    System.out.println( 'YES ' + $i ); end rule Check2 when    bar( $i ; ) then    System.out.println( 'HAH ' + $i ); end rule Init when then   insert( new Integer( 1 ) );    insert( new Integer( 2 ) ); end  ";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">>> " + o);
        }
    }

    @Test
    public void testCheckForItemsExample() {
        String droolsSource = "package org.drools.abductive.test; import " + Abducible.class.getName() + "; global java.util.List list; declare Fruit id : int @key end declare Apple extends Fruit end declare Orange extends Fruit end declare Banana extends Fruit end declare Goal    type : Class @key end query need( Class $type )    @Abductive( target = Goal.class )    not Fruit( $type.getName() == this.getClass().getName() ) end query check( Class $type )    ?need( $type ; )    or    Fruit( $type.getName() == this.getClass().getName() ) end query checkRecipe()    check( Apple.class ; )    check( Orange.class ; )    check( Banana.class ; ) end rule Fridge    @Direct when then    insert( new Banana( 1 ) );    insert( new Orange( 1 ) ); end rule Reminder when    accumulate( $f : Fruit() ,       $c : count( $f );       $c == 2    )    ?checkRecipe() then    System.out.println( 'You have ' + $c + ' ingredients ' ); end rule Suggest when    $g : Goal( $type ; ) then    System.out.println( 'You are missing ' + $type );    list.add( $type.getSimpleName() ); end rule FruitSalad when    Apple()    Banana()    Orange() then    System.out.println( 'Enjoy the salad' ); end ";
        KieSession session = this.getSessionFromString(droolsSource, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">>> " + o);
        }
        Assert.assertEquals(Arrays.asList("Apple"), list);
    }

    @Abducible
    public static class Bean {
        private Integer id;

        public Bean() {
            this.id = 0;
        }

        public Bean(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bean bean = (Bean)o;
            return this.id == bean.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Bean{id=" + this.id + '}';
        }
    }
}

