/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.common.EventFactHandle;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.rule.TypeDeclaration;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.type.Annotation;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Role;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class TypeDeclarationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TypeDeclarationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testClassNameClashing() {
        String str = "";
        str = str + "package org.kie \ndeclare org.kie.Character \n    name : String \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testAnnotationReDefinition() {
        String str1 = "";
        str1 = str1 + "package org.kie \ndeclare org.kie.EventA \n    name : String \n    duration : Long \nend \n";
        String str2 = "";
        str2 = str2 + "package org.kie \ndeclare org.kie.EventA \n    @role (event) \n    @duration (duration) \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBuilderResults warnings = kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING});
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((long)1L, (long)kbuilder.getKnowledgePackages().size());
        FactType factType = ((KnowledgePackageImpl)kbuilder.getKnowledgePackages().iterator().next()).getFactType("org.kie.EventA");
        Assertions.assertThat((Object)factType).isNotNull();
        FactField field = factType.getField("name");
        Assertions.assertThat((Object)field).isNotNull();
        field = factType.getField("duration");
        Assertions.assertThat((Object)field).isNotNull();
        TypeDeclaration typeDeclaration = ((KnowledgePackageImpl)kbuilder.getKnowledgePackages().iterator().next()).getTypeDeclaration("EventA");
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)typeDeclaration.getRole());
        Assert.assertEquals((Object)"duration", (Object)typeDeclaration.getDurationAttribute());
    }

    @Test
    public void testNoAnnotationUpdateIfError() {
        String str1 = "";
        str1 = str1 + "package org.drools.mvel.compiler \ndeclare org.drools.EventA \n    name : String \n    duration : Long \nend \n";
        String str2 = "";
        str2 = str2 + "package org.drools.mvel.compiler \ndeclare org.drools.EventA \n    @role (event) \n    @duration (duration) \n    anotherField : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assert.fail((String)"Errors Expected");
        }
        KnowledgeBuilderResults warnings = kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING});
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((long)0L, (long)kbuilder.getKnowledgePackages().size());
    }

    @Test
    public void testDuplicatedTypeDeclarationWith2FieldsInSameResource() {
        String str1 = "";
        str1 = str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    lastName : String \nend \n";
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(str1));
        drlResource.setSourcePath("src/main/resources/rule1.drl");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{drlResource, drlResource});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testDuplicatedTypeDeclarationInDifferentResources() {
        String str1 = "";
        str1 = str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \nend \n";
        Resource drlResource1 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(str1));
        drlResource1.setSourcePath("src/main/resources/rule1.drl");
        Resource drlResource2 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(str1));
        drlResource2.setSourcePath("src/main/resources/rule2.drl");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{drlResource1, drlResource2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testClashingTypeDeclarationInDifferentResources() {
        String str1 = "";
        str1 = str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        String str2 = "";
        str2 = str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assert.fail((String)"An error should have been generated, redefinition of ClassA is not allowed");
        }
    }

    @Test
    public void testNotSoHarmlessTypeReDeclaration() {
        String str1 = "";
        str1 = str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        String str2 = "";
        str2 = str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assert.fail((String)"An error should have been generated, redefinition of ClassA is not allowed");
        }
    }

    @Test
    public void testTypeReDeclarationWithExtraField() {
        String str1 = "";
        str1 = str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        String str2 = "";
        str2 = str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    lastName : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testTypeReDeclarationWithExtraField2() {
        String str1 = "";
        str1 = str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        String str2 = "";
        str2 = str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    lastName : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testDuplicateDeclaration() {
        String str = "";
        str = str + "package org.drools.mvel.compiler \ndeclare Bean \n    name : String \nend \ndeclare Bean \n    age : int \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Two definitions with the same name are not allowed, but it was not detected!", (boolean)errors.isEmpty());
    }

    @Test
    public void testTypeDeclarationMetadata() {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test; \nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.KlassAnnotation; \nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.FieldAnnotation; \nimport org.drools.mvel.compiler.Person\n\ndeclare Bean \n@role(event) \n@expires( 1s ) \n@KlassAnnotation( \"klass\" )    name : String\nend \ndeclare Person @role(event) end";
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        FactType bean = kBase.getFactType("org.drools.mvel.compiler.test", "Bean");
        FactType pers = kBase.getFactType("org.drools", "Person");
        Assert.assertEquals((Object)"org.drools.mvel.compiler.test.Bean", (Object)bean.getName());
        Assert.assertEquals((Object)"Bean", (Object)bean.getSimpleName());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.test", (Object)bean.getPackageName());
        Assert.assertEquals((long)3L, (long)bean.getClassAnnotations().size());
        Annotation ann = (Annotation)bean.getClassAnnotations().get(0);
        if (!ann.getName().equals("org.drools.mvel.compiler.compiler.TypeDeclarationTest$KlassAnnotation")) {
            ann = (Annotation)bean.getClassAnnotations().get(1);
        }
        if (!ann.getName().equals("org.drools.mvel.compiler.compiler.TypeDeclarationTest$KlassAnnotation")) {
            ann = (Annotation)bean.getClassAnnotations().get(2);
        }
        Assert.assertEquals((Object)"org.drools.mvel.compiler.compiler.TypeDeclarationTest$KlassAnnotation", (Object)ann.getName());
        Assert.assertEquals((Object)"klass", (Object)ann.getPropertyValue("value"));
        Assert.assertEquals(String.class, (Object)ann.getPropertyType("value"));
        Assert.assertEquals((long)2L, (long)bean.getMetaData().size());
        Assert.assertEquals((Object)"event", bean.getMetaData().get("role"));
        FactField field = bean.getField("name");
        Assertions.assertThat((Object)field).isNotNull();
    }

    @Test
    public void testTypeDeclarationWithInnerClasses() {
        String str = "";
        str = str + "package org.drools.mvel.compiler;\n\nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.EventBar.*;\ndeclare Foo\n @role( event )\nend\nrule R when Foo() then end";
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession knowledgeSession = kBase.newKieSession();
        FactHandle handle = knowledgeSession.insert((Object)new EventBar.Foo());
        Assert.assertTrue((boolean)(handle instanceof EventFactHandle));
    }

    @Test
    public void testTypeDeclarationWithInnerClassesImport() {
        String str = "";
        str = str + "package org.drools.mvel.compiler;\n\nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.EventBar.Foo;\ndeclare Foo\n @role( event )\nend\nrule R when Foo() then end";
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession knowledgeSession = kBase.newKieSession();
        FactHandle handle = knowledgeSession.insert((Object)new EventBar.Foo());
        Assert.assertTrue((boolean)(handle instanceof EventFactHandle));
    }

    @Test
    public void testMultipleTypeReDeclaration() {
        String str1 = "";
        str1 = str1 + "package org.drools \ndeclare org.drools.ClassC \n    name : String \n    age : Integer \nend \n";
        String str2 = "";
        str2 = str2 + "package org.drools \ndeclare org.drools.ClassC \n    name : String \n    age : Integer \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testDeclareFieldArray() {
        String str1 = "package org.drools declare Test end declare Pet     owners : Owner[]     twoDimArray : Foo[][]     friends : Pet[]     ages : int[] end declare Owner      name : String end declare Foo end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
        InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModule();
        KnowledgeBuilderImpl kbuilder = (KnowledgeBuilderImpl)kieModule.getKnowledgeBuilderForKieBase("KieBaseModelName");
        for (KiePackage kp : kbuilder.getKnowledgePackages()) {
            if (!kp.getName().equals("org.drools")) continue;
            Collection types = kp.getFactTypes();
            for (FactType type : types) {
                if (!"org.drools.Pet".equals(type.getName())) continue;
                Assert.assertEquals((long)4L, (long)type.getFields().size());
                FactField owners = type.getField("owners");
                Assert.assertTrue((owners != null && owners.getType().getSimpleName().equals("Owner[]") && owners.getType().isArray() ? 1 : 0) != 0);
                FactField twoDim = type.getField("twoDimArray");
                Assert.assertTrue((twoDim != null && twoDim.getType().getSimpleName().equals("Foo[][]") && twoDim.getType().isArray() ? 1 : 0) != 0);
                FactField friends = type.getField("friends");
                Assert.assertTrue((friends != null && friends.getType().getSimpleName().equals("Pet[]") && friends.getType().isArray() ? 1 : 0) != 0);
                FactField ages = type.getField("ages");
                Assert.assertTrue((ages != null && ages.getType().getSimpleName().equals("int[]") && ages.getType().isArray() ? 1 : 0) != 0);
            }
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPreventReflectionAPIsOnJavaClasses() {
        String drl = "package org.test; declare org.drools.mvel.compiler.Person   @role(event) end \n";
        KieBuilder kieBuilder = this.build(drl);
        Assert.assertFalse((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType type = kieBase.getFactType("org.drools.mvel.compiler", "Person");
    }

    @Test
    public void testCrossPackageDeclares() {
        String pkg1 = "package org.drools.mvel.compiler.test1; import org.drools.mvel.compiler.test2.GrandChild; import org.drools.mvel.compiler.test2.Child; import org.drools.mvel.compiler.test2.BarFuu; declare FuBaz foo : String end declare Parent    unknown : BarFuu end declare GreatChild extends GrandChild    father : Child end ";
        String pkg2 = "package org.drools.mvel.compiler.test2; import org.drools.mvel.compiler.test1.Parent; import org.drools.mvel.compiler.test1.FuBaz; declare BarFuu    baz : FuBaz end declare Child extends Parent end declare GrandChild extends Child    notknown : FuBaz end ";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(ks.newReleaseId("test", "foo", "1.0"));
        KieModuleModel km = ks.newKieModuleModel();
        km.newKieBaseModel("rules").addPackage("org.drools.mvel.compiler.test2").addPackage("org.drools.mvel.compiler.test1");
        kfs.writeKModuleXML(km.toXML());
        KieResources kr = ks.getResources();
        Resource r1 = kr.newByteArrayResource(pkg1.getBytes()).setResourceType(ResourceType.DRL).setSourcePath("org/drools/compiler/test1/p1.drl");
        Resource r2 = kr.newByteArrayResource(pkg2.getBytes()).setResourceType(ResourceType.DRL).setSourcePath("org/drools/compiler/test2/p2.drl");
        kfs.write(r1);
        kfs.write(r2);
        KieBuilder builder = ks.newKieBuilder(kfs);
        builder.buildAll();
        Assert.assertEquals(Collections.emptyList(), (Object)builder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
        KieContainer kc = ks.newKieContainer(builder.getKieModule().getReleaseId());
        FactType ft = kc.getKieBase("rules").getFactType("org.drools.mvel.compiler.test2", "Child");
        Assertions.assertThat((Object)ft).isNotNull();
        Assertions.assertThat((Class)ft.getFactClass()).isNotNull();
        Assert.assertEquals((Object)"org.drools.mvel.compiler.test1.Parent", (Object)ft.getFactClass().getSuperclass().getName());
    }

    @Test
    public void testUnknownField() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test; declare Pet end \n";
        KieBuilder kieBuilder = this.build(drl);
        Assert.assertFalse((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType factType = kieBase.getFactType("org.test", "Pet");
        Object instance = factType.newInstance();
        factType.get(instance, "unknownField");
        factType.set(instance, "unknownField", (Object)"myValue");
    }

    @Test
    public void testPositionalArguments() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String\n    age : int\nend\nrule R when \n    $p : Person( \"Mark\", 37; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assert.assertFalse((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType factType = kieBase.getFactType("org.test", "Person");
        Object instance = factType.newInstance();
        factType.set(instance, "name", (Object)"Mark");
        factType.set(instance, "age", (Object)37);
        ArrayList names = new ArrayList();
        KieSession ksession = kieBase.newKieSession();
        ksession.setGlobal("names", names);
        ksession.insert(instance);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertEquals((Object)"Mark", names.get(0));
    }

    @Test
    public void testExplictPositionalArguments() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String @Position(1)\n    age : int @Position(0)\nend\nrule R when \n    $p : Person( 37, \"Mark\"; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assert.assertFalse((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType factType = kieBase.getFactType("org.test", "Person");
        Object instance = factType.newInstance();
        factType.set(instance, "name", (Object)"Mark");
        factType.set(instance, "age", (Object)37);
        ArrayList names = new ArrayList();
        KieSession ksession = kieBase.newKieSession();
        ksession.setGlobal("names", names);
        ksession.insert(instance);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertEquals((Object)"Mark", names.get(0));
    }

    @Test
    public void testTooManyPositionalArguments() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String\n    age : int\nend\nrule R when \n    $p : Person( \"Mark\", 37, 42; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testOutOfRangePositions() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String @Position(3)\n    age : int @Position(1)\nend\nrule R when \n    $p : Person( 37, \"Mark\"; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testDuplicatedPositions() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String @Position(1)\n    age : int @Position(1)\nend\nrule R when \n    $p : Person( 37, \"Mark\"; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    private KieBuilder build(String drl) {
        return KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
    }

    @Test
    public void testMultipleAnnotationDeclarations() {
        String str1 = "";
        str1 = str1 + "package org.kie1 declare Foo \n   @role(event)     name : String     age : int end ";
        String str2 = "package org.kie3 declare org.kie1.Foo     @propertyReactive end ";
        String str3 = "package org.kie4; import org.kie1.Foo; rule Check when  $f : Foo( name == 'bar' ) then  modify( $f ) { setAge( 99 ); } end ";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1, str2, str3});
        FactType type = kieBase.getFactType("org.kie1", "Foo");
        Assert.assertEquals((long)2L, (long)type.getFields().size());
        Object foo = null;
        try {
            foo = type.newInstance();
            type.set(foo, "name", (Object)"bar");
            Assert.assertEquals((Object)"bar", (Object)type.get(foo, "name"));
        }
        catch (InstantiationException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)e.getMessage());
        }
        KieSession session = kieBase.newKieSession();
        FactHandle handle = session.insert(foo);
        int n = session.fireAllRules(5);
        Assert.assertTrue((boolean)(handle instanceof EventFactHandle));
        Assert.assertEquals((long)1L, (long)n);
        Assert.assertEquals((Object)99, (Object)type.get(foo, "age"));
    }

    @Test
    public void testDeclareWithExtensionAndOverride() {
        String s1 = "package test; global java.util.List list; declare Sub extends Sup  fld : String end declare Sup  fld : Object end rule Init when then insert( new Sub( 'aa' ) ); end rule CheckSup when  $s : Sup( $f : fld == 'aa' ) then   list.add( \"Sup\" + $f );  end rule CheckSub when  $s : Sub( $f : fld == 'aa' ) then   list.add( \"Sub\" + $f );  end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package test; global java.util.List list; declare Sub extends Sup  fld : String end declare Sup  fld : Object end rule Init when then insert( new Sub( 'aa' ) ); end rule CheckSup when  $s : Sup( $f : fld == 'aa' ) then   list.add( \"Sup\" + $f );  end rule CheckSub when  $s : Sub( $f : fld == 'aa' ) then   list.add( \"Sub\" + $f );  end "});
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("Supaa", "Subaa")));
        FactType sup = ks.getKieBase().getFactType("test", "Sup");
        FactType sub = ks.getKieBase().getFactType("test", "Sub");
        try {
            Method m1 = sup.getFactClass().getMethod("getFld", new Class[0]);
            Assertions.assertThat((Object)m1).isNotNull();
            Assert.assertEquals(Object.class, m1.getReturnType());
            Method m2 = sub.getFactClass().getMethod("getFld", new Class[0]);
            Assertions.assertThat((Object)m2).isNotNull();
            Assert.assertEquals(String.class, m2.getReturnType());
            Assert.assertEquals((long)0L, (long)sub.getFactClass().getFields().length);
            Assert.assertEquals((long)0L, (long)sub.getFactClass().getDeclaredFields().length);
            Assert.assertEquals((long)1L, (long)sup.getFactClass().getDeclaredFields().length);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeclarationOfClassWithNonStandardSetter() {
        String s1 = "package test; import " + BeanishClass.class.getCanonicalName() + "; declare " + BeanishClass.class.getSimpleName() + " @propertyReactive end rule Check when BeanishClass() @Watch( foo ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testDeclarationOfClassWithNonStandardSetterAndCanonicalName() {
        String s1 = "package test; import " + BeanishClass.class.getCanonicalName() + "; declare " + BeanishClass.class.getCanonicalName() + " @propertyReactive end rule Check when BeanishClass() @Watch( foo ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testDeclarationOfClassWithNonStandardSetterAndFulllName() {
        String s1 = "package test; import " + BeanishClass.class.getCanonicalName() + "; declare " + BeanishClass.class.getName() + " @propertyReactive end rule Check when BeanishClass() @watch( foo ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    public static class BeanishClass {
        private int foo;

        public int getFoo() {
            return this.foo;
        }

        public void setFoo(int x) {
            this.foo = x;
        }

        public void setFooAsString(String x) {
            this.foo = Integer.parseInt(x);
        }
    }

    public static interface Ext
    extends Base {
        @Override
        public String getFld();

        public void setFld(String var1);
    }

    public static interface Base {
        public Object getFld();

        public void setFld(Object var1);
    }

    public static class ClassC {
        private String name;
        private Integer age;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }
    }

    public static class EventBar {

        public static class Foo {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface FieldAnnotation {
        public String prop();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface KlassAnnotation {
        public String value();
    }
}

