/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.ConnectiveType;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.compiler.lang.descr.RelationalExprDescr;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRLExprParserTest {
    DrlExprParser parser;

    @Before
    public void setUp() throws Exception {
        new EvaluatorRegistry();
        this.parser = new DrlExprParser(LanguageLevelOption.DRL6);
    }

    @After
    public void tearDown() throws Exception {
        this.parser = null;
    }

    @Test
    public void testSimpleExpression() throws Exception {
        String source = "a > b";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)1L, (long)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)">", (Object)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"a", (Object)left.getExpression());
        Assert.assertEquals((Object)"b", (Object)right.getExpression());
    }

    @Test
    public void testAndConnective() throws Exception {
        String source = "a > b && 10 != 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)2L, (long)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)">", (Object)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"a", (Object)left.getExpression());
        Assert.assertEquals((Object)"b", (Object)right.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        Assert.assertEquals((Object)"!=", (Object)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"10", (Object)left.getExpression());
        Assert.assertEquals((Object)"20", (Object)right.getExpression());
    }

    @Test
    public void testConnective2() throws Exception {
        String source = "(a > b || 10 != 20) && someMethod(10) == 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)2L, (long)result.getDescrs().size());
        ConstraintConnectiveDescr or = (ConstraintConnectiveDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)ConnectiveType.OR, (Object)or.getConnective());
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)">", (Object)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"a", (Object)left.getExpression());
        Assert.assertEquals((Object)"b", (Object)right.getExpression());
        expr = (RelationalExprDescr)or.getDescrs().get(1);
        Assert.assertEquals((Object)"!=", (Object)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"10", (Object)left.getExpression());
        Assert.assertEquals((Object)"20", (Object)right.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        Assert.assertEquals((Object)"==", (Object)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"someMethod(10)", (Object)left.getExpression());
        Assert.assertEquals((Object)"20", (Object)right.getExpression());
    }

    @Test
    public void testBinding() throws Exception {
        String source = "$x : property";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)1L, (long)result.getDescrs().size());
        BindingDescr bind = (BindingDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"property", (Object)bind.getExpression());
    }

    @Test
    public void testBindingConstraint() throws Exception {
        String source = "$x : property > value";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)1L, (long)result.getDescrs().size());
        RelationalExprDescr rel = (RelationalExprDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)">", (Object)rel.getOperator());
        BindingDescr bind = (BindingDescr)rel.getLeft();
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"property", (Object)bind.getExpression());
        AtomicExprDescr right = (AtomicExprDescr)rel.getRight();
        Assert.assertEquals((Object)"value", (Object)right.getExpression());
    }

    @Test
    public void testBindingWithRestrictions() throws Exception {
        String source = "$x : property > value && < 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)2L, (long)result.getDescrs().size());
        RelationalExprDescr rel = (RelationalExprDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)">", (Object)rel.getOperator());
        BindingDescr bind = (BindingDescr)rel.getLeft();
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"property", (Object)bind.getExpression());
        AtomicExprDescr right = (AtomicExprDescr)rel.getRight();
        Assert.assertEquals((Object)"value", (Object)right.getExpression());
        rel = (RelationalExprDescr)result.getDescrs().get(1);
        Assert.assertEquals((Object)"<", (Object)rel.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)rel.getLeft();
        Assert.assertEquals((Object)"property", (Object)left.getExpression());
        right = (AtomicExprDescr)rel.getRight();
        Assert.assertEquals((Object)"20", (Object)right.getExpression());
    }

    @Test
    public void testDoubleBinding() throws Exception {
        String source = "$x : x.m( 1, a ) && $y : y[z].foo";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)2L, (long)result.getDescrs().size());
        BindingDescr bind = (BindingDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)"$x", (Object)bind.getVariable());
        Assert.assertEquals((Object)"x.m( 1, a )", (Object)bind.getExpression());
        bind = (BindingDescr)result.getDescrs().get(1);
        Assert.assertEquals((Object)"$y", (Object)bind.getVariable());
        Assert.assertEquals((Object)"y[z].foo", (Object)bind.getExpression());
    }

    @Test
    public void testDeepBinding() throws Exception {
        String source = "($a : a > $b : b[10].prop || 10 != 20) && $x : someMethod(10) == 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)2L, (long)result.getDescrs().size());
        ConstraintConnectiveDescr or = (ConstraintConnectiveDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)ConnectiveType.OR, (Object)or.getConnective());
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)">", (Object)expr.getOperator());
        BindingDescr leftBind = (BindingDescr)expr.getLeft();
        BindingDescr rightBind = (BindingDescr)expr.getRight();
        Assert.assertEquals((Object)"$a", (Object)leftBind.getVariable());
        Assert.assertEquals((Object)"a", (Object)leftBind.getExpression());
        Assert.assertEquals((Object)"$b", (Object)rightBind.getVariable());
        Assert.assertEquals((Object)"b[10].prop", (Object)rightBind.getExpression());
        expr = (RelationalExprDescr)or.getDescrs().get(1);
        Assert.assertEquals((Object)"!=", (Object)expr.getOperator());
        AtomicExprDescr leftExpr = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr rightExpr = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"10", (Object)leftExpr.getExpression());
        Assert.assertEquals((Object)"20", (Object)rightExpr.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        Assert.assertEquals((Object)"==", (Object)expr.getOperator());
        leftBind = (BindingDescr)expr.getLeft();
        rightExpr = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"$x", (Object)leftBind.getVariable());
        Assert.assertEquals((Object)"someMethod(10)", (Object)leftBind.getExpression());
        Assert.assertEquals((Object)"20", (Object)rightExpr.getExpression());
    }

    @Test(timeout=10000L)
    public void testNestedExpression() throws Exception {
        String source = "(((((((((((((((((((((((((((((((((((((((((((((((((( a > b ))))))))))))))))))))))))))))))))))))))))))))))))))";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        Assert.assertEquals((long)1L, (long)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        Assert.assertEquals((Object)">", (Object)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assert.assertEquals((Object)"a", (Object)left.getExpression());
        Assert.assertEquals((Object)"b", (Object)right.getExpression());
    }
}

