/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DRLFactory;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.DRL6Parser;
import org.drools.compiler.lang.DRLParser;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AccumulateImportDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.CollectDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.MVELExprDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class RuleParserTest {
    private DRLParser parser;

    @Before
    public void setUp() throws Exception {
        new EvaluatorRegistry();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPackage_OneSegment() throws Exception {
        String packageName = (String)this.parse("packageStatement", "package foo");
        Assert.assertEquals((Object)"foo", (Object)packageName);
    }

    @Test
    public void testPackage_MultipleSegments() throws Exception {
        String packageName = (String)this.parse("packageStatement", "package foo.bar.baz;");
        Assert.assertEquals((Object)"foo.bar.baz", (Object)packageName);
    }

    @Test
    public void testPackage() throws Exception {
        String source = "package foo.bar.baz";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse((Reader)new StringReader("package foo.bar.baz"));
        Assert.assertFalse((boolean)parser.hasErrors());
        Assert.assertEquals((Object)"foo.bar.baz", (Object)pkg.getName());
    }

    @Test
    public void testPackageWithError() throws Exception {
        String source = "package 12 foo.bar.baz";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(true, (Reader)new StringReader("package 12 foo.bar.baz"));
        Assert.assertTrue((boolean)parser.hasErrors());
        Assert.assertEquals((Object)"foo.bar.baz", (Object)pkg.getName());
    }

    @Test
    public void testPackageWithError2() throws Exception {
        String source = "package 12 12312 231";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(true, (Reader)new StringReader("package 12 12312 231"));
        Assert.assertTrue((boolean)parser.hasErrors());
        Assert.assertEquals((Object)"", (Object)pkg.getName());
    }

    @Test
    public void testCompilationUnit() throws Exception {
        String source = "package foo; import com.foo.Bar; import com.foo.Baz;";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo; import com.foo.Bar; import com.foo.Baz;");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)"foo", (Object)pkg.getName());
        Assert.assertEquals((long)2L, (long)pkg.getImports().size());
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        Assert.assertEquals((Object)"com.foo.Bar", (Object)impdescr.getTarget());
        Assert.assertEquals((long)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (long)impdescr.getStartCharacter());
        Assert.assertEquals((long)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (long)impdescr.getEndCharacter());
        impdescr = (ImportDescr)pkg.getImports().get(1);
        Assert.assertEquals((Object)"com.foo.Baz", (Object)impdescr.getTarget());
        Assert.assertEquals((long)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (long)impdescr.getStartCharacter());
        Assert.assertEquals((long)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (long)impdescr.getEndCharacter());
    }

    @Test
    public void testFunctionImport() throws Exception {
        String source = "package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)"foo", (Object)pkg.getName());
        Assert.assertEquals((long)2L, (long)pkg.getImports().size());
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        Assert.assertEquals((Object)"foo.bar.*", (Object)impdescr.getTarget());
        Assert.assertEquals((long)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()), (long)impdescr.getStartCharacter());
        Assert.assertEquals((long)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (long)impdescr.getEndCharacter());
        impdescr = (ImportDescr)pkg.getImports().get(1);
        Assert.assertEquals((Object)"baz.Baz", (Object)impdescr.getTarget());
        Assert.assertEquals((long)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()), (long)impdescr.getStartCharacter());
        Assert.assertEquals((long)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (long)impdescr.getEndCharacter());
        Assert.assertEquals((long)2L, (long)pkg.getFunctionImports().size());
        impdescr = (ImportDescr)pkg.getFunctionImports().get(0);
        Assert.assertEquals((Object)"java.lang.Math.max", (Object)impdescr.getTarget());
        Assert.assertEquals((long)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()), (long)impdescr.getStartCharacter());
        Assert.assertEquals((long)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()) + ("import function " + impdescr.getTarget()).length()), (long)impdescr.getEndCharacter());
        impdescr = (ImportDescr)pkg.getFunctionImports().get(1);
        Assert.assertEquals((Object)"java.lang.Math.min", (Object)impdescr.getTarget());
        Assert.assertEquals((long)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()), (long)impdescr.getStartCharacter());
        Assert.assertEquals((long)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()) + ("import function " + impdescr.getTarget()).length()), (long)impdescr.getEndCharacter());
    }

    @Test
    public void testGlobal1() throws Exception {
        String source = "package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)"foo.bar.baz", (Object)pkg.getName());
        Assert.assertEquals((long)1L, (long)pkg.getImports().size());
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        Assert.assertEquals((Object)"com.foo.Bar", (Object)impdescr.getTarget());
        Assert.assertEquals((long)"package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("import " + impdescr.getTarget()), (long)impdescr.getStartCharacter());
        Assert.assertEquals((long)("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (long)impdescr.getEndCharacter());
        Assert.assertEquals((long)2L, (long)pkg.getGlobals().size());
        GlobalDescr global = (GlobalDescr)pkg.getGlobals().get(0);
        Assert.assertEquals((Object)"java.util.List<java.util.Map<String,Integer>>", (Object)global.getType());
        Assert.assertEquals((Object)"aList", (Object)global.getIdentifier());
        Assert.assertEquals((long)"package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType()), (long)global.getStartCharacter());
        Assert.assertEquals((long)("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType() + " " + global.getIdentifier()) + ("global " + global.getType() + " " + global.getIdentifier()).length()), (long)global.getEndCharacter());
        global = (GlobalDescr)pkg.getGlobals().get(1);
        Assert.assertEquals((Object)"Integer", (Object)global.getType());
        Assert.assertEquals((Object)"aNumber", (Object)global.getIdentifier());
        Assert.assertEquals((long)"package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType()), (long)global.getStartCharacter());
        Assert.assertEquals((long)("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType() + " " + global.getIdentifier()) + ("global " + global.getType() + " " + global.getIdentifier()).length()), (long)global.getEndCharacter());
    }

    @Test
    public void testGlobal() throws Exception {
        PackageDescr pack = (PackageDescr)this.parseResource("compilationUnit", "globals.drl");
        Assert.assertEquals((long)1L, (long)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        Assert.assertEquals((long)1L, (long)pack.getImports().size());
        Assert.assertEquals((long)2L, (long)pack.getGlobals().size());
        GlobalDescr foo = (GlobalDescr)pack.getGlobals().get(0);
        Assert.assertEquals((Object)"java.lang.String", (Object)foo.getType());
        Assert.assertEquals((Object)"foo", (Object)foo.getIdentifier());
        GlobalDescr bar = (GlobalDescr)pack.getGlobals().get(1);
        Assert.assertEquals((Object)"java.lang.Integer", (Object)bar.getType());
        Assert.assertEquals((Object)"bar", (Object)bar.getIdentifier());
    }

    @Test
    public void testFunctionImport2() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_FunctionImport.drl");
        Assert.assertEquals((long)2L, (long)pkg.getFunctionImports().size());
        Assert.assertEquals((Object)"abd.def.x", (Object)((FunctionImportDescr)pkg.getFunctionImports().get(0)).getTarget());
        Assert.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getStartCharacter() == -1 ? 1 : 0) != 0);
        Assert.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getEndCharacter() == -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"qed.wah.*", (Object)((FunctionImportDescr)pkg.getFunctionImports().get(1)).getTarget());
        Assert.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getStartCharacter() == -1 ? 1 : 0) != 0);
        Assert.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getEndCharacter() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFromComplexAcessor() throws Exception {
        String source = "rule \"Invalid customer id\" ruleflow-group \"validate\" lock-on-active true \n when \n     o: Order( ) \n     not( Customer( ) from customerService.getCustomer(o.getCustomerId()) ) \n then \n     System.err.println(\"Invalid customer id found!\"); \n     o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"Invalid customer id", (Object)rule.getName());
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        PatternDescr customer = (PatternDescr)not.getDescrs().get(0);
        Assert.assertEquals((Object)"Customer", (Object)customer.getObjectType());
        Assert.assertEquals((Object)"customerService.getCustomer(o.getCustomerId())", (Object)((FromDescr)customer.getSource()).getDataSource().getText());
    }

    @Test
    public void testFromWithInlineList() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n not( Number( ) from [1, 2, 3] ) \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"XYZ", (Object)rule.getName());
        PatternDescr number = (PatternDescr)((NotDescr)rule.getLhs().getDescrs().get(1)).getDescrs().get(0);
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)((FromDescr)number.getSource()).getDataSource().toString());
    }

    @Test
    public void testFromWithInlineListMethod() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n Number( ) from [1, 2, 3].sublist(1, 2) \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"XYZ", (Object)rule.getName());
        Assert.assertFalse((boolean)this.parser.hasErrors());
        PatternDescr number = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"[1, 2, 3].sublist(1, 2)", (Object)((FromDescr)number.getSource()).getDataSource().toString());
    }

    @Test
    public void testFromWithInlineListIndex() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n Number( ) from [1, 2, 3][1] \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"XYZ", (Object)rule.getName());
        Assert.assertFalse((boolean)this.parser.hasErrors());
        PatternDescr number = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"[1, 2, 3][1]", (Object)((FromDescr)number.getSource()).getDataSource().toString());
    }

    @Test
    public void testRuleWithoutEnd() throws Exception {
        String source = "rule \"Invalid customer id\" \n when \n o: Order( ) \n then \n System.err.println(\"Invalid customer id found!\"); \n";
        this.parse("compilationUnit", source);
        Assert.assertTrue((boolean)this.parser.hasErrors());
    }

    @Test
    public void testOrWithSpecialBind() throws Exception {
        String source = "rule \"A and (B or C or D)\" \n    when \n        pdo1 : ParametricDataObject( paramID == 101, stringValue == \"1000\" ) and \n        pdo2 :(ParametricDataObject( paramID == 101, stringValue == \"1001\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1002\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1003\" )) \n    then \n        System.out.println( \"Rule: A and (B or C or D) Fired. pdo1: \" + pdo1 +  \" pdo2: \"+ pdo2); \nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = rule.getLhs();
        Assert.assertEquals((long)2L, (long)lhs.getDescrs().size());
        PatternDescr pdo1 = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"pdo1", (Object)pdo1.getIdentifier());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((long)3L, (long)or.getDescrs().size());
        for (BaseDescr pdo2 : or.getDescrs()) {
            Assert.assertEquals((Object)"pdo2", (Object)((PatternDescr)pdo2).getIdentifier());
        }
    }

    @Test
    public void testCompatibleRestriction() throws Exception {
        String source = "package com.sample  rule test  when  Test( ( text == null || text2 matches \"\" ) )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertEquals((Object)"com.sample", (Object)pkg.getName());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"test", (Object)rule.getName());
        ExprConstraintDescr expr = (ExprConstraintDescr)((PatternDescr)rule.getLhs().getDescrs().get(0)).getDescrs().get(0);
        Assert.assertEquals((Object)"( text == null || text2 matches \"\" )", (Object)expr.getText());
    }

    @Test
    public void testSimpleConstraint() throws Exception {
        String source = "package com.sample  rule test  when  Cheese( type == 'stilton', price > 10 )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertEquals((Object)"com.sample", (Object)pkg.getName());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"test", (Object)rule.getName());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr constraint = (AndDescr)pattern.getConstraint();
        Assert.assertEquals((long)2L, (long)constraint.getDescrs().size());
        Assert.assertEquals((Object)"type == \"stilton\"", (Object)((BaseDescr)constraint.getDescrs().get(0)).toString());
        Assert.assertEquals((Object)"price > 10", (Object)((BaseDescr)constraint.getDescrs().get(1)).toString());
    }

    @Test
    public void testStringEscapes() throws Exception {
        String source = "package com.sample  rule test  when  Cheese( type matches \"\\..*\\\\.\" )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assert.assertEquals((Object)"com.sample", (Object)pkg.getName());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"test", (Object)rule.getName());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr constraint = (AndDescr)pattern.getConstraint();
        Assert.assertEquals((long)1L, (long)constraint.getDescrs().size());
        Assert.assertEquals((Object)"type matches \"\\..*\\\\.\"", (Object)((BaseDescr)constraint.getDescrs().get(0)).toString());
    }

    @Test
    public void testDialect() throws Exception {
        String source = "dialect 'mvel'";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "dialect 'mvel'");
        AttributeDescr attr = (AttributeDescr)pkg.getAttributes().get(0);
        Assert.assertEquals((Object)"dialect", (Object)attr.getName());
        Assert.assertEquals((Object)"mvel", (Object)attr.getValue());
    }

    @Test
    public void testDialect2() throws Exception {
        String source = "dialect \"mvel\"";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "dialect \"mvel\"");
        AttributeDescr attr = (AttributeDescr)pkg.getAttributes().get(0);
        Assert.assertEquals((Object)"dialect", (Object)attr.getName());
        Assert.assertEquals((Object)"mvel", (Object)attr.getValue());
    }

    @Test
    public void testEmptyRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "empty_rule.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"empty", (Object)rule.getName());
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        Assertions.assertThat((Object)rule.getConsequence()).isNotNull();
    }

    @Test
    public void testKeywordCollisions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eol_funny_business.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
    }

    @Test
    public void testTernaryExpression() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "ternary_expression.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        this.assertEqualsIgnoreWhitespace("if (speed > speedLimit ? true : false;) pullEmOver();", (String)rule.getConsequence());
    }

    @Test
    public void testFunctionWithArrays() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "function_arrays.drl");
        Assert.assertEquals((Object)"foo", (Object)pkg.getName());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        this.assertEqualsIgnoreWhitespace("yourFunction(new String[3] {\"a\",\"b\",\"c\"});", (String)rule.getConsequence());
        FunctionDescr func = (FunctionDescr)pkg.getFunctions().get(0);
        Assert.assertEquals((Object)"String[]", (Object)func.getReturnType());
        Assert.assertEquals((Object)"args[]", func.getParameterNames().get(0));
        Assert.assertEquals((Object)"String", func.getParameterTypes().get(0));
    }

    @Test
    public void testAlmostEmptyRule() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "almost_empty_rule.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)pkg).isNotNull();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"almost_empty", (Object)rule.getName());
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        Assert.assertEquals((Object)"", (Object)((String)rule.getConsequence()).trim());
    }

    @Test
    public void testQuotedStringNameRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "quoted_string_name_rule.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"quoted string name", (Object)rule.getName());
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        Assert.assertEquals((Object)"", (Object)((String)rule.getConsequence()).trim());
    }

    @Test
    public void testNoLoop() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "no-loop.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"rule1", (Object)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("no-loop");
        Assert.assertEquals((Object)"false", (Object)att.getValue());
        Assert.assertEquals((Object)"no-loop", (Object)att.getName());
    }

    @Test
    public void testAutofocus() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "autofocus.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"rule1", (Object)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("auto-focus");
        Assert.assertEquals((Object)"true", (Object)att.getValue());
        Assert.assertEquals((Object)"auto-focus", (Object)att.getName());
    }

    @Test
    public void testRuleFlowGroup() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "ruleflowgroup.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"rule1", (Object)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("ruleflow-group");
        Assert.assertEquals((Object)"a group", (Object)att.getValue());
        Assert.assertEquals((Object)"ruleflow-group", (Object)att.getName());
    }

    @Test
    public void testConsequenceWithDeclaration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "declaration-in-consequence.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"myrule", (Object)rule.getName());
        String expected = "int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;";
        this.assertEqualsIgnoreWhitespace("int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;", (String)rule.getConsequence());
        Assert.assertTrue((((String)rule.getConsequence()).indexOf("++") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((String)rule.getConsequence()).indexOf("--") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((String)rule.getConsequence()).indexOf("+=") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((String)rule.getConsequence()).indexOf("==") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleParseLhs() throws Exception {
        String text = "rule X when Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr lhs = rule.getLhs();
        Assert.assertEquals((long)1L, (long)lhs.getDescrs().size());
        Assert.assertEquals((long)2L, (long)((OrDescr)lhs.getDescrs().get(0)).getDescrs().size());
    }

    @Test
    public void testRuleParseLhsWithStringQuotes() throws Exception {
        String text = "rule X when Person( location==\"atlanta\\\"\") then end\n";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Person( location==\"atlanta\\\"\") then end\n");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr lhs = rule.getLhs();
        ExprConstraintDescr constr = (ExprConstraintDescr)((PatternDescr)lhs.getDescrs().get(0)).getDescrs().get(0);
        Assert.assertEquals((Object)"location==\"atlanta\\\"\"", (Object)constr.getText());
    }

    @Test
    public void testRuleParseLhsWithStringQuotes2() throws Exception {
        String text = "rule X when Cheese( $x: type, type == \"s\\tti\\\"lto\\nn\" ) then end\n";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese( $x: type, type == \"s\\tti\\\"lto\\nn\" ) then end\n");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr lhs = rule.getLhs();
        ExprConstraintDescr constr = (ExprConstraintDescr)((PatternDescr)lhs.getDescrs().get(0)).getDescrs().get(1);
        Assert.assertEquals((Object)"type == \"s\\tti\\\"lto\\nn\"", (Object)constr.getText());
    }

    @Test
    public void testLiteralBoolAndNegativeNumbersRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "literal_bool_and_negative.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        this.assertEqualsIgnoreWhitespace("cons();", (String)rule.getConsequence());
        AndDescr lhs = rule.getLhs();
        Assert.assertEquals((long)3L, (long)lhs.getDescrs().size());
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assert.assertEquals((Object)"bar == false", (Object)fld.getExpression());
        pattern = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((long)1L, (long)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assert.assertEquals((Object)"boo > -42", (Object)fld.getText());
        pattern = (PatternDescr)lhs.getDescrs().get(2);
        Assert.assertEquals((long)1L, (long)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assert.assertEquals((Object)"boo > -42.42", (Object)fld.getText());
    }

    @Test
    public void testChunkWithoutParens() throws Exception {
        String input = "( foo )";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assert.assertEquals((Object)"foo", (Object)returnData);
    }

    @Test
    public void testChunkWithParens() throws Exception {
        String input = "(fnord())";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assert.assertEquals((Object)"fnord()", (Object)returnData);
    }

    @Test
    public void testChunkWithParensAndQuotedString() throws Exception {
        String input = "( fnord( \"cheese\" ) )";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assert.assertEquals((Object)"fnord( \"cheese\" )", (Object)returnData);
    }

    @Test
    public void testChunkWithRandomCharac5ters() throws Exception {
        String input = "( %*9dkj)";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assert.assertEquals((Object)"%*9dkj", (Object)returnData);
    }

    @Test
    public void testEmptyPattern() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_EmptyPattern.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"simple rule", (Object)ruleDescr.getName());
        Assertions.assertThat((Object)ruleDescr.getLhs()).isNotNull();
        Assert.assertEquals((long)1L, (long)ruleDescr.getLhs().getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)ruleDescr.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)0L, (long)patternDescr.getConstraint().getDescrs().size());
        Assert.assertEquals((Object)"Cheese", (Object)patternDescr.getObjectType());
    }

    @Test
    public void testSimpleMethodCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleMethodCallWithFrom.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr method = (MVELExprDescr)from.getDataSource();
        Assert.assertEquals((Object)"something.doIt( foo,bar,42,\"hello\",[ a : \"b\", \"something\" : 42, \"a\" : foo, x : [x:y]],\"end\", [a, \"b\", 42] )", (Object)method.getExpression());
    }

    @Test
    public void testSimpleFunctionCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleFunctionCallWithFrom.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr func = (MVELExprDescr)from.getDataSource();
        Assert.assertEquals((Object)"doIt( foo,bar,42,\"hello\",[ a : \"b\", \"something\" : 42, \"a\" : foo, x : [x:y]],\"end\", [a, \"b\", 42] )", (Object)func.getExpression());
    }

    @Test
    public void testSimpleAccessorWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleAccessorWithFrom.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        Assert.assertEquals((Object)"something.doIt", (Object)accessor.getExpression());
    }

    @Test
    public void testSimpleAccessorAndArgWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleAccessorArgWithFrom.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        Assert.assertEquals((Object)"something.doIt[\"key\"]", (Object)accessor.getExpression());
    }

    @Test
    public void testComplexChainedAcessor() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_ComplexChainedCallWithFrom.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        Assert.assertEquals((Object)"doIt1( foo,bar,42,\"hello\",[ a : \"b\"], [a, \"b\", 42] ).doIt2(bar, [a, \"b\", 42]).field[\"key\"]", (Object)accessor.getExpression());
    }

    @Test
    public void testFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "from.drl");
        Assert.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"using_from", (Object)rule.getName());
        Assert.assertEquals((long)9L, (long)rule.getLhs().getDescrs().size());
    }

    @Test
    public void testSimpleRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "simple_rule.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assert.assertEquals((long)22L, (long)rule.getConsequenceLine());
        Assert.assertEquals((long)2L, (long)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)3L, (long)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"foo3", (Object)first.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)first.getObjectType());
        Assert.assertEquals((long)1L, (long)first.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)first.getConstraint();
        ExprConstraintDescr constraint = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assertions.assertThat((Object)constraint).isNotNull();
        Assert.assertEquals((Object)"a==3", (Object)constraint.getExpression());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((Object)"foo4", (Object)second.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)second.getObjectType());
        fieldAnd = (AndDescr)second.getConstraint();
        Assert.assertEquals((long)1L, (long)fieldAnd.getDescrs().size());
        ExprConstraintDescr binding = (ExprConstraintDescr)second.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"a4:a==4", (Object)binding.getExpression());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        Assert.assertNull((Object)third.getIdentifier());
        Assert.assertEquals((Object)"Baz", (Object)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    @Test
    public void testRestrictionsMultiple() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "restrictions_test.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertEquals((long)1L, (long)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assert.assertEquals((Object)"age > 30 && < 40", (Object)fld.getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"Vehicle", (Object)pattern.getObjectType());
        Assert.assertEquals((long)2L, (long)pattern.getConstraint().getDescrs().size());
        and = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assert.assertEquals((Object)"type == \"sedan\" || == \"wagon\"", (Object)fld.getExpression());
        fld = (ExprConstraintDescr)and.getDescrs().get(1);
        Assert.assertEquals((Object)"age < 3", (Object)fld.getExpression());
    }

    @Test
    public void testLineNumberInAST() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "simple_rule.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assert.assertEquals((long)22L, (long)rule.getConsequenceLine());
        Assert.assertEquals((long)2L, (long)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)3L, (long)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"foo3", (Object)first.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)first.getObjectType());
        Assert.assertEquals((long)1L, (long)first.getConstraint().getDescrs().size());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((Object)"foo4", (Object)second.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)second.getObjectType());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        Assert.assertEquals((Object)"Baz", (Object)third.getObjectType());
        Assert.assertEquals((long)19L, (long)first.getLine());
        Assert.assertEquals((long)20L, (long)second.getLine());
        Assert.assertEquals((long)21L, (long)third.getLine());
    }

    @Test
    public void testLineNumberIncludingCommentsInRHS() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_CommentLineNumbersInConsequence.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        String rhs = (String)((RuleDescr)pkg.getRules().get(0)).getConsequence();
        String expected = "\\s*//woot$\\s*first$\\s*$\\s*//$\\s*$\\s*/\\* lala$\\s*$\\s*\\*/$\\s*second$\\s*";
        Assert.assertTrue((boolean)Pattern.compile(expected, 40).matcher(rhs).matches());
    }

    @Test
    public void testLhsSemicolonDelim() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "lhs_semicolon_delim.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)3L, (long)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"foo3", (Object)first.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)first.getObjectType());
        Assert.assertEquals((long)1L, (long)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assertions.assertThat((Object)fld).isNotNull();
        Assert.assertEquals((Object)"a==3", (Object)fld.getExpression());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((Object)"foo4", (Object)second.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)second.getObjectType());
        Assert.assertEquals((long)1L, (long)second.getDescrs().size());
        ExprConstraintDescr fieldBindingDescr = (ExprConstraintDescr)second.getDescrs().get(0);
        Assert.assertEquals((Object)"a4:a==4", (Object)fieldBindingDescr.getExpression());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        Assert.assertNull((Object)third.getIdentifier());
        Assert.assertEquals((Object)"Baz", (Object)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    @Test
    public void testNotNode() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_not.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        Assert.assertEquals((long)1L, (long)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
        Assert.assertEquals((long)1L, (long)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assert.assertEquals((Object)"type == \"stilton\"", (Object)fld.getExpression());
    }

    @Test
    public void testNotExistWithBrackets() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "not_exist_with_brackets.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        Assert.assertEquals((long)2L, (long)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
        ExistsDescr ex = (ExistsDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((long)1L, (long)ex.getDescrs().size());
        PatternDescr exPattern = (PatternDescr)ex.getDescrs().get(0);
        Assert.assertEquals((Object)"Foo", (Object)exPattern.getObjectType());
    }

    @Test
    public void testSimpleQuery() throws Exception {
        QueryDescr query = (QueryDescr)this.parseResource("query", "simple_query.drl");
        Assertions.assertThat((Object)query).isNotNull();
        Assert.assertEquals((Object)"simple_query", (Object)query.getName());
        AndDescr lhs = query.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)3L, (long)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"foo3", (Object)first.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)first.getObjectType());
        Assert.assertEquals((long)1L, (long)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assertions.assertThat((Object)fld).isNotNull();
        Assert.assertEquals((Object)"a==3", (Object)fld.getExpression());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((Object)"foo4", (Object)second.getIdentifier());
        Assert.assertEquals((Object)"Bar", (Object)second.getObjectType());
        Assert.assertEquals((long)1L, (long)second.getDescrs().size());
        ExprConstraintDescr bindingDescr = (ExprConstraintDescr)second.getDescrs().get(0);
        Assert.assertEquals((Object)"a4:a==4", (Object)bindingDescr.getExpression());
    }

    @Test
    public void testQueryRuleMixed() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "query_and_rule.drl");
        Assert.assertEquals((long)4L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"bar", (Object)rule.getName());
        QueryDescr query = (QueryDescr)pkg.getRules().get(1);
        Assert.assertEquals((Object)"simple_query", (Object)query.getName());
        rule = (RuleDescr)pkg.getRules().get(2);
        Assert.assertEquals((Object)"bar2", (Object)rule.getName());
        query = (QueryDescr)pkg.getRules().get(3);
        Assert.assertEquals((Object)"simple_query2", (Object)query.getName());
    }

    @Test
    public void testMultipleRules() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "multiple_rules.drl");
        List rules = pkg.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        RuleDescr rule0 = (RuleDescr)rules.get(0);
        Assert.assertEquals((Object)"Like Stilton", (Object)rule0.getName());
        RuleDescr rule1 = (RuleDescr)rules.get(1);
        Assert.assertEquals((Object)"Like Cheddar", (Object)rule1.getName());
        AndDescr lhs = rule1.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)1L, (long)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule0.getConsequence());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)first.getObjectType());
        lhs = rule1.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)1L, (long)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule1.getConsequence());
        first = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)first.getObjectType());
    }

    @Test
    public void testExpanderLineSpread() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(this.getReader("expander_spread_lines.dslr"), this.getReader("complex.dsl"));
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        Assertions.assertThat((String)((String)rule.getConsequence())).isNotNull();
    }

    @Test
    public void testExpanderMultipleConstraints() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints.dslr"), this.getReader("multiple_constraints.dsl"));
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertEquals((long)2L, (long)pattern.getConstraint().getDescrs().size());
        Assert.assertEquals((Object)"age < 42", (Object)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getExpression());
        Assert.assertEquals((Object)"location==atlanta", (Object)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"Bar", (Object)pattern.getObjectType());
        Assertions.assertThat((String)((String)rule.getConsequence())).isNotNull();
    }

    @Test
    public void testExpanderMultipleConstraintsFlush() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints_flush.dslr"), this.getReader("multiple_constraints.dsl"));
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertEquals((long)2L, (long)pattern.getConstraint().getDescrs().size());
        Assert.assertEquals((Object)"age < 42", (Object)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getExpression());
        Assert.assertEquals((Object)"location==atlanta", (Object)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getExpression());
        Assertions.assertThat((String)((String)rule.getConsequence())).isNotNull();
    }

    @Test
    public void testBasicBinding() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "basic_binding.drl");
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        Assert.assertEquals((long)1L, (long)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)cheese.getObjectType());
        Assert.assertEquals((long)1L, (long)cheese.getConstraint().getDescrs().size());
        ExprConstraintDescr fieldBinding = (ExprConstraintDescr)cheese.getDescrs().get(0);
        Assert.assertEquals((Object)"$type:type", (Object)fieldBinding.getExpression());
    }

    @Test
    public void testBoundVariables() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "bindings.drl");
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        Assert.assertEquals((long)2L, (long)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)cheese.getObjectType());
        Assert.assertEquals((long)1L, (long)cheese.getDescrs().size());
        ExprConstraintDescr fieldBinding = (ExprConstraintDescr)cheese.getDescrs().get(0);
        Assert.assertEquals((Object)"$type : type == \"stilton\"", (Object)fieldBinding.getExpression());
        PatternDescr person = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((long)2L, (long)person.getDescrs().size());
        fieldBinding = (ExprConstraintDescr)person.getDescrs().get(0);
        Assert.assertEquals((Object)"$name : name == \"bob\"", (Object)fieldBinding.getExpression());
        ExprConstraintDescr fld = (ExprConstraintDescr)person.getDescrs().get(1);
        Assert.assertEquals((Object)"likes == $type", (Object)fld.getExpression());
    }

    @Test
    public void testOrNesting() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_nesting.drl");
        Assertions.assertThat((Object)pkg).isNotNull();
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        PatternDescr first = (PatternDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)first.getObjectType());
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        Assert.assertEquals((long)2L, (long)and.getDescrs().size());
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)left.getObjectType());
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        Assert.assertEquals((Object)"Cheese", (Object)right.getObjectType());
    }

    @Test
    public void testAndOrRules() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "and_or_rule.drl");
        Assertions.assertThat((Object)pkg).isNotNull();
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        AndDescr and = rule.getLhs();
        Assert.assertEquals((long)3L, (long)and.getDescrs().size());
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)left.getObjectType());
        Assert.assertEquals((Object)"Cheese", (Object)right.getObjectType());
        Assert.assertEquals((long)1L, (long)left.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)left.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"name == \"mark\"", (Object)fld.getExpression());
        Assert.assertEquals((long)1L, (long)right.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)right.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"type == \"stilton\"", (Object)fld.getExpression());
        OrDescr or = (OrDescr)and.getDescrs().get(2);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        left = (PatternDescr)or.getDescrs().get(0);
        right = (PatternDescr)or.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)left.getObjectType());
        Assert.assertEquals((Object)"Cheese", (Object)right.getObjectType());
        Assert.assertEquals((long)1L, (long)left.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)left.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"name == \"mark\"", (Object)fld.getExpression());
        Assert.assertEquals((long)1L, (long)right.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)right.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"type == \"stilton\"", (Object)fld.getExpression());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" );", (String)rule.getConsequence());
    }

    @Test
    public void testOrWithBinding() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        PatternDescr leftPattern = (PatternDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)leftPattern.getObjectType());
        Assert.assertEquals((Object)"foo", (Object)leftPattern.getIdentifier());
        PatternDescr rightPattern = (PatternDescr)or.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)rightPattern.getObjectType());
        Assert.assertEquals((Object)"foo", (Object)rightPattern.getIdentifier());
        PatternDescr cheeseDescr = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"Cheese", (Object)cheeseDescr.getObjectType());
        Assert.assertEquals(null, (Object)cheeseDescr.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testOrBindingComplex() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding_complex.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)firstFact.getObjectType());
        Assert.assertEquals((Object)"foo", (Object)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)secondFact.getObjectType());
        Assert.assertEquals((long)1L, (long)secondFact.getConstraint().getDescrs().size());
        Assert.assertEquals((Object)"foo", (Object)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testOrBindingWithBrackets() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding_with_brackets.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)firstFact.getObjectType());
        Assert.assertEquals((Object)"foo", (Object)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)secondFact.getObjectType());
        Assert.assertEquals((Object)"foo", (Object)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testBracketsPrecedence() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "brackets_precedence.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        AndDescr rootAnd = rule.getLhs();
        Assert.assertEquals((long)2L, (long)rootAnd.getDescrs().size());
        OrDescr leftOr = (OrDescr)rootAnd.getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)leftOr.getDescrs().size());
        NotDescr not = (NotDescr)leftOr.getDescrs().get(0);
        PatternDescr foo1 = (PatternDescr)not.getDescrs().get(0);
        Assert.assertEquals((Object)"Foo", (Object)foo1.getObjectType());
        PatternDescr foo2 = (PatternDescr)leftOr.getDescrs().get(1);
        Assert.assertEquals((Object)"Foo", (Object)foo2.getObjectType());
        OrDescr rightOr = (OrDescr)rootAnd.getDescrs().get(1);
        Assert.assertEquals((long)2L, (long)rightOr.getDescrs().size());
        PatternDescr shoes = (PatternDescr)rightOr.getDescrs().get(0);
        Assert.assertEquals((Object)"Shoes", (Object)shoes.getObjectType());
        PatternDescr butt = (PatternDescr)rightOr.getDescrs().get(1);
        Assert.assertEquals((Object)"Butt", (Object)butt.getObjectType());
    }

    @Test
    public void testEvalMultiple() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eval_multiple.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)4L, (long)rule.getLhs().getDescrs().size());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(0);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\") + 5", (String)eval.getContent());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"Foo", (Object)pattern.getObjectType());
    }

    @Test
    public void testWithEval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_eval.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)3L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Foo", (Object)pattern.getObjectType());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"Bar", (Object)pattern.getObjectType());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(2);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\")", (String)eval.getContent());
        this.assertEqualsIgnoreWhitespace("Kapow", (String)rule.getConsequence());
    }

    @Test
    public void testWithRetval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_retval.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)col.getConstraint().getDescrs().size());
        Assert.assertEquals((Object)"Foo", (Object)col.getObjectType());
        ExprConstraintDescr fld = (ExprConstraintDescr)col.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"name== (a + b)", (Object)fld.getExpression());
    }

    @Test
    public void testWithPredicate() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_predicate.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr and = (AndDescr)col.getConstraint();
        Assert.assertEquals((long)2L, (long)and.getDescrs().size());
        ExprConstraintDescr field = (ExprConstraintDescr)col.getDescrs().get(0);
        ExprConstraintDescr pred = (ExprConstraintDescr)and.getDescrs().get(1);
        Assert.assertEquals((Object)"$age2:age", (Object)field.getExpression());
        this.assertEqualsIgnoreWhitespace("$age2 == $age1+2", pred.getExpression());
    }

    @Test
    public void testNotWithConstraint() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "not_with_constraint.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        ExprConstraintDescr fieldBinding = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"$likes:like", (Object)fieldBinding.getExpression());
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        pattern = (PatternDescr)not.getDescrs().get(0);
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"type == $likes", (Object)fld.getExpression());
    }

    @Test
    public void testFunctions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "functions.drl");
        Assert.assertEquals((long)2L, (long)pkg.getRules().size());
        List functions = pkg.getFunctions();
        Assert.assertEquals((long)2L, (long)functions.size());
        FunctionDescr func = (FunctionDescr)functions.get(0);
        Assert.assertEquals((Object)"functionA", (Object)func.getName());
        Assert.assertEquals((Object)"String", (Object)func.getReturnType());
        Assert.assertEquals((long)2L, (long)func.getParameterNames().size());
        Assert.assertEquals((long)2L, (long)func.getParameterTypes().size());
        Assert.assertEquals((long)19L, (long)func.getLine());
        Assert.assertEquals((long)0L, (long)func.getColumn());
        Assert.assertEquals((Object)"String", func.getParameterTypes().get(0));
        Assert.assertEquals((Object)"s", func.getParameterNames().get(0));
        Assert.assertEquals((Object)"Integer", func.getParameterTypes().get(1));
        Assert.assertEquals((Object)"i", func.getParameterNames().get(1));
        this.assertEqualsIgnoreWhitespace("foo();", func.getBody());
        func = (FunctionDescr)functions.get(1);
        Assert.assertEquals((Object)"functionB", (Object)func.getName());
        this.assertEqualsIgnoreWhitespace("bar();", func.getText());
    }

    @Test
    public void testComment() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "comment.drl");
        Assertions.assertThat((Object)pkg).isNotNull();
        Assert.assertEquals((Object)"foo.bar", (Object)pkg.getName());
    }

    @Test
    public void testAttributes() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_attributes.drl");
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assert.assertEquals((long)6L, (long)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        Assert.assertEquals((Object)"salience", (Object)at.getName());
        Assert.assertEquals((Object)"42", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("agenda-group");
        Assert.assertEquals((Object)"agenda-group", (Object)at.getName());
        Assert.assertEquals((Object)"my_group", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("no-loop");
        Assert.assertEquals((Object)"no-loop", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("duration");
        Assert.assertEquals((Object)"duration", (Object)at.getName());
        Assert.assertEquals((Object)"42", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("activation-group");
        Assert.assertEquals((Object)"activation-group", (Object)at.getName());
        Assert.assertEquals((Object)"my_activation_group", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assert.assertEquals((Object)"lock-on-active", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
    }

    @Test
    public void testAttributes2() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "rule_attributes2.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        List rules = pkg.getRules();
        Assert.assertEquals((long)3L, (long)rules.size());
        RuleDescr rule = (RuleDescr)rules.get(0);
        Assert.assertEquals((Object)"rule1", (Object)rule.getName());
        Map attrs = rule.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        Assert.assertEquals((Object)"salience", (Object)at.getName());
        Assert.assertEquals((Object)"(42)", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("agenda-group");
        Assert.assertEquals((Object)"agenda-group", (Object)at.getName());
        Assert.assertEquals((Object)"my_group", (Object)at.getValue());
        rule = (RuleDescr)rules.get(1);
        Assert.assertEquals((Object)"rule2", (Object)rule.getName());
        attrs = rule.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.size());
        at = (AttributeDescr)attrs.get("salience");
        Assert.assertEquals((Object)"salience", (Object)at.getName());
        Assert.assertEquals((Object)"(Integer.MIN_VALUE)", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("no-loop");
        Assert.assertEquals((Object)"no-loop", (Object)at.getName());
        rule = (RuleDescr)rules.get(2);
        Assert.assertEquals((Object)"rule3", (Object)rule.getName());
        attrs = rule.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.size());
        at = (AttributeDescr)attrs.get("enabled");
        Assert.assertEquals((Object)"enabled", (Object)at.getName());
        Assert.assertEquals((Object)"(Boolean.TRUE)", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("activation-group");
        Assert.assertEquals((Object)"activation-group", (Object)at.getName());
        Assert.assertEquals((Object)"my_activation_group", (Object)at.getValue());
    }

    @Test
    public void testAttributeRefract() throws Exception {
        String source = "rule Test refract when Person() then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule Test refract when Person() then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"Test", (Object)rule.getName());
        Map attributes = rule.getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
        AttributeDescr refract = (AttributeDescr)attributes.get("refract");
        Assertions.assertThat((Object)refract).isNotNull();
        Assert.assertEquals((Object)"true", (Object)refract.getValue());
    }

    @Test
    public void testEnabledExpression() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_enabled_expression.drl");
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assert.assertEquals((long)3L, (long)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("enabled");
        Assert.assertEquals((Object)"enabled", (Object)at.getName());
        Assert.assertEquals((Object)"( 1 + 1 == 2 )", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("salience");
        Assert.assertEquals((Object)"salience", (Object)at.getName());
        Assert.assertEquals((Object)"( 1+2 )", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assert.assertEquals((Object)"lock-on-active", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
    }

    @Test
    public void testDurationExpression() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_duration_expression.drl");
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("duration");
        Assert.assertEquals((Object)"duration", (Object)at.getName());
        Assert.assertEquals((Object)"1h30m", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assert.assertEquals((Object)"lock-on-active", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
    }

    @Test
    public void testCalendars() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_calendars_attribute.drl");
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("calendars");
        Assert.assertEquals((Object)"calendars", (Object)at.getName());
        Assert.assertEquals((Object)"[ \"cal1\" ]", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assert.assertEquals((Object)"lock-on-active", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
    }

    @Test
    public void testCalendars2() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_calendars_attribute2.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("calendars");
        Assert.assertEquals((Object)"calendars", (Object)at.getName());
        Assert.assertEquals((Object)"[ \"cal 1\", \"cal 2\", \"cal 3\" ]", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assert.assertEquals((Object)"lock-on-active", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
    }

    @Test
    public void testAttributes_alternateSyntax() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_attributes_alt.drl");
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assert.assertEquals((long)6L, (long)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        Assert.assertEquals((Object)"salience", (Object)at.getName());
        Assert.assertEquals((Object)"42", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("agenda-group");
        Assert.assertEquals((Object)"agenda-group", (Object)at.getName());
        Assert.assertEquals((Object)"my_group", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("no-loop");
        Assert.assertEquals((Object)"no-loop", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assert.assertEquals((Object)"lock-on-active", (Object)at.getName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("duration");
        Assert.assertEquals((Object)"duration", (Object)at.getName());
        Assert.assertEquals((Object)"42", (Object)at.getValue());
        at = (AttributeDescr)attrs.get("activation-group");
        Assert.assertEquals((Object)"activation-group", (Object)at.getName());
        Assert.assertEquals((Object)"my_activation_group", (Object)at.getValue());
    }

    @Test
    public void testEnumeration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "enumeration.drl");
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Foo", (Object)col.getObjectType());
        Assert.assertEquals((long)1L, (long)col.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)col.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"bar == Foo.BAR", (Object)fld.getExpression());
    }

    @Test
    public void testExtraLhsNewline() throws Exception {
        this.parseResource("compilationUnit", "extra_lhs_newline.drl");
    }

    @Test
    public void testSoundsLike() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "soundslike_operator.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pat = (PatternDescr)rule.getLhs().getDescrs().get(0);
        pat.getConstraint();
    }

    @Test
    public void testPackageAttributes() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "package_attributes.drl");
        AttributeDescr at = (AttributeDescr)pkg.getAttributes().get(0);
        Assert.assertEquals((Object)"agenda-group", (Object)at.getName());
        Assert.assertEquals((Object)"x", (Object)at.getValue());
        at = (AttributeDescr)pkg.getAttributes().get(1);
        Assert.assertEquals((Object)"dialect", (Object)at.getName());
        Assert.assertEquals((Object)"java", (Object)at.getValue());
        Assert.assertEquals((long)2L, (long)pkg.getRules().size());
        Assert.assertEquals((long)2L, (long)pkg.getImports().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"bar", (Object)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get("agenda-group");
        Assert.assertEquals((Object)"agenda-group", (Object)at.getName());
        Assert.assertEquals((Object)"x", (Object)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get("dialect");
        Assert.assertEquals((Object)"dialect", (Object)at.getName());
        Assert.assertEquals((Object)"java", (Object)at.getValue());
        rule = (RuleDescr)pkg.getRules().get(1);
        Assert.assertEquals((Object)"baz", (Object)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get("dialect");
        Assert.assertEquals((Object)"dialect", (Object)at.getName());
        Assert.assertEquals((Object)"mvel", (Object)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get("agenda-group");
        Assert.assertEquals((Object)"agenda-group", (Object)at.getName());
        Assert.assertEquals((Object)"x", (Object)at.getValue());
    }

    @Test
    public void testStatementOrdering1() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "statement_ordering_1.drl");
        Assert.assertEquals((long)2L, (long)pkg.getRules().size());
        Assert.assertEquals((Object)"foo", (Object)((RuleDescr)pkg.getRules().get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((RuleDescr)pkg.getRules().get(1)).getName());
        Assert.assertEquals((long)2L, (long)pkg.getFunctions().size());
        Assert.assertEquals((Object)"cheeseIt", (Object)((FunctionDescr)pkg.getFunctions().get(0)).getName());
        Assert.assertEquals((Object)"uncheeseIt", (Object)((FunctionDescr)pkg.getFunctions().get(1)).getName());
        Assert.assertEquals((long)4L, (long)pkg.getImports().size());
        Assert.assertEquals((Object)"im.one", (Object)((ImportDescr)pkg.getImports().get(0)).getTarget());
        Assert.assertEquals((Object)"im.two", (Object)((ImportDescr)pkg.getImports().get(1)).getTarget());
        Assert.assertEquals((Object)"im.three", (Object)((ImportDescr)pkg.getImports().get(2)).getTarget());
        Assert.assertEquals((Object)"im.four", (Object)((ImportDescr)pkg.getImports().get(3)).getTarget());
    }

    @Test
    public void testRuleNamesStartingWithNumbers() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "rule_names_number_prefix.drl");
        Assert.assertEquals((long)2L, (long)pkg.getRules().size());
        Assert.assertEquals((Object)"1. Do Stuff!", (Object)((RuleDescr)pkg.getRules().get(0)).getName());
        Assert.assertEquals((Object)"2. Do More Stuff!", (Object)((RuleDescr)pkg.getRules().get(1)).getName());
    }

    @Test
    public void testEvalWithNewline() throws Exception {
        this.parseResource("compilationUnit", "eval_with_newline.drl");
    }

    @Test
    public void testEndPosition() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_EndPosition.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)21L, (long)col.getLine());
        Assert.assertEquals((long)23L, (long)col.getEndLine());
    }

    @Test
    public void testQualifiedClassname() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "qualified_classname.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr p = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"com.cheeseco.Cheese", (Object)p.getObjectType());
    }

    @Test
    public void testAccumulate() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        Assert.assertNull((Object)accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        Assert.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
    }

    @Test
    public void testAccumulateWithBindings() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_with_bindings.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
    }

    @Test
    public void testCollect() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "collect.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)outPattern.getSource();
        PatternDescr pattern = collect.getInputPattern();
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
    }

    @Test
    public void testPredicate2() throws Exception {
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Foo(eval( $var.equals(\"xyz\") )) then end");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        List constraints = pattern.getConstraint().getDescrs();
        Assert.assertEquals((long)1L, (long)constraints.size());
        ExprConstraintDescr predicate = (ExprConstraintDescr)constraints.get(0);
        Assert.assertEquals((Object)"eval( $var.equals(\"xyz\") )", (Object)predicate.getExpression());
    }

    @Test
    public void testEscapedStrings() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "escaped-string.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        Assert.assertEquals((Object)"test_Quotes", (Object)rule.getName());
        String expected = "String s = \"\\\"\\n\\t\\\\\";";
        this.assertEqualsIgnoreWhitespace("String s = \"\\\"\\n\\t\\\\\";", (String)rule.getConsequence());
    }

    @Test
    public void testNestedCEs() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "nested_conditional_elements.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr root = rule.getLhs();
        NotDescr not1 = (NotDescr)root.getDescrs().get(0);
        AndDescr and1 = (AndDescr)not1.getDescrs().get(0);
        PatternDescr state = (PatternDescr)and1.getDescrs().get(0);
        NotDescr not2 = (NotDescr)and1.getDescrs().get(1);
        AndDescr and2 = (AndDescr)not2.getDescrs().get(0);
        PatternDescr person = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and2.getDescrs().get(1);
        PatternDescr person2 = (PatternDescr)root.getDescrs().get(1);
        OrDescr or = (OrDescr)root.getDescrs().get(2);
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(0);
        PatternDescr cheese3 = (PatternDescr)or.getDescrs().get(1);
        Assert.assertEquals((Object)state.getObjectType(), (Object)"State");
        Assert.assertEquals((Object)person.getObjectType(), (Object)"Person");
        Assert.assertEquals((Object)cheese.getObjectType(), (Object)"Cheese");
        Assert.assertEquals((Object)person2.getObjectType(), (Object)"Person");
        Assert.assertEquals((Object)cheese2.getObjectType(), (Object)"Cheese");
        Assert.assertEquals((Object)cheese3.getObjectType(), (Object)"Cheese");
    }

    @Test
    public void testForall() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "forall.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)forall.getDescrs().size());
        PatternDescr pattern = forall.getBasePattern();
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        List remaining = forall.getRemainingPatterns();
        Assert.assertEquals((long)1L, (long)remaining.size());
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        Assert.assertEquals((Object)"Cheese", (Object)cheese.getObjectType());
    }

    @Test
    public void testForallWithFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "forallwithfrom.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)forall.getDescrs().size());
        PatternDescr pattern = forall.getBasePattern();
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertEquals((Object)"$village", (Object)((FromDescr)pattern.getSource()).getDataSource().toString());
        List remaining = forall.getRemainingPatterns();
        Assert.assertEquals((long)1L, (long)remaining.size());
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        Assert.assertEquals((Object)"Cheese", (Object)cheese.getObjectType());
        Assert.assertEquals((Object)"$cheesery", (Object)((FromDescr)cheese.getSource()).getDataSource().toString());
    }

    @Test
    public void testMemberof() throws Exception {
        String text = "rule X when Country( $cities : city )\nPerson( city memberOf $cities )\n then end";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Country( $cities : city )\nPerson( city memberOf $cities )\n then end")).getLhs();
        Assert.assertEquals((long)2L, (long)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"city memberOf $cities", (Object)fieldConstr.getExpression());
    }

    @Test
    public void testNotMemberof() throws Exception {
        String text = "rule X when Country( $cities : city )\nPerson( city not memberOf $cities ) then end\n";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Country( $cities : city )\nPerson( city not memberOf $cities ) then end\n")).getLhs();
        Assert.assertEquals((long)2L, (long)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"city not memberOf $cities", (Object)fieldConstr.getExpression());
    }

    @Test
    public void testInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "in_operator_test.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertEquals((long)1L, (long)pattern.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"age > 30 && < 40", (Object)fld.getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"Vehicle", (Object)pattern.getObjectType());
        Assert.assertEquals((long)2L, (long)pattern.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"type in ( \"sedan\", \"wagon\" )", (Object)fld.getExpression());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        Assert.assertEquals((Object)"age < 3", (Object)fld.getExpression());
    }

    @Test
    public void testNotInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "notin_operator_test.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        Assert.assertEquals((Object)"simple_rule", (Object)rule.getName());
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertEquals((long)1L, (long)pattern.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"age > 30 && < 40", (Object)fld.getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"Vehicle", (Object)pattern.getObjectType());
        Assert.assertEquals((long)2L, (long)pattern.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"type not in ( \"sedan\", \"wagon\" )", (Object)fld.getExpression());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        Assert.assertEquals((Object)"age < 3", (Object)fld.getExpression());
    }

    @Test
    public void testCheckOrDescr() throws Exception {
        String text = "rule X when Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        Assert.assertEquals(pattern.getConstraint().getClass(), AndDescr.class);
        Assert.assertEquals(ExprConstraintDescr.class, ((BaseDescr)pattern.getConstraint().getDescrs().get(0)).getClass());
    }

    @Test
    public void testConstraintAndConnective() throws Exception {
        String text = "rule X when Person( age < 42 && location==\"atlanta\") then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( age < 42 && location==\"atlanta\") then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"age < 42 && location==\"atlanta\"", (Object)fcd.getExpression());
    }

    @Test
    public void testConstraintOrConnective() throws Exception {
        String text = "rule X when Person( age < 42 || location==\"atlanta\") then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( age < 42 || location==\"atlanta\") then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"age < 42 || location==\"atlanta\"", (Object)fcd.getExpression());
    }

    @Test
    public void testRestrictions() throws Exception {
        String text = "rule X when Foo( bar > 1 || == 1 ) then end\n";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Foo( bar > 1 || == 1 ) then end\n")).getLhs();
        Assert.assertEquals((long)1L, (long)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(0);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"bar > 1 || == 1", (Object)fieldConstr.getExpression());
    }

    @Test
    public void testSemicolon() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "semicolon.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((Object)"org.drools.mvel.compiler", (Object)pkg.getName());
        Assert.assertEquals((long)1L, (long)pkg.getGlobals().size());
        Assert.assertEquals((long)3L, (long)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)2L, (long)rule1.getLhs().getDescrs().size());
        RuleDescr query1 = (RuleDescr)pkg.getRules().get(1);
        Assert.assertEquals((long)3L, (long)query1.getLhs().getDescrs().size());
        RuleDescr rule2 = (RuleDescr)pkg.getRules().get(2);
        Assert.assertEquals((long)2L, (long)rule2.getLhs().getDescrs().size());
    }

    @Test
    public void testEval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eval_parsing.drl");
        Assert.assertEquals((Object)"org.drools.mvel.compiler", (Object)pkg.getName());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule1.getLhs().getDescrs().size());
    }

    @Test
    public void testAccumulateReverse() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateReverse.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("x--;", accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        Assert.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
    }

    @Test
    public void testAccumulateExternalFunction() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateExternalFunction.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("$age", ((AccumulateDescr.AccumulateFunctionCallDescr)accum.getFunctions().get(0)).getParams()[0]);
        this.assertEqualsIgnoreWhitespace("average", ((AccumulateDescr.AccumulateFunctionCallDescr)accum.getFunctions().get(0)).getFunction());
        Assert.assertTrue((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
    }

    @Test
    public void testCollectWithNestedFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "collect_with_nested_from.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)out.getSource();
        PatternDescr person = collect.getInputPattern();
        Assert.assertEquals((Object)"Person", (Object)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        Assert.assertEquals((Object)"People", (Object)people.getObjectType());
    }

    @Test
    public void testAccumulateWithNestedFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_with_nested_from.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accumulate = (AccumulateDescr)out.getSource();
        PatternDescr person = accumulate.getInputPattern();
        Assert.assertEquals((Object)"Person", (Object)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        Assert.assertEquals((Object)"People", (Object)people.getObjectType());
    }

    @Test
    public void testAccumulateMultipleFunctions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateMultipleFunctions.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Object", (Object)out.getObjectType());
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assert.assertTrue((boolean)accum.isExternalFunction());
        List functions = accum.getFunctions();
        Assert.assertEquals((long)3L, (long)functions.size());
        Assert.assertEquals((Object)"average", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction());
        Assert.assertEquals((Object)"$a1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]);
        Assert.assertEquals((Object)"min", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getFunction());
        Assert.assertEquals((Object)"$m1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getParams()[0]);
        Assert.assertEquals((Object)"max", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getFunction());
        Assert.assertEquals((Object)"$M1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getParams()[0]);
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
    }

    @Test
    public void testAccumulateMnemonic() throws Exception {
        String drl = "package org.drools.mvel.compiler\nrule \"Accumulate 1\"\nwhen\n     acc( Cheese( $price : price ),\n          $a1 : average( $price ) )\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", drl);
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Object", (Object)out.getObjectType());
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assert.assertTrue((boolean)accum.isExternalFunction());
        List functions = accum.getFunctions();
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertEquals((Object)"average", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction());
        Assert.assertEquals((Object)"$a1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]);
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
    }

    @Test
    public void testAccumulateMnemonic2() throws Exception {
        String drl = "package org.drools.mvel.compiler\nrule \"Accumulate 1\"\nwhen\n     Number() from acc( Cheese( $price : price ),\n                        average( $price ) )\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", drl);
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Number", (Object)out.getObjectType());
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assert.assertTrue((boolean)accum.isExternalFunction());
        List functions = accum.getFunctions();
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertEquals((Object)"average", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]);
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
    }

    @Test
    public void testImportAccumulate() throws Exception {
        String drl = "package org.drools.mvel.compiler\nimport acc foo.Bar baz\nimport accumulate foo.Bar2 baz2\nrule \"Accumulate 1\"\nwhen\n     acc( Cheese( $price : price ),\n          $v1 : baz( $price ), \n          $v2 : baz2( $price ) )\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", drl);
        Assert.assertEquals((long)2L, (long)pkg.getAccumulateImports().size());
        AccumulateImportDescr imp = (AccumulateImportDescr)pkg.getAccumulateImports().get(0);
        Assert.assertEquals((Object)"foo.Bar", (Object)imp.getTarget());
        Assert.assertEquals((Object)"baz", (Object)imp.getFunctionName());
        imp = (AccumulateImportDescr)pkg.getAccumulateImports().get(1);
        Assert.assertEquals((Object)"foo.Bar2", (Object)imp.getTarget());
        Assert.assertEquals((Object)"baz2", (Object)imp.getFunctionName());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Object", (Object)out.getObjectType());
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assert.assertTrue((boolean)accum.isExternalFunction());
        List functions = accum.getFunctions();
        Assert.assertEquals((long)2L, (long)functions.size());
        Assert.assertEquals((Object)"baz", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction());
        Assert.assertEquals((Object)"$v1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]);
        Assert.assertEquals((Object)"baz2", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getFunction());
        Assert.assertEquals((Object)"$v2", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getParams()[0]);
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
    }

    @Test
    public void testAccumulateMultipleFunctionsConstraint() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateMultipleFunctionsConstraint.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Object", (Object)out.getObjectType());
        Assert.assertEquals((long)2L, (long)out.getConstraint().getDescrs().size());
        Assert.assertEquals((Object)"$a1 > 10 && $M1 <= 100", (Object)((BaseDescr)out.getConstraint().getDescrs().get(0)).toString());
        Assert.assertEquals((Object)"$m1 == 5", (Object)((BaseDescr)out.getConstraint().getDescrs().get(1)).toString());
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assert.assertTrue((boolean)accum.isExternalFunction());
        List functions = accum.getFunctions();
        Assert.assertEquals((long)3L, (long)functions.size());
        Assert.assertEquals((Object)"average", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction());
        Assert.assertEquals((Object)"$a1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]);
        Assert.assertEquals((Object)"min", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getFunction());
        Assert.assertEquals((Object)"$m1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getParams()[0]);
        Assert.assertEquals((Object)"max", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getFunction());
        Assert.assertEquals((Object)"$M1", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getBind());
        Assert.assertEquals((Object)"$price", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getParams()[0]);
        PatternDescr pattern = accum.getInputPattern();
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
    }

    @Test
    public void testOrCE() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_ce.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)2L, (long)rule.getLhs().getDescrs().size());
        PatternDescr person = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)person.getObjectType());
        Assert.assertEquals((Object)"$p", (Object)person.getIdentifier());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        PatternDescr cheese1 = (PatternDescr)or.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)cheese1.getObjectType());
        Assert.assertEquals((Object)"$c", (Object)cheese1.getIdentifier());
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(1);
        Assert.assertEquals((Object)"Cheese", (Object)cheese2.getObjectType());
        Assert.assertNull((Object)cheese2.getIdentifier());
    }

    @Test
    public void testRuleSingleLine() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end");
        Assert.assertEquals((Object)"another test", (Object)rule.getName());
        Assert.assertEquals((Object)"System.out.println(1); ", (Object)rule.getConsequence());
    }

    @Test
    public void testRuleTwoLines() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end");
        Assert.assertEquals((Object)"another test", (Object)rule.getName());
        Assert.assertEquals((Object)"System.out.println(1);\n ", (Object)rule.getConsequence());
    }

    @Test
    public void testRuleParseLhs3() throws Exception {
        String text = "rule X when (or\nnot Person()\n(and Cheese()\nMeat()\nWine())) then end";
        AndDescr pattern = ((RuleDescr)this.parse("rule", "rule X when (or\nnot Person()\n(and Cheese()\nMeat()\nWine())) then end")).getLhs();
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)or.getDescrs().size());
        NotDescr not = (NotDescr)or.getDescrs().get(0);
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        Assert.assertEquals((long)1L, (long)not.getDescrs().size());
        PatternDescr person = (PatternDescr)not.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)person.getObjectType());
        Assert.assertEquals((long)3L, (long)and.getDescrs().size());
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)cheese.getObjectType());
        PatternDescr meat = (PatternDescr)and.getDescrs().get(1);
        Assert.assertEquals((Object)"Meat", (Object)meat.getObjectType());
        PatternDescr wine = (PatternDescr)and.getDescrs().get(2);
        Assert.assertEquals((Object)"Wine", (Object)wine.getObjectType());
    }

    @Test
    public void testAccumulateMultiPattern() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_multi_pattern.drl");
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        AndDescr and = (AndDescr)accum.getInput();
        Assert.assertEquals((long)2L, (long)and.getDescrs().size());
        PatternDescr person = (PatternDescr)and.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)person.getObjectType());
        Assert.assertEquals((Object)"Cheese", (Object)cheese.getObjectType());
    }

    @Test
    public void testPluggableOperators() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "pluggable_operators.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((long)5L, (long)rule.getLhs().getDescrs().size());
        PatternDescr eventA = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"$a", (Object)eventA.getIdentifier());
        Assert.assertEquals((Object)"EventA", (Object)eventA.getObjectType());
        PatternDescr eventB = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"$b", (Object)eventB.getIdentifier());
        Assert.assertEquals((Object)"EventB", (Object)eventB.getObjectType());
        Assert.assertEquals((long)1L, (long)eventB.getConstraint().getDescrs().size());
        Assert.assertEquals((long)1L, (long)eventB.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdB = (ExprConstraintDescr)eventB.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"this after[1,10] $a || this not after[15,20] $a", (Object)fcdB.getExpression());
        PatternDescr eventC = (PatternDescr)rule.getLhs().getDescrs().get(2);
        Assert.assertEquals((Object)"$c", (Object)eventC.getIdentifier());
        Assert.assertEquals((Object)"EventC", (Object)eventC.getObjectType());
        Assert.assertEquals((long)1L, (long)eventC.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdC = (ExprConstraintDescr)eventC.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"this finishes $b", (Object)fcdC.getExpression());
        PatternDescr eventD = (PatternDescr)rule.getLhs().getDescrs().get(3);
        Assert.assertEquals((Object)"$d", (Object)eventD.getIdentifier());
        Assert.assertEquals((Object)"EventD", (Object)eventD.getObjectType());
        Assert.assertEquals((long)1L, (long)eventD.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdD = (ExprConstraintDescr)eventD.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"this not starts $a", (Object)fcdD.getExpression());
        PatternDescr eventE = (PatternDescr)rule.getLhs().getDescrs().get(4);
        Assert.assertEquals((Object)"$e", (Object)eventE.getIdentifier());
        Assert.assertEquals((Object)"EventE", (Object)eventE.getObjectType());
        Assert.assertEquals((long)1L, (long)eventE.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdE = (ExprConstraintDescr)eventE.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"this not before[1, 10] $b || after[1, 10] $c && this after[1, 5] $d", (Object)fcdE.getExpression());
    }

    @Test
    public void testRuleMetadata() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_Metadata.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertTrue((boolean)rule.getAnnotationNames().contains("fooMeta1"));
        Assert.assertEquals((Object)"barVal1", (Object)rule.getAnnotation("fooMeta1").getValue());
        Assert.assertTrue((boolean)rule.getAnnotationNames().contains("fooMeta2"));
        Assert.assertEquals((Object)"barVal2", (Object)rule.getAnnotation("fooMeta2").getValue());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"Consequence\");", (String)rule.getConsequence());
    }

    @Test
    public void testRuleExtends() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_Extends.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertTrue((rule.getParentName() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"rule1", (Object)rule.getParentName());
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)1L, (long)lhs.getDescrs().size());
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"foo", (Object)pattern.getObjectType());
        Assert.assertEquals((Object)"$foo", (Object)pattern.getIdentifier());
    }

    @Test
    public void testTypeDeclarationWithFields() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "declare_type_with_fields.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        List td = pkg.getTypeDeclarations();
        Assert.assertEquals((long)3L, (long)td.size());
        TypeDeclarationDescr d = (TypeDeclarationDescr)td.get(0);
        Assert.assertEquals((Object)"SomeFact", (Object)d.getTypeName());
        Assert.assertEquals((long)2L, (long)d.getFields().size());
        Assert.assertTrue((boolean)d.getFields().containsKey("name"));
        Assert.assertTrue((boolean)d.getFields().containsKey("age"));
        TypeFieldDescr f = (TypeFieldDescr)d.getFields().get("name");
        Assert.assertEquals((Object)"String", (Object)f.getPattern().getObjectType());
        f = (TypeFieldDescr)d.getFields().get("age");
        Assert.assertEquals((Object)"Integer", (Object)f.getPattern().getObjectType());
        d = (TypeDeclarationDescr)td.get(1);
        Assert.assertEquals((Object)"AnotherFact", (Object)d.getTypeName());
        TypeDeclarationDescr type = (TypeDeclarationDescr)td.get(2);
        Assert.assertEquals((Object)"Person", (Object)type.getTypeName());
        Assert.assertEquals((Object)"fact", (Object)type.getAnnotation("role").getValue());
        Assert.assertEquals((Object)"\"Models a person\"", (Object)type.getAnnotation("doc").getValue("descr"));
        Assert.assertEquals((Object)"\"Bob\"", (Object)type.getAnnotation("doc").getValue("author"));
        Assert.assertEquals((Object)"Calendar.getInstance().getDate()", (Object)type.getAnnotation("doc").getValue("date"));
        Assert.assertEquals((long)2L, (long)type.getFields().size());
        TypeFieldDescr field = (TypeFieldDescr)type.getFields().get("name");
        Assert.assertEquals((Object)"name", (Object)field.getFieldName());
        Assert.assertEquals((Object)"String", (Object)field.getPattern().getObjectType());
        Assert.assertEquals((Object)"\"John Doe\"", (Object)field.getInitExpr());
        Assert.assertEquals((Object)"50", (Object)field.getAnnotation("length").getValue("max"));
        Assertions.assertThat((Object)field.getAnnotation("key")).isNotNull();
        field = (TypeFieldDescr)type.getFields().get("age");
        Assert.assertEquals((Object)"age", (Object)field.getFieldName());
        Assert.assertEquals((Object)"int", (Object)field.getPattern().getObjectType());
        Assert.assertEquals((Object)"-1", (Object)field.getInitExpr());
        Assert.assertEquals((Object)"0", (Object)field.getAnnotation("ranged").getValue("min"));
        Assert.assertEquals((Object)"150", (Object)field.getAnnotation("ranged").getValue("max"));
        Assert.assertEquals((Object)"-1", (Object)field.getAnnotation("ranged").getValue("unknown"));
    }

    @Test
    public void testRuleWithLHSNesting() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_nested_LHS.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"test", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assert.assertEquals((long)2L, (long)lhs.getDescrs().size());
        PatternDescr a = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"A", (Object)a.getObjectType());
        OrDescr or = (OrDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((long)3L, (long)or.getDescrs().size());
        AndDescr and1 = (AndDescr)or.getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)and1.getDescrs().size());
        PatternDescr b = (PatternDescr)and1.getDescrs().get(0);
        PatternDescr c = (PatternDescr)and1.getDescrs().get(1);
        Assert.assertEquals((Object)"B", (Object)b.getObjectType());
        Assert.assertEquals((Object)"C", (Object)c.getObjectType());
        AndDescr and2 = (AndDescr)or.getDescrs().get(1);
        Assert.assertEquals((long)2L, (long)and2.getDescrs().size());
        PatternDescr d = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr e = (PatternDescr)and2.getDescrs().get(1);
        Assert.assertEquals((Object)"D", (Object)d.getObjectType());
        Assert.assertEquals((Object)"E", (Object)e.getObjectType());
        AndDescr and3 = (AndDescr)or.getDescrs().get(2);
        Assert.assertEquals((long)2L, (long)and3.getDescrs().size());
        PatternDescr f = (PatternDescr)and3.getDescrs().get(0);
        PatternDescr g = (PatternDescr)and3.getDescrs().get(1);
        Assert.assertEquals((Object)"F", (Object)f.getObjectType());
        Assert.assertEquals((Object)"G", (Object)g.getObjectType());
    }

    @Test
    public void testEntryPoint() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") from entry-point StreamA then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") from entry-point StreamA then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"symbol==\"ACME\"", (Object)fcd.getExpression());
        Assertions.assertThat((Object)pattern.getSource()).isNotNull();
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        Assert.assertEquals((Object)"StreamA", (Object)entry.getEntryId());
    }

    @Test
    public void testEntryPoint2() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") from entry-point \"StreamA\" then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") from entry-point \"StreamA\" then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"symbol==\"ACME\"", (Object)fcd.getExpression());
        Assertions.assertThat((Object)pattern.getSource()).isNotNull();
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        Assert.assertEquals((Object)"StreamA", (Object)entry.getEntryId());
    }

    @Test
    public void testSlidingWindow() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") over window:length(10) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") over window:length(10) then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"symbol==\"ACME\"", (Object)fcd.getExpression());
        List behaviors = pattern.getBehaviors();
        Assertions.assertThat((List)behaviors).isNotNull();
        Assert.assertEquals((long)1L, (long)behaviors.size());
        BehaviorDescr descr = (BehaviorDescr)behaviors.get(0);
        Assert.assertEquals((Object)"window", (Object)descr.getType());
        Assert.assertEquals((Object)"length", (Object)descr.getSubType());
        Assert.assertEquals((Object)"10", descr.getParameters().get(0));
    }

    @Test
    public void testRuleOldSyntax1() throws Exception {
        String source = "rule \"Test\" when ( not $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule \"Test\" when ( not $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"Test", (Object)rule.getName());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        Assert.assertEquals((long)1L, (long)((NotDescr)rule.getLhs().getDescrs().get(0)).getDescrs().size());
        NotDescr notDescr = (NotDescr)rule.getLhs().getDescrs().get(0);
        PatternDescr patternDescr = (PatternDescr)notDescr.getDescrs().get(0);
        Assert.assertEquals((Object)"$r", (Object)patternDescr.getIdentifier());
        Assert.assertEquals((long)1L, (long)patternDescr.getDescrs().size());
        ExprConstraintDescr fieldConstraintDescr = (ExprConstraintDescr)patternDescr.getDescrs().get(0);
        Assert.assertEquals((Object)"operator == Operator.EQUAL", (Object)fieldConstraintDescr.getExpression());
    }

    @Test
    public void testRuleOldSyntax2() throws Exception {
        String source = "rule \"Test\" when ( $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule \"Test\" when ( $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"Test", (Object)rule.getName());
        Assert.assertEquals((long)1L, (long)rule.getLhs().getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"$r", (Object)patternDescr.getIdentifier());
        Assert.assertEquals((long)1L, (long)patternDescr.getDescrs().size());
        ExprConstraintDescr fieldConstraintDescr = (ExprConstraintDescr)patternDescr.getDescrs().get(0);
        Assert.assertEquals((Object)"operator == Operator.EQUAL", (Object)fieldConstraintDescr.getExpression());
    }

    @Test
    public void testTypeWithMetaData() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "type_with_meta.drl");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        List declarations = pkg.getTypeDeclarations();
        Assert.assertEquals((long)3L, (long)declarations.size());
    }

    @Test
    public void testNullConstraints() throws Exception {
        String text = "rule X when Person( name == null ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( name == null ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"name == null", (Object)fcd.getExpression());
        Assert.assertEquals((long)0L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)fcd.getType());
    }

    @Test
    public void testPositionalConstraintsOnly() throws Exception {
        String text = "rule X when Person( \"Mark\", 42; ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( \"Mark\", 42; ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"\"Mark\"", (Object)fcd.getExpression());
        Assert.assertEquals((long)0L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assert.assertEquals((Object)"42", (Object)fcd.getExpression());
        Assert.assertEquals((long)1L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
    }

    @Test
    public void testIsQuery() throws Exception {
        String text = "rule X when ?person( \"Mark\", 42; ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when ?person( \"Mark\", 42; ) then end")).getLhs().getDescrs().get(0);
        Assert.assertTrue((boolean)pattern.isQuery());
        Assert.assertEquals((long)2L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"\"Mark\"", (Object)fcd.getExpression());
        Assert.assertEquals((long)0L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assert.assertEquals((Object)"42", (Object)fcd.getExpression());
        Assert.assertEquals((long)1L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
    }

    @Test
    public void testFromFollowedByQuery() throws Exception {
        String text = "rule X when Cheese() from $cheesery ?person( \"Mark\", 42; ) then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese() from $cheesery ?person( \"Mark\", 42; ) then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
        Assert.assertEquals((Object)"from $cheesery", (Object)pattern.getSource().getText());
        Assert.assertFalse((boolean)pattern.isQuery());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"person", (Object)pattern.getObjectType());
        Assert.assertTrue((boolean)pattern.isQuery());
    }

    @Test
    public void testFromWithTernaryFollowedByQuery() throws Exception {
        String text = "rule X when Cheese() from (isFull ? $cheesery : $market) ?person( \"Mark\", 42; ) then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese() from (isFull ? $cheesery : $market) ?person( \"Mark\", 42; ) then end");
        Assert.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Cheese", (Object)pattern.getObjectType());
        Assert.assertEquals((Object)"from (isFull ? $cheesery : $market)", (Object)pattern.getSource().getText());
        Assert.assertFalse((boolean)pattern.isQuery());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)"person", (Object)pattern.getObjectType());
        Assert.assertTrue((boolean)pattern.isQuery());
    }

    @Test
    public void testMultiValueAnnotationsBackwardCompatibility() throws Exception {
        String text = "rule X @ann1( val1, val2 ) @ann2( \"val1\", \"val2\" ) when then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X @ann1( val1, val2 ) @ann2( \"val1\", \"val2\" ) when then end");
        AnnotationDescr ann = rule.getAnnotation("ann1");
        Assertions.assertThat((Object)ann).isNotNull();
        Assert.assertEquals((Object)"val1, val2", (Object)ann.getValue());
        ann = rule.getAnnotation("ann2");
        Assertions.assertThat((Object)ann).isNotNull();
        Assert.assertEquals((Object)"\"val1\", \"val2\"", (Object)ann.getValue());
    }

    @Test
    public void testPositionalsAndNamedConstraints() throws Exception {
        String text = "rule X when Person( \"Mark\", 42; location == \"atlanta\" ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( \"Mark\", 42; location == \"atlanta\" ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((long)3L, (long)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"\"Mark\"", (Object)fcd.getExpression());
        Assert.assertEquals((long)0L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assert.assertEquals((Object)"42", (Object)fcd.getExpression());
        Assert.assertEquals((long)1L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(2);
        Assert.assertEquals((Object)"location == \"atlanta\"", (Object)fcd.getExpression());
        Assert.assertEquals((long)2L, (long)fcd.getPosition());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)fcd.getType());
    }

    @Test
    public void testUnificationBinding() throws Exception {
        String text = "rule X when $p := Person( $name := name, $loc : location ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when $p := Person( $name := name, $loc : location ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"$p", (Object)pattern.getIdentifier());
        Assert.assertTrue((boolean)pattern.isUnification());
        Assert.assertEquals((long)2L, (long)pattern.getDescrs().size());
        ExprConstraintDescr bindingDescr = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"$name := name", (Object)bindingDescr.getExpression());
        bindingDescr = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assert.assertEquals((Object)"$loc : location", (Object)bindingDescr.getExpression());
    }

    @Test
    public void testBigLiterals() throws Exception {
        String text = "rule X when Primitives( bigInteger == (10I),                         bigDecimal == (10B),                         bigInteger < 50I,                         bigDecimal < 50B ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Primitives( bigInteger == (10I),                         bigDecimal == (10B),                         bigInteger < 50I,                         bigDecimal < 50B ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((long)4L, (long)pattern.getDescrs().size());
        ExprConstraintDescr ecd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assert.assertEquals((Object)"bigInteger == (10I)", (Object)ecd.getExpression());
        ecd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assert.assertEquals((Object)"bigDecimal == (10B)", (Object)ecd.getExpression());
        ecd = (ExprConstraintDescr)pattern.getDescrs().get(2);
        Assert.assertEquals((Object)"bigInteger < 50I", (Object)ecd.getExpression());
        ecd = (ExprConstraintDescr)pattern.getDescrs().get(3);
        Assert.assertEquals((Object)"bigDecimal < 50B", (Object)ecd.getExpression());
    }

    @Test
    public void testBindingComposite() throws Exception {
        String text = "rule X when Person( $name : name == \"Bob\" || $loc : location == \"Montreal\" ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( $name : name == \"Bob\" || $loc : location == \"Montreal\" ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertFalse((boolean)pattern.isUnification());
        List constraints = pattern.getDescrs();
        Assert.assertEquals((long)1L, (long)constraints.size());
        Assert.assertEquals((Object)"$name : name == \"Bob\" || $loc : location == \"Montreal\"", (Object)((ExprConstraintDescr)constraints.get(0)).getExpression());
    }

    @Test
    public void testBindingCompositeWithMethods() throws Exception {
        String text = "rule X when Person( $name : name.toUpperCase() == \"Bob\" || $loc : location[0].city == \"Montreal\" ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( $name : name.toUpperCase() == \"Bob\" || $loc : location[0].city == \"Montreal\" ) then end")).getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        Assert.assertFalse((boolean)pattern.isUnification());
        List constraints = pattern.getDescrs();
        Assert.assertEquals((long)1L, (long)constraints.size());
        Assert.assertEquals((Object)"$name : name.toUpperCase() == \"Bob\" || $loc : location[0].city == \"Montreal\"", (Object)((ExprConstraintDescr)constraints.get(0)).getExpression());
    }

    @Test
    public void testPluggableOperators2() throws Exception {
        String text = "rule \"tt\"\n    dialect \"mvel\"\nwhen\n    exists (TelephoneCall( this finishes [1m] \"25-May-2011\" ))\nthen\nend";
        PatternDescr pattern = (PatternDescr)((ExistsDescr)((RuleDescr)this.parse("rule", "rule \"tt\"\n    dialect \"mvel\"\nwhen\n    exists (TelephoneCall( this finishes [1m] \"25-May-2011\" ))\nthen\nend")).getLhs().getDescrs().get(0)).getDescrs().get(0);
        Assert.assertEquals((Object)"TelephoneCall", (Object)pattern.getObjectType());
        ExprConstraintDescr constr = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"this finishes [1m] \"25-May-2011\"", (Object)constr.getText());
    }

    @Test
    public void testInlineEval() throws Exception {
        String text = "rule \"inline eval\"\nwhen\n    Person( eval( name.startsWith(\"b\") && name.finishesWith(\"b\")) )\nthen\nend";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule \"inline eval\"\nwhen\n    Person( eval( name.startsWith(\"b\") && name.finishesWith(\"b\")) )\nthen\nend")).getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)pattern.getObjectType());
        ExprConstraintDescr constr = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"eval( name.startsWith(\"b\") && name.finishesWith(\"b\"))", (Object)constr.getText());
    }

    @Test
    public void testInfinityLiteral() throws Exception {
        String text = "rule \"infinity\"\nwhen\n    StockTick( this after[-*,*] $another )\nthen\nend";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule \"infinity\"\nwhen\n    StockTick( this after[-*,*] $another )\nthen\nend")).getLhs().getDescrs().get(0);
        Assert.assertEquals((Object)"StockTick", (Object)pattern.getObjectType());
        ExprConstraintDescr constr = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assert.assertEquals((Object)"this after[-*,*] $another", (Object)constr.getText());
    }

    @Test
    public void testEntryPointDeclaration() throws Exception {
        String text = "package org.drools\ndeclare entry-point eventStream\n    @source(\"jndi://queues/events\")\n    @foo( true )\nend";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package org.drools\ndeclare entry-point eventStream\n    @source(\"jndi://queues/events\")\n    @foo( true )\nend");
        Assert.assertEquals((Object)"org.drools", (Object)pkg.getName());
        Assert.assertEquals((long)1L, (long)pkg.getEntryPointDeclarations().size());
        EntryPointDeclarationDescr epd = (EntryPointDeclarationDescr)pkg.getEntryPointDeclarations().iterator().next();
        Assert.assertEquals((Object)"eventStream", (Object)epd.getEntryPointId());
        Assert.assertEquals((long)2L, (long)epd.getAnnotations().size());
        Assert.assertEquals((Object)"\"jndi://queues/events\"", (Object)epd.getAnnotation("source").getValue());
        Assert.assertEquals((Object)"true", (Object)epd.getAnnotation("foo").getValue());
    }

    @Test
    public void testWindowDeclaration() throws Exception {
        String text = "package org.drools\ndeclare window Ticks\n    @doc(\"last 10 stock ticks\")\n    $s : StockTick( source == \"NYSE\" )\n        over window:length( 10, $s.symbol )\n        from entry-point stStream\nend";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package org.drools\ndeclare window Ticks\n    @doc(\"last 10 stock ticks\")\n    $s : StockTick( source == \"NYSE\" )\n        over window:length( 10, $s.symbol )\n        from entry-point stStream\nend");
        Assert.assertEquals((Object)"org.drools", (Object)pkg.getName());
        Assert.assertEquals((long)1L, (long)pkg.getWindowDeclarations().size());
        WindowDeclarationDescr wdd = (WindowDeclarationDescr)pkg.getWindowDeclarations().iterator().next();
        Assert.assertEquals((Object)"Ticks", (Object)wdd.getName());
        Assert.assertEquals((long)1L, (long)wdd.getAnnotations().size());
        Assert.assertEquals((Object)"\"last 10 stock ticks\"", (Object)wdd.getAnnotation("doc").getValue());
        PatternDescr pd = wdd.getPattern();
        Assertions.assertThat((Object)pd).isNotNull();
        Assert.assertEquals((Object)"$s", (Object)pd.getIdentifier());
        Assert.assertEquals((Object)"StockTick", (Object)pd.getObjectType());
        Assert.assertEquals((Object)"stStream", (Object)pd.getSource().getText());
        Assert.assertEquals((long)1L, (long)pd.getBehaviors().size());
        BehaviorDescr bd = (BehaviorDescr)pd.getBehaviors().get(0);
        Assert.assertEquals((Object)"window", (Object)bd.getType());
        Assert.assertEquals((Object)"length", (Object)bd.getSubType());
        Assert.assertEquals((long)2L, (long)bd.getParameters().size());
        Assert.assertEquals((Object)"10", bd.getParameters().get(0));
        Assert.assertEquals((Object)"$s.symbol", bd.getParameters().get(1));
    }

    @Test
    public void testWindowUsage() throws Exception {
        String text = "package org.drools\nrule X\nwhen\n    StockTick() from window Y\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package org.drools\nrule X\nwhen\n    StockTick() from window Y\nthen\nend\n");
        Assert.assertEquals((Object)"org.drools", (Object)pkg.getName());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        RuleDescr rd = (RuleDescr)pkg.getRules().get(0);
        Assert.assertEquals((Object)"X", (Object)rd.getName());
        Assert.assertEquals((long)1L, (long)rd.getLhs().getDescrs().size());
        PatternDescr pd = (PatternDescr)rd.getLhs().getDescrs().get(0);
        Assertions.assertThat((Object)pd).isNotNull();
        Assert.assertEquals((Object)"StockTick", (Object)pd.getObjectType());
        Assert.assertEquals((Object)"Y", (Object)pd.getSource().getText());
    }

    private Object parse(String parserRuleName, String text) throws Exception {
        return this.execParser(parserRuleName, (CharStream)new ANTLRStringStream(text));
    }

    private Object parseResource(String parserRuleName, String name) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(name));
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(parserRuleName, text.toString());
    }

    public Object execParser(String testRuleName, CharStream charStream) {
        try {
            this.createParser(charStream);
            Method ruleName = null;
            Object[] params = null;
            for (Method method : DRL6Parser.class.getMethods()) {
                if (!method.getName().equals(testRuleName)) continue;
                ruleName = method;
                Class<?>[] parameterTypes = method.getParameterTypes();
                params = new Object[parameterTypes.length];
            }
            Object ruleReturn = ruleName.invoke((Object)this.parser, params);
            if (this.parser.hasErrors()) {
                System.out.println(this.parser.getErrorMessages());
            }
            return ruleReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private void createParser(CharStream charStream) {
        this.parser = DRLFactory.buildParser((CharStream)charStream, (LanguageLevelOption)LanguageLevelOption.DRL6);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        Assertions.assertThat((String)expected).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = this.getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }
}

