/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.mvel.compiler.oopath.model.Room;
import org.drools.mvel.compiler.oopath.model.SensorEvent;
import org.drools.mvel.compiler.oopath.model.Thing;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.Variable;

@RunWith(value=Parameterized.class)
public class OOPathQueriesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathQueriesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testQueryFromCode() {
        String drl = "import org.drools.mvel.compiler.oopath.model.Thing;\nquery isContainedIn( Thing $x, Thing $y )\n    $y := /$x/children\nor\n    ( $z := /$x/children and isContainedIn( $z, $y; ) )\nend\n";
        Thing smartphone = new Thing("smartphone");
        List<String> itemList = Arrays.asList("display", "keyboard", "processor");
        itemList.stream().map(item -> new Thing((String)item)).forEach(thing -> smartphone.addChild((Thing)thing));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.Thing;\nquery isContainedIn( Thing $x, Thing $y )\n    $y := /$x/children\nor\n    ( $z := /$x/children and isContainedIn( $z, $y; ) )\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)smartphone);
        QueryResults queryResults = ksession.getQueryResults("isContainedIn", new Object[]{smartphone, Variable.v});
        List resultList = StreamSupport.stream(queryResults.spliterator(), false).map(row -> ((Thing)row.get("$y")).getName()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(resultList).as("Query does not contain all items", new Object[0])).containsAll(itemList);
        ksession.dispose();
    }

    @Test
    public void testReactiveQuery() {
        String drl = "import org.drools.mvel.compiler.oopath.model.Room;\nimport org.drools.mvel.compiler.oopath.model.Sensor;\nimport org.drools.mvel.compiler.oopath.model.SensorEvent;\nquery temperature ( Room $r, double $t )\n    $t := /$r/temperatureSensor/value\nend\nrule \"Change sensor value\" when\n    $e : SensorEvent( $s : sensor, $v : value)\nthen\n    modify($s) { setValue($v) }\n    retract($e)\nend\nrule \"Turn heating on\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t < 20 )then\n    $r.getHeating().setOn(true);\nend\nrule \"Turn heating off\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t > 20 )then\n    $r.getHeating().setOn(false);\nend\n";
        Room room = new Room("Room");
        room.getTemperatureSensor().setValue(15.0);
        room.getHeating().setOn(false);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.Room;\nimport org.drools.mvel.compiler.oopath.model.Sensor;\nimport org.drools.mvel.compiler.oopath.model.SensorEvent;\nquery temperature ( Room $r, double $t )\n    $t := /$r/temperatureSensor/value\nend\nrule \"Change sensor value\" when\n    $e : SensorEvent( $s : sensor, $v : value)\nthen\n    modify($s) { setValue($v) }\n    retract($e)\nend\nrule \"Turn heating on\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t < 20 )then\n    $r.getHeating().setOn(true);\nend\nrule \"Turn heating off\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t > 20 )then\n    $r.getHeating().setOn(false);\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)room);
        ksession.insert((Object)room.getTemperatureSensor());
        ksession.insert((Object)room.getHeating());
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)room.getHeating().isOn()).as("Temperature is bellow 20 degrees of Celsius. Heating should be turned on.", new Object[0])).isTrue();
        ksession.insert((Object)new SensorEvent(room.getTemperatureSensor(), 25.0));
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)room.getHeating().isOn()).as("Temperature is higher than 20 degrees of Celsius. Heating should be turned off.", new Object[0])).isFalse();
        ksession.dispose();
    }

    @Test
    public void testNonReactiveOOPathInQuery() {
        String drl = "import org.drools.mvel.compiler.oopath.model.Room;\nimport org.drools.mvel.compiler.oopath.model.Sensor;\nimport org.drools.mvel.compiler.oopath.model.SensorEvent;\nquery temperature ( Room $r, double $t )\n    $t := /$r?/temperatureSensor/value\nend\nrule \"Change sensor value\" when\n    $e : SensorEvent( $s : sensor, $v : value)\nthen\n    modify($s) { setValue($v) }\n    retract($e)\nend\nrule \"Turn heating on\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t < 20 )then\n    $r.getHeating().setOn(true);\nend\nrule \"Turn heating off\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t > 20 )then\n    $r.getHeating().setOn(false);\nend\n";
        Room room = new Room("Room");
        room.getTemperatureSensor().setValue(15.0);
        room.getHeating().setOn(false);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.Room;\nimport org.drools.mvel.compiler.oopath.model.Sensor;\nimport org.drools.mvel.compiler.oopath.model.SensorEvent;\nquery temperature ( Room $r, double $t )\n    $t := /$r?/temperatureSensor/value\nend\nrule \"Change sensor value\" when\n    $e : SensorEvent( $s : sensor, $v : value)\nthen\n    modify($s) { setValue($v) }\n    retract($e)\nend\nrule \"Turn heating on\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t < 20 )then\n    $r.getHeating().setOn(true);\nend\nrule \"Turn heating off\" when\n    $r : Room()\n    temperature( $r, $t; )\n    eval( $t > 20 )then\n    $r.getHeating().setOn(false);\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)room);
        ksession.insert((Object)room.getTemperatureSensor());
        ksession.insert((Object)room.getHeating());
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)room.getHeating().isOn()).as("Temperature is bellow 20 degrees of Celsius. Heating should be turned on.", new Object[0])).isTrue();
        ksession.insert((Object)new SensorEvent(room.getTemperatureSensor(), 25.0));
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)room.getHeating().isOn()).as("Query is not reactive. Heating should still be turned on.", new Object[0])).isTrue();
        ksession.dispose();
    }

    @Test
    public void testRecursiveOOPathQuery() {
        String drl = "import org.drools.mvel.compiler.oopath.model.Thing;\nglobal java.util.List list\n\nrule \"Print all things contained in the Office\" when\n    $office : Thing( name == \"office\" )\n    isContainedIn( $office, thing; )\nthen\n    list.add( thing.getName() );\nend\n\nquery isContainedIn( Thing $x, Thing $y )\n    $y := /$x/children\nor\n    ( $z := /$x/children and isContainedIn( $z, $y; ) )\nend\n";
        Thing house = new Thing("house");
        Thing office = new Thing("office");
        house.addChild(office);
        Thing kitchen = new Thing("kitchen");
        house.addChild(kitchen);
        Thing knife = new Thing("knife");
        kitchen.addChild(knife);
        Thing cheese = new Thing("cheese");
        kitchen.addChild(cheese);
        Thing desk = new Thing("desk");
        office.addChild(desk);
        Thing chair = new Thing("chair");
        office.addChild(chair);
        Thing computer = new Thing("computer");
        desk.addChild(computer);
        Thing draw = new Thing("draw");
        desk.addChild(draw);
        Thing key = new Thing("key");
        draw.addChild(key);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.Thing;\nglobal java.util.List list\n\nrule \"Print all things contained in the Office\" when\n    $office : Thing( name == \"office\" )\n    isContainedIn( $office, thing; )\nthen\n    list.add( thing.getName() );\nend\n\nquery isContainedIn( Thing $x, Thing $y )\n    $y := /$x/children\nor\n    ( $z := /$x/children and isContainedIn( $z, $y; ) )\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)house);
        ksession.insert((Object)office);
        ksession.insert((Object)kitchen);
        ksession.insert((Object)knife);
        ksession.insert((Object)cheese);
        ksession.insert((Object)desk);
        ksession.insert((Object)chair);
        ksession.insert((Object)computer);
        ksession.insert((Object)draw);
        ksession.insert((Object)key);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"desk", "chair", "key", "draw", "computer"});
    }
}

