/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.runtime.pipeline.impl;

import com.sun.tools.xjc.Options;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DroolsJaxbHelperTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String simpleXsdRelativePath = "simple.xsd";

    public DroolsJaxbHelperTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testXsdModelInRule() {
        Field[] declaredFields;
        Method m2;
        String s1 = "package test; global java.util.List list; rule Init when then   insert( new Sub() );   insert( new Message() );   insert( new Test() );   insert( new Left() ); end\nrule CheckSub when  $s : Sub() then   list.add( \"Sub\" );  end\nrule CheckMsg when  $s : Message() then   list.add( \"Message\" );  end\n ";
        List resources = KieUtil.getResourcesFromDrls((String[])new String[]{"package test; global java.util.List list; rule Init when then   insert( new Sub() );   insert( new Message() );   insert( new Test() );   insert( new Left() ); end\nrule CheckSub when  $s : Sub() then   list.add( \"Sub\" );  end\nrule CheckMsg when  $s : Message() then   list.add( \"Message\" );  end\n "});
        InputStream simpleXsdStream = this.getClass().getResourceAsStream(simpleXsdRelativePath);
        Assert.assertNotNull((String)"Could not find resource: simple.xsd", (Object)simpleXsdStream);
        InputStreamResource xsdResource = new InputStreamResource(simpleXsdStream);
        xsdResource.setResourceType(ResourceType.XSD);
        xsdResource.setSourcePath("src/main/resources/simple.xsd");
        Options xjcOptions = new Options();
        xsdResource.setConfiguration((ResourceConfiguration)new JaxbConfigurationImpl(xjcOptions, "test-system-id"));
        resources.add(xsdResource);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])resources.toArray(new Resource[0]));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("Sub", "Message")));
        Collection fhs = ks.getFactHandles();
        Iterator iter = fhs.iterator();
        DefaultFactHandle subFh = null;
        DefaultFactHandle msgFh = null;
        DefaultFactHandle leftFh = null;
        DefaultFactHandle testFh = null;
        while (iter.hasNext()) {
            DefaultFactHandle dfh = (DefaultFactHandle)iter.next();
            if (dfh.getObjectClassName().equals("test.Sub")) {
                subFh = dfh;
                continue;
            }
            if (dfh.getObjectClassName().equals("test.Message")) {
                msgFh = dfh;
                continue;
            }
            if (dfh.getObjectClassName().equals("test.Left")) {
                leftFh = dfh;
                continue;
            }
            if (dfh.getObjectClassName().equals("test.Test")) {
                testFh = dfh;
                continue;
            }
            Assert.fail((String)("Unexpected FH class: " + dfh.getObjectClassName()));
        }
        Assert.assertNotNull((String)"No FactHandle for Sub found!", subFh);
        Assert.assertNotNull((String)"No FactHandle for Message found!", msgFh);
        Object xsdObj = subFh.getObject();
        Class<?> xsdClass = xsdObj.getClass();
        try {
            m2 = xsdClass.getMethod("getFld", new Class[0]);
            Assert.assertNotNull((Object)m2);
            Assert.assertEquals(String.class, m2.getReturnType());
            Assert.assertEquals((long)0L, (long)xsdClass.getFields().length);
            declaredFields = xsdClass.getDeclaredFields();
            Assert.assertEquals((long)1L, (long)declaredFields.length);
            Assert.assertEquals((Object)"fld", (Object)declaredFields[0].getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        xsdObj = msgFh.getObject();
        xsdClass = xsdObj.getClass();
        try {
            m2 = xsdClass.getMethod("getContent", new Class[0]);
            Assert.assertNotNull((Object)m2);
            Assert.assertEquals(List.class, m2.getReturnType());
            Assert.assertEquals((long)0L, (long)xsdClass.getFields().length);
            declaredFields = xsdClass.getDeclaredFields();
            Assert.assertEquals((long)1L, (long)declaredFields.length);
            Assert.assertEquals((Object)"content", (Object)declaredFields[0].getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

