/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DateCoercionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DateCoercionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDateCoercionWithOr() {
        String drl = "import java.util.Date\nglobal java.util.List list\ndeclare DateContainer\n     date: Date\nend\n\nrule Init when\nthen\n    insert(new DateContainer(new Date(0)));end\n\nrule \"Test rule\"\nwhen\n    $container: DateContainer( date >= \"15-Oct-2013\" || date <= \"01-Oct-2013\" )\nthen\n    list.add(\"working\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"working", list.get(0));
    }

    @Test
    public void testDateCoercionWithVariable() {
        String drl = "import java.util.Date\nglobal java.util.List list\ndeclare DateContainer\n     date: Date\nend\n\nrule Init when\nthen\n    insert(new DateContainer(new Date(0)));end\n\nrule \"Test rule\"\nwhen\n    $container: DateContainer( $date: date, $date <= \"01-Oct-2013\" )\nthen\n    list.add(\"working\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"working", list.get(0));
    }

    @Test
    public void testDateCoercionWithInstanceVariable() {
        String drl = "import " + DateContainer.class.getCanonicalName() + "\nimport java.util.Date\nglobal java.util.List list\nrule Init when\nthen\n    insert(new DateContainer(new Date(0)));end\n\nrule \"Test rule\"\nwhen\n    $container: DateContainer( date <= \"01-Oct-2013\" )\nthen\n    list.add(\"working\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"working", list.get(0));
    }

    @Test
    public void testDateCoercionWithNestedOr() {
        String drl = "import java.util.Date\nglobal java.util.List list\ndeclare DateContainer\n     date: Date\nend\n\nrule Init when\nthen\n    insert(new DateContainer(new Date( 1439882189744L )));end\n\nrule \"Test rule\"\nwhen\n    $container: DateContainer( (date >= \"19-Jan-2014\" && date <= \"03-Dec-2015\" ) || (date >= \"17-Dec-2016\" && date <= \"02-Jan-2017\" ) )\nthen\n    list.add(\"working\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"working", list.get(0));
    }

    public static class DateContainer {
        public final Date date;

        public DateContainer(Date date) {
            this.date = date;
        }
    }
}

