/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.mvel.compiler.Message;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class KieHelloWorldTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KieHelloWorldTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testHelloWorld() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", this.createDrl("R1"));
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testClassLoaderStore() throws Exception {
        String drl = "package org; declare Person name : String end";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieContainer kcontainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        KieProject kieProject = ((KieContainerImpl)kcontainer).getKieProject();
        ResultsImpl messages = kieProject.verify();
        Assert.assertSame((Object)kieProject.getClassLoader(), (Object)kcontainer.getClassLoader());
        ProjectClassLoader pcl = (ProjectClassLoader)kieProject.getClassLoader();
        Assertions.assertThat((byte[])((byte[])pcl.getStore().get("org/Person.class"))).isNotNull();
    }

    @Test
    public void testHelloWorldWithResource() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write(ks.getResources().newReaderResource((Reader)new StringReader(this.createDrl("R1"))).setResourceType(ResourceType.DRL).setSourcePath("src/main/resources/r1.txt"));
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testHelloWorldWithEmptyFile() throws Exception {
        String drl = this.createDrl("R1");
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl).write("src/main/resources/empty.drl", ks.getResources().newInputStreamResource((InputStream)new ByteArrayInputStream(new byte[0])));
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testFailingHelloWorld() throws Exception {
        String drl = "package org.drools.mvel.integrationtests\nimport " + Message.class.getCanonicalName() + "\nrule R1 when\n   $m : Message( nonExistentField == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieBuilder kb = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)1L, (long)kb.getResults().getMessages().size());
    }

    @Test
    public void testHelloWorldWithKBaseInclude() throws Exception {
        String drl = "package org.drools.mvel.integrationtests\ndeclare CancelFact\n cancel : boolean = true\nend\nrule R1 when\n $m : CancelFact( cancel == true )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieModuleModel module = ks.newKieModuleModel();
        String defaultBaseName = "defaultKBase";
        KieBaseModel defaultBase = module.newKieBaseModel("defaultKBase");
        defaultBase.setDefault(true);
        defaultBase.addPackage("*");
        defaultBase.newKieSessionModel("defaultKSession").setDefault(true);
        String includingBaseName = "includingKBase";
        KieBaseModel includingBase = module.newKieBaseModel("includingKBase");
        includingBase.setDefault(false);
        includingBase.addInclude("defaultKBase");
        includingBase.newKieSessionModel("includingKSession").setDefault(false);
        kfs.writeKModuleXML(module.toXML());
        KieBuilder kb = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)kb.getResults().getMessages().size());
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        FactType factType = ksession.getKieBase().getFactType("org.drools.mvel.integrationtests", "CancelFact");
        Assertions.assertThat((Object)factType).isNotNull();
        ksession.insert(factType.newInstance());
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testHelloWorldWithPackages() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/org/pkg1/r1.drl", this.createDrl("org.pkg1", "R1")).write("src/main/resources/KBase1/org/pkg2/r2.drl", this.createDrl("org.pkg2", "R2")).writeKModuleXML(this.createKieProjectWithPackages(ks, "org.pkg1").toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testHelloWorldUsingPackages() throws Exception {
        String drlDef = "package org.pkg1\nimport " + Message.class.getCanonicalName() + "\nrule R_def when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/r1_1.drl", drlDef).write("src/main/resources/KBase1/r1_2.drl", this.createDrl("org.pkg1", "R1")).write("src/main/resources/KBase1/r2.drl", this.createDrl("org.pkg2", "R2")).writeKModuleXML(this.createKieProjectWithPackages(ks, "org.pkg1").toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testHelloWorldUsingFolders() throws Exception {
        String drlDef = "package org.drools.mvel.integrationtests\nimport " + Message.class.getCanonicalName() + "\nrule R_def when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/org/pkg1/r1_1.drl", drlDef).write("src/main/resources/KBase1/org/pkg1/r1_2.drl", this.createDrl("R1")).write("src/main/resources/KBase1/org/pkg2/r2.drl", this.createDrl("R2")).writeKModuleXML(this.createKieProjectWithPackages(ks, "org.pkg1").setConfigurationProperty("drools.groupDRLsInKieBasesByFolder", "true").toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testHelloWorldWithWildcardPackages() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/org/pkg1/test/r1.drl", this.createDrlWithGlobal("org.pkg1.test", "R1")).write("src/main/resources/org/pkg2/test/r2.drl", this.createDrlWithGlobal("org.pkg2.test", "R2")).writeKModuleXML(this.createKieProjectWithPackages(ks, "org.pkg1.*").toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"R1", list.get(0));
    }

    @Test
    public void testHelloWorldWithWildcardPackagesComplex() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/rules/rules.drl", this.createDrlWithGlobal("rules", "R1")).write("src/main/resources/rules/tests/tests.drl", this.createDrlWithGlobal("rules.tests", "R2")).write("src/main/resources/aaarules/aaarules.drl", this.createDrlWithGlobal("aaarules", "R3")).write("src/main/resources/sample/brms601_1310778/rules/rules.drl", this.createDrlWithGlobal("sample.brms601_1310778.rules", "R4")).write("src/main/resources/sample/brms601_1310778/tests/tests.drl", this.createDrlWithGlobal("sample.brms601_1310778.rules", "R5")).write("src/main/resources/tests/tests.drl", this.createDrlWithGlobal("tests", "R6")).write("src/main/resources/rules2/rules2.drl", this.createDrlWithGlobal("rules2", "R7")).writeKModuleXML(this.createKieProjectWithPackages(ks, "rules.*").toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)true);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
        Assert.assertTrue((boolean)list.contains("R1"));
        Assert.assertTrue((boolean)list.contains("R2"));
    }

    public String createDrl(String ruleName) {
        return this.createDrl("org", ruleName);
    }

    public String createDrl(String packageName, String ruleName) {
        return "package " + packageName + "\nimport " + Message.class.getCanonicalName() + "\nrule " + ruleName + " when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
    }

    public String createDrlWithGlobal(String ruleName) {
        return this.createDrlWithGlobal("org", ruleName);
    }

    public String createDrlWithGlobal(String packageName, String ruleName) {
        return "package " + packageName + "\nglobal java.util.List list\nimport " + Message.class.getCanonicalName() + "\nrule " + ruleName + " when\n   $m : Message( message == \"Hello World\" )\nthen\n    list.add(\"" + ruleName + "\");end\n";
    }

    private KieModuleModel createKieProjectWithPackages(KieServices ks, String pkg) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel().setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage(pkg);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.REALTIME).setDefault(true);
        return kproj;
    }

    @Test
    public void testHelloWorldOnVersionRange() throws Exception {
        KieServices ks = KieServices.Factory.get();
        this.buildVersion(ks, "Hello World", "1.0");
        this.buildVersion(ks, "Aloha Earth", "1.1");
        this.buildVersion(ks, "Hi Universe", "1.2");
        ReleaseId latestReleaseId = ks.newReleaseId("org.kie", "hello-world", "LATEST");
        KieSession ksession = ks.newKieContainer(latestReleaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(latestReleaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hi Universe"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "hello-world", "1.0");
        ksession = ks.newKieContainer(releaseId1).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(releaseId1).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hi Universe"));
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "hello-world", "[1.0,1.2)");
        ksession = ks.newKieContainer(releaseId2).newKieSession("KSession1");
        ksession.insert((Object)new Message("Aloha Earth"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(releaseId2).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hi Universe"));
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
    }

    @Test
    public void testGetDefaultKieSessionWithNullName() throws Exception {
        KieServices ks = KieServices.Factory.get();
        this.buildVersion(ks, "Hello World", "1.0");
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieSession ksession = ks.newKieContainer(releaseId1).newKieSession((String)null);
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    private void buildVersion(KieServices ks, String message, String version) {
        String drl = "package org.drools.mvel.integrationtests\nimport " + Message.class.getCanonicalName() + "\nrule R1 when\n   $m : Message( message == \"" + message + "\" )\nthen\nend\n";
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", version);
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/org/pkg1/r1.drl", drl).writeKModuleXML(this.createKieProjectWithPackages(ks, "*").toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
    }

    @Test
    public void testHelloWorldWithPackagesAnd2KieBases() throws Exception {
        String drl1 = "package org.pkg1\nimport " + Message.class.getCanonicalName() + "\nrule R11 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\nrule R12 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2 = "package org.pkg2\nimport " + Message.class.getCanonicalName() + "\nrule R21 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\nrule R22 when\n   $m : Message( message == \"Aloha Earth\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/org/pkg1/r1.drl", drl1).write("src/main/resources/KBase1/org/pkg2/r2.drl", drl2).writeKModuleXML(this.createKieProjectWithPackagesAnd2KieBases(ks).toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hi Universe"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ksession.insert((Object)new Message("Aloha Earth"));
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(releaseId).newKieSession("KSession2");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(releaseId).newKieSession("KSession2");
        ksession.insert((Object)new Message("Hi Universe"));
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(releaseId).newKieSession("KSession2");
        ksession.insert((Object)new Message("Aloha Earth"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    private KieModuleModel createKieProjectWithPackagesAnd2KieBases(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel().setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage("org.pkg1").newKieSessionModel("KSession1");
        kproj.newKieBaseModel().setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage("org.pkg2").newKieSessionModel("KSession2");
        return kproj;
    }

    @Test
    public void testImport() throws Exception {
        String drl1 = "package rules\nimport " + Message.class.getCanonicalName() + "\nglobal java.util.List list\nrule R1 when\n    $m : Message( message == \"Hello World\" )\nthen\n    list.add(\"ok\");\nend\n";
        String drl2 = "package myrules\nimport " + Message.class.getCanonicalName() + "\nglobal java.util.List list\nrule R2 when\n   $m : Message( message == \"Hi Universe\" )\nthen\n   list.add(\"ko\");\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-import", "1.0");
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("kbase").addPackage("rules").newKieSessionModel("ksession").setDefault(true);
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/rules/r1.drl", drl1).write("src/main/resources/myrules/r2.drl", drl2).writeKModuleXML(kproj.toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("list", results);
        ksession.insert((Object)new Message("Hello World"));
        ksession.insert((Object)new Message("Hi Universe"));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"ok", results.get(0));
    }

    @Test
    public void testErrorReportingWithWrongKmodule() throws Exception {
        String kmodule = "<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n  <kbase name=\"ABC\" default=\"false\" eventProcessingMode=\"stream\" equalsBehavior=\"identity\"/>\n  <kbase name=\"ABC\" default=\"false\" eventProcessingMode=\"stream\" equalsBehavior=\"identity\"/>\n</kmodule>\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", this.createDrl("R1"));
        kfs.writeKModuleXML(kmodule);
        KieBuilder kb = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)1L, (long)kb.getResults().getMessages().size());
        Assert.assertTrue((boolean)((org.kie.api.builder.Message)kb.getResults().getMessages().get(0)).toString().contains("ABC"));
    }

    @Test
    public void testHelloWorldWithSpace() throws Exception {
        KieServices kieServices = KieServices.get();
        Path dir = Paths.get("/tmp/t tt", new String[0]);
        Files.createDirectories(dir, new FileAttribute[0]);
        String text = "rule \"Hello world rule\"\nwhen\nthen\n    System.out.println(\"Hello world\");end\n";
        Path filePath = dir.resolve("one.drl");
        Files.write(filePath, "rule \"Hello world rule\"\nwhen\nthen\n    System.out.println(\"Hello world\");end\n".getBytes(), new OpenOption[0]);
        KieFileSystem fs = kieServices.newKieFileSystem();
        fs.write(ResourceFactory.newUrlResource((String)"file:/tmp/t%20tt/one.drl"));
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)fs, (boolean)false);
        KieModule kieModule = kieBuilder.getKieModule();
        KieSession ksession = kieServices.newKieContainer(kieModule.getReleaseId()).newKieSession();
        ksession.insert(new Object());
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testVeyifyNotExistingKieBase() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", this.createDrl("R1"));
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        try {
            kieContainer.verify(new String[]{"notexistingKB"});
            Assert.fail((String)"Verifying a not existing KieBase should throw a RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("notexistingKB"));
        }
    }

    @Test
    public void testDeclarativeCalendars() {
        String weekendCalendarSource = "package org.mypackage;\n\npublic class WeekendCalendar implements org.kie.api.time.Calendar {\n        @Override\n        public boolean isTimeIncluded( long timestamp ) {\n            java.util.Calendar c = java.util.Calendar.getInstance();\n            c.setTimeInMillis(timestamp);\n            final int day = c.get(java.util.Calendar.DAY_OF_WEEK);\n            return day == java.util.Calendar.SATURDAY || day == java.util.Calendar.SUNDAY;\n        }\n    }";
        String weekdayCalendarSource = "package org.mypackage;\n\npublic class WeekdayCalendar implements org.kie.api.time.Calendar {\n        @Override\n        public boolean isTimeIncluded( long timestamp ) {\n            java.util.Calendar c = java.util.Calendar.getInstance();\n            c.setTimeInMillis(timestamp);\n            final int day = c.get(java.util.Calendar.DAY_OF_WEEK);\n            return day != java.util.Calendar.SATURDAY && day != java.util.Calendar.SUNDAY;\n        }\n    }";
        String drl = "package org.mypackage;\n\nglobal java.util.List list\n \nrule \"weekend\"\n    calendars \"weekend\"\n    \n    when\n    then\n        list.add(\"weekend\");\nend\n \nrule \"weekday\"\n    calendars \"weekday\"\n\n    when\n    then\n       list.add(\"weekday\");\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-calendar", "1.0");
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel().newKieSessionModel("KSession1").addCalendar("weekend", "org.mypackage.WeekendCalendar").addCalendar("weekday", "org.mypackage.WeekdayCalendar").setDefault(true);
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/org/mypackage/r1.drl", drl).write("src/main/java/org/mypackage/WeekendCalendar.java", weekendCalendarSource).write("src/main/java/org/mypackage/WeekdayCalendar.java", weekdayCalendarSource).writeKModuleXML(kproj.toXML());
        KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieSession ksession = ks.newKieContainer(releaseId).newKieSession("KSession1");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

