/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.mvel.integrationtests.FakeDRFAssemblerService;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.ResourceType;
import org.kie.internal.services.KieAssemblersImpl;

@RunWith(value=Parameterized.class)
public class PackageInMultipleResourcesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PackageInMultipleResourcesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSamePackageRulesInDRLAndRF() {
        KieAssemblersImpl assemblers = (KieAssemblersImpl)ServiceRegistry.getService(KieAssemblers.class);
        Map internalAssemblers = assemblers.getAssemblers();
        KieAssemblerService originalDRFAssemblerService = (KieAssemblerService)internalAssemblers.get(ResourceType.DRF);
        try {
            assemblers.accept((KieAssemblerService)new FakeDRFAssemblerService());
            KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rf_test_rules.drl", "rf_test_rueflow.rf"});
            KiePackage kiePackage = kbase.getKiePackage("com.example.rules");
            List ruleNames = kiePackage.getRules().stream().map(rule -> rule.getName()).collect(Collectors.toList());
            Assert.assertEquals((long)3L, (long)ruleNames.size());
            Assertions.assertThat(ruleNames).contains((Object[])new String[]{"RuleFlow-Split-example-xxx-DROOLS_DEFAULT", "Left Rule", "Right Rule"});
        }
        finally {
            if (originalDRFAssemblerService == null) {
                internalAssemblers.remove(ResourceType.DRF);
            } else {
                assemblers.accept(originalDRFAssemblerService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDifferentPackagesRulesInDRLAndRF() {
        KieAssemblersImpl assemblers = (KieAssemblersImpl)ServiceRegistry.getService(KieAssemblers.class);
        Map internalAssemblers = assemblers.getAssemblers();
        KieAssemblerService originalDRFAssemblerService = (KieAssemblerService)internalAssemblers.get(ResourceType.DRF);
        try {
            assemblers.accept((KieAssemblerService)new FakeDRFAssemblerService());
            KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rf_test_rules_different_pkg.drl", "rf_test_rueflow.rf"});
            KiePackage kiePackage = kbase.getKiePackage("com.example.rules");
            List ruleNames = kiePackage.getRules().stream().map(rule -> rule.getName()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)ruleNames.size());
            Assertions.assertThat(ruleNames).contains((Object[])new String[]{"RuleFlow-Split-example-xxx-DROOLS_DEFAULT"});
            KiePackage kiePackageDiffPkg = kbase.getKiePackage("com.example.rules.different.pkg");
            List ruleNamesDiffPkg = kiePackageDiffPkg.getRules().stream().map(rule -> rule.getName()).collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)ruleNamesDiffPkg.size());
            Assertions.assertThat(ruleNamesDiffPkg).contains((Object[])new String[]{"Left Rule", "Right Rule"});
        }
        finally {
            if (originalDRFAssemblerService == null) {
                internalAssemblers.remove(ResourceType.DRF);
            } else {
                assemblers.accept(originalDRFAssemblerService);
            }
        }
    }
}

