/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.font.TextMeasurer;
import java.awt.geom.Area;
import java.awt.im.InputContext;
import java.io.File;
import java.net.Inet4Address;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipFile;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;

@RunWith(value=Parameterized.class)
public class ParallelBuildTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private final List<Class<?>> classes = Arrays.asList(List.class, Color.class, Callable.class, AtomicBoolean.class, Lock.class, ZipFile.class, ColorSpace.class, TextMeasurer.class, Area.class, InputContext.class, Inet4Address.class, File.class);

    public ParallelBuildTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testParallelBuild() {
        StringBuilder sb = new StringBuilder();
        int rc = 0;
        for (Class<?> c : this.classes) {
            sb.append("rule \"rule_" + rc++ + "\"\n");
            sb.append("  when\n");
            sb.append("    a : " + c.getName() + "()\n");
            sb.append("  then\n");
            sb.append("    System.out.print(\".\");\n");
            sb.append("end\n");
            sb.append("\n");
        }
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{sb.toString()});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }
}

