/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.kie.api.KieBase;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.internal.conf.ConstraintJittingThresholdOption;

public abstract class AbstractConcurrentTest {
    protected final boolean enforcedJitting;
    protected final boolean serializeKieBase;
    protected final boolean sharedKieBase;
    protected final boolean sharedKieSession;
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AbstractConcurrentTest(boolean enforcedJitting, boolean serializeKieBase, boolean sharedKieBase, boolean sharedKieSession, KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.enforcedJitting = enforcedJitting;
        this.serializeKieBase = serializeKieBase;
        this.sharedKieBase = sharedKieBase;
        this.sharedKieSession = sharedKieSession;
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parallelTest(int threadCount, TestExecutor testExecutor) throws InterruptedException {
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        int i = 0;
        while (i < threadCount) {
            int counter = i++;
            tasks.add(() -> testExecutor.execute(counter));
        }
        ExecutorService executorService = this.createExecutorService(threadCount);
        try {
            this.executeAndAssertTasks(executorService, tasks, threadCount);
        }
        finally {
            this.shutdownExecutorService(executorService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parallelTest(int repetitions, int threadCount, TestWithSessionExecutor testExecutor, String globalName, Object global, String ... drls) throws InterruptedException {
        for (int rep = 0; rep < repetitions; ++rep) {
            ExecutorService executor = this.createExecutorService(threadCount);
            KieBase sharedKieBase = this.getKieBase(drls);
            KieSession sharedKieSession = this.getKieSession(sharedKieBase, globalName, global);
            try {
                ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
                int i = 0;
                while (i < threadCount) {
                    int counter = i++;
                    tasks.add(() -> {
                        KieBase kieBaseForTest;
                        KieBase kieBase = kieBaseForTest = this.sharedKieBase ? sharedKieBase : this.getKieBase(drls);
                        if (this.sharedKieSession) {
                            return testExecutor.execute(sharedKieSession, counter);
                        }
                        return this.executeInSeparateSession(testExecutor, kieBaseForTest, globalName, global, counter);
                    });
                }
                this.executeAndAssertTasks(executor, tasks, threadCount);
                continue;
            }
            finally {
                sharedKieSession.dispose();
                this.shutdownExecutorService(executor);
            }
        }
    }

    private void executeAndAssertTasks(ExecutorService executor, List<Callable<Boolean>> tasks, int threadCount) {
        ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
        for (Callable<Boolean> task : tasks) {
            ecs.submit(task);
        }
        int successCounter = 0;
        for (int i = 0; i < threadCount; ++i) {
            try {
                if (!((Boolean)ecs.take().get()).booleanValue()) continue;
                ++successCounter;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Assertions.assertThat((int)successCounter).isEqualTo(threadCount);
    }

    private ExecutorService createExecutorService(int threadCount) {
        return Executors.newFixedThreadPool(threadCount, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return new Thread(r);
        });
    }

    private void shutdownExecutorService(ExecutorService executorService) throws InterruptedException {
        executorService.shutdown();
        if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
            executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInSeparateSession(TestWithSessionExecutor testExecutor, KieBase kieBase, String globalName, Object global, int counter) {
        KieSession kieSessionLocal = this.getKieSession(kieBase, globalName, global);
        try {
            boolean bl = testExecutor.execute(kieSessionLocal, counter);
            return bl;
        }
        finally {
            kieSessionLocal.dispose();
        }
    }

    protected synchronized KieBase getKieBase(String ... drls) {
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])drls);
        KieBaseOption[] kbOptions = this.enforcedJitting ? new KieBaseOption[]{ConstraintJittingThresholdOption.get((int)0)} : new KieBaseOption[]{};
        KieBase kieBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])kbOptions);
        return kieBase;
    }

    private KieSession getKieSession(KieBase kieBase, String globalName, Object global) {
        KieSession kieSession = kieBase.newKieSession();
        if (global != null) {
            kieSession.setGlobal(globalName, global);
        }
        return kieSession;
    }

    private KieBase serializeAndDeserializeKieBase(KieBase kieBase) {
        KieBase kieBase2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(kieBase);
            out.flush();
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        try {
            kieBase2 = (KieBase)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return kieBase2;
    }

    static interface TestExecutor {
        public boolean execute(int var1);
    }

    static interface TestWithSessionExecutor {
        public boolean execute(KieSession var1, int var2);
    }
}

