/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.eventgenerator;

import org.drools.mvel.integrationtests.eventgenerator.Event;

class EventOccurrence {
    private final String eventSenderId;
    private final Event event;
    private final long evDeviation;
    private final long evMinDur;
    private int itemCounter;
    private final int maxItems;
    private final long latestEnd;
    private final boolean infinite;

    public EventOccurrence(String eventSenderId, Event ev, long evMinDur, long avgOccur, long earliestStart, long maxDuration, int maxItems) {
        this.eventSenderId = eventSenderId;
        this.evMinDur = evMinDur;
        this.evDeviation = 2L * (avgOccur - evMinDur);
        this.event = ev;
        this.event.setTimes(earliestStart);
        this.latestEnd = earliestStart + maxDuration;
        this.maxItems = maxItems;
        this.itemCounter = 0;
        this.infinite = maxDuration <= 0L;
        this.calculateNextEventOccurrence();
    }

    public boolean calculateNextEventOccurrence() {
        this.event.setTimes(this.event.getEndTime() + (this.evDeviation - 1L) + this.evMinDur);
        if (this.maxItems <= 0) {
            return this.isInfinite() || this.event.getEndTime() < this.latestEnd;
        }
        ++this.itemCounter;
        if (this.itemCounter > this.maxItems) {
            return false;
        }
        return this.isInfinite() || this.event.getEndTime() < this.latestEnd;
    }

    private boolean isInfinite() {
        return this.infinite;
    }

    public String getEventSenderId() {
        return this.eventSenderId;
    }

    public long getNextOccurrenceTime() {
        return this.event.getEndTime();
    }

    public Event getEvent() {
        return this.event;
    }
}

