/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.eventgenerator;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.drools.mvel.integrationtests.eventgenerator.AbstractEventListener;
import org.drools.mvel.integrationtests.eventgenerator.Event;
import org.drools.mvel.integrationtests.eventgenerator.EventGenerationTimeComparator;
import org.drools.mvel.integrationtests.eventgenerator.EventOccurrence;
import org.drools.mvel.integrationtests.eventgenerator.PseudoSessionClock;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class SimpleEventGenerator {
    private final KieSession ksession;
    private final long generationEndTime;
    private static AbstractEventListener sendListener;
    private final boolean endInfinite;
    private int eventSourceIdCounter;
    private final Map<String, Integer> eventSourceIds;
    private final LinkedList<EventOccurrence> nextEventSource;
    private final PseudoSessionClock myClock;
    FactHandle clockHandle;

    public SimpleEventGenerator(KieSession ksession, AbstractEventListener l) {
        this(ksession, l, 0L);
    }

    public SimpleEventGenerator(KieSession ksession, AbstractEventListener l, long generationDuration) {
        this.ksession = ksession;
        sendListener = l;
        this.myClock = new PseudoSessionClock();
        this.clockHandle = ksession.insert((Object)this.myClock);
        this.generationEndTime = this.myClock.calcFuturePointInTime(generationDuration);
        this.endInfinite = generationDuration == 0L;
        this.eventSourceIdCounter = 0;
        this.eventSourceIds = new HashMap<String, Integer>();
        this.nextEventSource = new LinkedList();
    }

    public boolean isEndInfinite() {
        return this.endInfinite;
    }

    public EventOccurrence addEventSource(String id, Event ev, long minOccur, long avgOccur) {
        return this.addEventSource(id, ev, minOccur, avgOccur, 0L, 0);
    }

    public EventOccurrence addEventSource(String id, Event ev, long minOccur, long avgOccur, long maxDuration, int maxItems) {
        if (!this.eventSourceIds.containsKey(id)) {
            this.eventSourceIds.put(id, this.eventSourceIdCounter++);
            EventOccurrence evOcc = new EventOccurrence(id, ev, minOccur, avgOccur, this.myClock.getCurrentTime(), maxDuration, maxItems);
            this.nextEventSource.add(evOcc);
            return evOcc;
        }
        return null;
    }

    public EventOccurrence addDelayedEventSource(String id, Event ev, long minOccur, long avgOccur, long startTime) {
        return this.addDelayedEventSource(id, ev, minOccur, avgOccur, startTime, 0L, 0);
    }

    public EventOccurrence addDelayedEventSource(String id, Event ev, long minOccur, long avgOccur, long startTime, long maxDuration, int maxItems) {
        if (!this.eventSourceIds.containsKey(id)) {
            this.eventSourceIds.put(id, this.eventSourceIdCounter++);
            EventOccurrence evOcc = new EventOccurrence(id, ev, minOccur, avgOccur, startTime, maxDuration, maxItems);
            this.nextEventSource.add(evOcc);
            return evOcc;
        }
        return null;
    }

    public void removeEventSource(String id) {
        Integer hashValue = this.eventSourceIds.get(id);
        if (hashValue != null) {
            this.nextEventSource.remove(hashValue);
            this.eventSourceIds.remove(id);
            --this.eventSourceIdCounter;
        }
    }

    public static void sendGeneratedEvent(Event ev) {
        sendListener.generatedEventSent(ev);
    }

    public void generate() {
        this.nextEventSource.sort(new EventGenerationTimeComparator());
        while (!this.nextEventSource.isEmpty()) {
            int index;
            EventOccurrence currentEGT = this.nextEventSource.removeFirst();
            Event currentEvent = (Event)currentEGT.getEvent().clone();
            this.myClock.setTime(currentEGT.getNextOccurrenceTime());
            SimpleEventGenerator.sendGeneratedEvent(currentEvent);
            this.ksession.update(this.clockHandle, (Object)this.myClock);
            boolean occIsValid = currentEGT.calculateNextEventOccurrence();
            if (!occIsValid || !this.isEndInfinite() && currentEGT.getNextOccurrenceTime() >= this.generationEndTime || (index = Collections.binarySearch(this.nextEventSource, currentEGT, new EventGenerationTimeComparator())) >= 0) continue;
            this.nextEventSource.add(-index - 1, currentEGT);
        }
    }
}

