/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.sequential;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.DynamicRulesTest;
import org.drools.mvel.integrationtests.phreak.A;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class SequentialTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SequentialTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSequentialPlusPhreakOperationComplex() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test\n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global  " + List.class.getCanonicalName() + " list\n";
        str = str + "rule r0 when\n";
        str = str + "then\n";
        str = str + "    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup( 'g1' ).setFocus();\n";
        str = str + "    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup( 'g2' ).setFocus();\n";
        str = str + "    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup( 'g1' ).setFocus();\n";
        str = str + "end\n";
        str = str + "rule r1 agenda-group 'g1' when\n";
        str = str + "    a : A( object > 0 )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "    modify(a) { setObject( 3 ) };\n";
        str = str + "end\n";
        str = str + "rule r1_x agenda-group 'g1' when\n";
        str = str + "    a : A( object == 2 )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r1_y agenda-group 'g1' when\n";
        str = str + "    a : A( object == 5 )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r2 agenda-group 'g1' when\n";
        str = str + "    a : A( object < 3 )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r3 agenda-group 'g1' when\n";
        str = str + "    a : A(object >= 3  )\n";
        str = str + "then\n";
        str = str + "    modify(a) { setObject( 5 ) };\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r4 agenda-group 'g1' when\n";
        str = str + "    a : A(object >= 2  )\n";
        str = str + "then\n";
        str = str + "    modify(a) { setObject( 5 ) };\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r6 agenda-group 'g2' when\n";
        str = str + "    a : A(object < 5  )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r7 agenda-group 'g2' when\n";
        str = str + "    a : A(object >= 3  )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r8 agenda-group 'g2' when\n";
        str = str + "    a : A(object >= 5  )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r9 agenda-group 'g2' when\n";
        str = str + "    a : A(object >= 5  )\n";
        str = str + "then\n";
        str = str + "    modify(a) { setObject( 2 ) };\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute(CommandFactory.newInsertElements(Arrays.asList(new A(1))));
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"r1", list.get(0));
        Assert.assertEquals((Object)"r3", list.get(1));
        Assert.assertEquals((Object)"r4", list.get(2));
        Assert.assertEquals((Object)"r7", list.get(3));
        Assert.assertEquals((Object)"r8", list.get(4));
        Assert.assertEquals((Object)"r9", list.get(5));
    }

    @Test
    public void testSequentialPlusPhreakRevisitOriginallyEmptyGroup() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test\n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global  " + List.class.getCanonicalName() + " list\n";
        str = str + "rule r0 when\n";
        str = str + "then\n";
        str = str + "    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup( 'g1' ).setFocus();\n";
        str = str + "    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup( 'g2' ).setFocus();\n";
        str = str + "    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup( 'g1' ).setFocus();\n";
        str = str + "end\n";
        str = str + "rule r1_x agenda-group 'g1' when\n";
        str = str + "    a : A( object == 2 )\n";
        str = str + "then\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        str = str + "rule r9 agenda-group 'g2' when\n";
        str = str + "    a : A(object >= 5  )\n";
        str = str + "then\n";
        str = str + "    modify(a) { setObject( 2 ) };\n";
        str = str + "    list.add( drools.getRule().getName() );\n";
        str = str + "end\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute(CommandFactory.newInsertElements(Arrays.asList(new A(5))));
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"r9", list.get(0));
    }

    @Test
    public void testBasicOperation() throws Exception {
        KieModule kieModule = KieUtil.getKieModuleFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"simpleSequential.drl"});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("p1", "stilton");
        Person p2 = new Person("p2", "cheddar");
        Person p3 = new Person("p3", "stilton");
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 15);
        ksession.execute(CommandFactory.newInsertElements(Arrays.asList(p1, stilton, p2, cheddar, p3)));
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testSalience() throws Exception {
        KieModule kieModule = KieUtil.getKieModuleFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"simpleSalience.drl"});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Object)new Person("pob"));
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"rule 3", list.get(0));
        Assert.assertEquals((Object)"rule 2", list.get(1));
        Assert.assertEquals((Object)"rule 1", list.get(2));
    }

    @Test
    public void testKnowledgeRuntimeAccess() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test\n";
        str = str + "import org.drools.mvel.compiler.Message\n";
        str = str + "rule \"Hello World\"\n";
        str = str + "when\n";
        str = str + "    Message( )\n";
        str = str + "then\n";
        str = str + "    System.out.println( drools.getKieRuntime() );\n";
        str = str + "end\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ksession.execute((Object)new Message("help"));
    }

    @Test
    public void testEvents() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test\n";
        str = str + "import org.drools.mvel.compiler.Message\n";
        str = str + "rule \"Hello World\"\n";
        str = str + "when\n";
        str = str + "    Message( )\n";
        str = str + "then\n";
        str = str + "    System.out.println( drools.getKieRuntime() );\n";
        str = str + "end\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        final ArrayList list = new ArrayList();
        ksession.addEventListener(new AgendaEventListener(){

            public void matchCancelled(MatchCancelledEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void matchCreated(MatchCreatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }
        });
        ksession.addEventListener(new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                list.add(event);
            }
        });
        ksession.execute((Object)new Message("help"));
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testSequentialWithRulebaseUpdate() throws Exception {
        KieModule kieModule = KieUtil.getKieModuleFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"simpleSalience.drl"});
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Object)new Person("pob"));
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", DynamicRulesTest.class, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic3.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        ksession = kbase.newStatelessKieSession();
        ksession.setGlobal("list", list);
        Person person = new Person("bop");
        ksession.execute((Object)person);
        Assert.assertEquals((long)7L, (long)list.size());
        Assert.assertEquals((Object)"rule 3", list.get(0));
        Assert.assertEquals((Object)"rule 2", list.get(1));
        Assert.assertEquals((Object)"rule 1", list.get(2));
        Assert.assertEquals((Object)"rule 3", list.get(3));
        Assert.assertEquals((Object)"rule 2", list.get(4));
        Assert.assertEquals((Object)"rule 1", list.get(5));
        Assert.assertEquals((Object)person, list.get(6));
    }

    @Test
    public void testProfileSequential() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "Sequential mode", 0, "sequentialProfile.drl");
        this.runTestProfileManyRulesAndFacts(true, "Sequential mode", 0, "sequentialProfile.drl");
        System.gc();
        Thread.sleep(100L);
    }

    @Test
    public void testProfileRETE() throws Exception {
        this.runTestProfileManyRulesAndFacts(false, "Normal RETE mode", 0, "sequentialProfile.drl");
        this.runTestProfileManyRulesAndFacts(false, "Normal RETE mode", 0, "sequentialProfile.drl");
        System.gc();
        Thread.sleep(100L);
    }

    @Test
    public void testNumberofIterationsSeq() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "SEQUENTIAL", 2000, "sequentialProfile.drl");
    }

    @Test
    public void testNumberofIterationsRETE() throws Exception {
        this.runTestProfileManyRulesAndFacts(false, "RETE", 2000, "sequentialProfile.drl");
    }

    @Test
    public void testPerfJDT() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "JDT", 2000, "sequentialProfile.drl");
    }

    @Test
    public void testPerfMVEL() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "MVEL", 2000, "sequentialProfileMVEL.drl");
    }

    private void runTestProfileManyRulesAndFacts(boolean sequentialMode, String message, int timetoMeasureIterations, String file) throws DroolsParserException, IOException, Exception {
        SequentialOption opt = sequentialMode ? SequentialOption.YES : SequentialOption.NO;
        KieModule kieModule = KieUtil.getKieModuleFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{file});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{opt});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Object[] data = new Object[50000];
        for (int i = 0; i < data.length; ++i) {
            if (i % 2 == 0) {
                Person p = new Person("p" + i, "stilton");
                data[i] = p;
                continue;
            }
            data[i] = new Cheese("cheddar", i);
        }
        if (timetoMeasureIterations == 0) {
            long start = System.currentTimeMillis();
            ksession.execute(CommandFactory.newInsertElements(Arrays.asList(data)));
            System.out.println("Time for " + message + ":" + (System.currentTimeMillis() - start));
            Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        } else {
            long start = System.currentTimeMillis();
            long end = start + (long)timetoMeasureIterations;
            int count = 0;
            while (System.currentTimeMillis() < end) {
                StatelessKieSession sess2 = kbase.newStatelessKieSession();
                ArrayList list2 = new ArrayList();
                sess2.setGlobal("list", list2);
                sess2.execute(CommandFactory.newInsertElements(Arrays.asList(data)));
                ++count;
            }
            System.out.println("Iterations in for " + message + " : " + count);
        }
    }

    @Test(timeout=10000L)
    public void testSequentialWithNoLoop() throws Exception {
        String str = "package org.drools.mvel.compiler.test\nimport \n" + Message.class.getCanonicalName() + ";rule R1 no-loop when\n    $s : String( )    $m : Message( )\nthen\n    modify($m) { setMessage($s) };\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieContainer kieContainer = ks.newKieContainer(kieModule.getReleaseId());
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession sequentialKsession = kbase.newStatelessKieSession();
        List result = (List)sequentialKsession.execute(CommandFactory.newInsertElements(Arrays.asList("test", new Message())));
        Assert.assertEquals((long)2L, (long)result.size());
        StatelessKieSession ksession = kieContainer.getKieBase().newStatelessKieSession();
        result = (List)ksession.execute(CommandFactory.newInsertElements(Arrays.asList("test", new Message())));
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testSharedSegment() throws Exception {
        String str = "package org.drools.mvel.compiler.test\nimport \n" + Message.class.getCanonicalName() + ";rule R1 when\n    $s : String()\n    $m : Message()\n    $i : Integer( this < $s.length )\nthen\n    modify($m) { setMessage($s) };\nend\n\nrule R2 when\n    $s : String()\n    $m : Message()\n    $i : Integer( this > $s.length )\nthen\nend\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ksession.execute(CommandFactory.newInsertElements(Arrays.asList("test", new Message(), 3, 5)));
    }
}

