/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.testcoverage.common.model.Cell;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.SerializationHelper;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;

public abstract class AbstractCellTest {
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AbstractCellTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCell() throws IOException, ClassNotFoundException {
        String drl = "package evalmodify;\n\nimport " + Cell.class.getCanonicalName() + "\nimport java.lang.Integer\n\nrule \"test eval\"\n    when\n        cell1 : Cell(value1:value != 0)\n        cell2 : Cell(value2:value < value1)\n        eval (true)\n    then\n        cell2.setValue(value2 + 1);\n        update(cell2);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cell-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_REALTIME.getKieSessionConfiguration(), env);
        try {
            Cell cell1 = new Cell(9);
            Cell cell = new Cell(0);
            session.insert((Object)cell1);
            session.insert((Object)cell);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
            session.fireAllRules();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assertions.assertThat((int)cell.getValue()).isEqualTo(9);
            } else {
                Assertions.assertThat((int)cell.getValue()).isEqualTo(0);
            }
        }
        finally {
            session.dispose();
        }
    }
}

