/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.core.impl.InternalKieContainer;
import org.drools.modelcompiler.ExecutableModelProject;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MultipleIncrementalCompilationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private final String PERSON_LIST_COMMON_SRC = "package org.test;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class PersonList {\n    private List<Person> persons;\n    public PersonList() {\n        this.persons = new ArrayList<>();\n        persons.add(new Person(\"John\"));\n        persons.add(new Person(\"Paul\"));\n    }\n    public PersonList(List<Person> persons) {\n        this.persons = persons;\n    }\n    public List<Person> getPersons() {\n        return persons;\n    }\n    public void setPersons(List<Person> persons) {\n        this.persons = persons;\n    }\n";

    public MultipleIncrementalCompilationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSnapshotUpdateWithFrom() {
        String personListSrc1 = "package org.test;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class PersonList {\n    private List<Person> persons;\n    public PersonList() {\n        this.persons = new ArrayList<>();\n        persons.add(new Person(\"John\"));\n        persons.add(new Person(\"Paul\"));\n    }\n    public PersonList(List<Person> persons) {\n        this.persons = persons;\n    }\n    public List<Person> getPersons() {\n        return persons;\n    }\n    public void setPersons(List<Person> persons) {\n        this.persons = persons;\n    }\n}";
        String personListSrc2 = "package org.test;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class PersonList {\n    private List<Person> persons;\n    public PersonList() {\n        this.persons = new ArrayList<>();\n        persons.add(new Person(\"John\"));\n        persons.add(new Person(\"Paul\"));\n    }\n    public PersonList(List<Person> persons) {\n        this.persons = persons;\n    }\n    public List<Person> getPersons() {\n        return persons;\n    }\n    public void setPersons(List<Person> persons) {\n        this.persons = persons;\n    }\n    public void someMethod1() { }\n}";
        String personListSrc3 = "package org.test;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class PersonList {\n    private List<Person> persons;\n    public PersonList() {\n        this.persons = new ArrayList<>();\n        persons.add(new Person(\"John\"));\n        persons.add(new Person(\"Paul\"));\n    }\n    public PersonList(List<Person> persons) {\n        this.persons = persons;\n    }\n    public List<Person> getPersons() {\n        return persons;\n    }\n    public void setPersons(List<Person> persons) {\n        this.persons = persons;\n    }\n    public void someMethod1() { }\n    public void someMethod2() { }\n}";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.test", "myTest", "1.0.0-SNAPSHOT");
        this.buildKjar(releaseId, "package org.test;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class PersonList {\n    private List<Person> persons;\n    public PersonList() {\n        this.persons = new ArrayList<>();\n        persons.add(new Person(\"John\"));\n        persons.add(new Person(\"Paul\"));\n    }\n    public PersonList(List<Person> persons) {\n        this.persons = persons;\n    }\n    public List<Person> getPersons() {\n        return persons;\n    }\n    public void setPersons(List<Person> persons) {\n        this.persons = persons;\n    }\n}");
        KieContainer kc = ks.newKieContainer(releaseId);
        this.runRules(kc);
        this.buildKjar(releaseId, "package org.test;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class PersonList {\n    private List<Person> persons;\n    public PersonList() {\n        this.persons = new ArrayList<>();\n        persons.add(new Person(\"John\"));\n        persons.add(new Person(\"Paul\"));\n    }\n    public PersonList(List<Person> persons) {\n        this.persons = persons;\n    }\n    public List<Person> getPersons() {\n        return persons;\n    }\n    public void setPersons(List<Person> persons) {\n        this.persons = persons;\n    }\n    public void someMethod1() { }\n}");
        kc.updateToVersion(releaseId);
        this.runRules(kc);
        this.buildKjar(releaseId, "package org.test;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class PersonList {\n    private List<Person> persons;\n    public PersonList() {\n        this.persons = new ArrayList<>();\n        persons.add(new Person(\"John\"));\n        persons.add(new Person(\"Paul\"));\n    }\n    public PersonList(List<Person> persons) {\n        this.persons = persons;\n    }\n    public List<Person> getPersons() {\n        return persons;\n    }\n    public void setPersons(List<Person> persons) {\n        this.persons = persons;\n    }\n    public void someMethod1() { }\n    public void someMethod2() { }\n}");
        kc.updateToVersion(releaseId);
        this.runRules(kc);
    }

    private void buildKjar(ReleaseId releaseId, String personListSrc) {
        String personSrc = "package org.test;\npublic class Person {\n    private String name;\n    public Person() {}\n    public Person(String name) {\n        this.name = name;\n    }\n    public String getName() {\n        return name;\n    }\n    public void setName(String name) {\n        this.name = name;\n    }\n}";
        String drl = "package org.test;\nrule init\n    salience 100\n    when\n        String(this == \"Start\");\n    then\n        insert(new PersonList());\nend\nrule R1\n    dialect\"mvel\"\n    when\n        $list : PersonList()\n        ($p : Person() from $list.persons)\n    then\n        System.out.println($p.getName());\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(releaseId);
        kfs.write("src/main/java/org/test/Person.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\npublic class Person {\n    private String name;\n    public Person() {}\n    public Person(String name) {\n        this.name = name;\n    }\n    public String getName() {\n        return name;\n    }\n    public void setName(String name) {\n        this.name = name;\n    }\n}")));
        kfs.write("src/main/java/org/test/PersonList.java", ks.getResources().newReaderResource((Reader)new StringReader(personListSrc)));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\nrule init\n    salience 100\n    when\n        String(this == \"Start\");\n    then\n        insert(new PersonList());\nend\nrule R1\n    dialect\"mvel\"\n    when\n        $list : PersonList()\n        ($p : Person() from $list.persons)\n    then\n        System.out.println($p.getName());\nend")).setResourceType(ResourceType.DRL).setSourcePath("org/test/rules.drl"));
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            kieBuilder.buildAll(ExecutableModelProject.class);
        } else {
            kieBuilder.buildAll(DrlProject.class);
        }
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
    }

    private void runRules(KieContainer kieContainer) {
        KieSession ksession = ((InternalKieContainer)kieContainer).getKieSession();
        ksession.insert((Object)"Start");
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }
}

