/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.drools.mvel.BaseTupleIndexHashTableIteratorTest;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.mockito.Mockito;

public class RightTupleIndexHashTableIteratorTest
extends BaseTupleIndexHashTableIteratorTest {
    public RightTupleIndexHashTableIteratorTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Test
    public void test1() {
        BetaNodeFieldConstraint constraint0 = RightTupleIndexHashTableIteratorTest.createFooThisEqualsDBetaConstraint(this.useLambdaConstraint);
        BetaNodeFieldConstraint[] constraints = new BetaNodeFieldConstraint[]{constraint0};
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        SingleBetaConstraints betaConstraints = null;
        betaConstraints = new SingleBetaConstraints(constraints, config);
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config, (short)181);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ss = kBase.newKieSession();
        InternalFactHandle fh1 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh2 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh3 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh4 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh5 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh6 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh7 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("cream", 3));
        InternalFactHandle fh8 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("gorda", 15));
        InternalFactHandle fh9 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("beer", 16));
        InternalFactHandle fh10 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("mars", 0));
        InternalFactHandle fh11 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh12 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh13 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh1, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh2, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh3, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh4, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh5, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh6, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh7, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh8, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh9, null));
        TupleIndexHashTable hashTable = (TupleIndexHashTable)betaMemory.getRightTupleMemory();
        TupleList rightTupleList = new TupleList();
        rightTupleList.add((Tuple)new RightTupleImpl(fh10, null));
        hashTable.getTable()[0] = rightTupleList;
        rightTupleList = new TupleList();
        rightTupleList.add((Tuple)new RightTupleImpl(fh11, null));
        rightTupleList.add((Tuple)new RightTupleImpl(fh12, null));
        rightTupleList.add((Tuple)new RightTupleImpl(fh13, null));
        ((TupleList)hashTable.getTable()[0]).setNext(rightTupleList);
        List tableIndexList = this.createTableIndexListForAssertion(hashTable);
        Assertions.assertThat((int)tableIndexList.size()).isEqualTo(5);
        if (this.useLambdaConstraint) {
            this.assertTableIndex(tableIndexList, 0, 0, 3);
            this.assertTableIndex(tableIndexList, 1, 49, 3);
            this.assertTableIndex(tableIndexList, 2, 51, 3);
            this.assertTableIndex(tableIndexList, 3, 60, 2);
            this.assertTableIndex(tableIndexList, 4, 61, 2);
        } else {
            this.assertTableIndex(tableIndexList, 0, 0, 3);
            this.assertTableIndex(tableIndexList, 1, 102, 2);
            this.assertTableIndex(tableIndexList, 2, 103, 2);
            this.assertTableIndex(tableIndexList, 3, 115, 3);
            this.assertTableIndex(tableIndexList, 4, 117, 3);
        }
        ArrayList<RightTuple> resultList = new ArrayList<RightTuple>();
        Iterator it = betaMemory.getRightTupleMemory().iterator();
        RightTuple rightTuple = (RightTuple)it.next();
        while (rightTuple != null) {
            resultList.add(rightTuple);
            rightTuple = (RightTuple)it.next();
        }
        Assertions.assertThat((int)resultList.size()).isEqualTo(13);
    }

    @Test
    public void testLastBucketInTheTable() {
        Entry[] entries = new Entry[10];
        entries[0] = (Entry)Mockito.mock(TupleList.class);
        entries[5] = (Entry)Mockito.mock(TupleList.class);
        entries[9] = (Entry)Mockito.mock(TupleList.class);
        RightTuple[] tuples = new RightTuple[]{(RightTuple)Mockito.mock(RightTuple.class), (RightTuple)Mockito.mock(RightTuple.class), (RightTuple)Mockito.mock(RightTuple.class)};
        Mockito.when((Object)entries[0].getNext()).thenReturn(null);
        Mockito.when((Object)((TupleList)entries[0]).getFirst()).thenReturn((Object)tuples[0]);
        Mockito.when((Object)entries[5].getNext()).thenReturn(null);
        Mockito.when((Object)((TupleList)entries[5]).getFirst()).thenReturn((Object)tuples[1]);
        Mockito.when((Object)entries[9].getNext()).thenReturn(null);
        Mockito.when((Object)((TupleList)entries[9]).getFirst()).thenReturn((Object)tuples[2]);
        AbstractHashTable table = (AbstractHashTable)Mockito.mock(AbstractHashTable.class);
        Mockito.when((Object)table.getTable()).thenReturn((Object)entries);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iterator = new TupleIndexHashTable.FieldIndexHashTableFullIterator(table);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[0]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[1]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[2]);
        Assertions.assertThat((Object)iterator.next()).isNull();
    }
}

