/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.EnabledBuilder;
import org.drools.compiler.rule.builder.EntryPointBuilder;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.GroupElementBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.PredicateBuilder;
import org.drools.compiler.rule.builder.QueryBuilder;
import org.drools.compiler.rule.builder.ReturnValueBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleClassBuilder;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.SalienceBuilder;
import org.drools.core.addon.TypeResolver;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.mvel.java.JavaForMvelDialectConfiguration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.KBuilderSeverityOption;
import org.kie.memorycompiler.JavaConfiguration;

public class PackageBuilderConfigurationTest {
    private static String droolsDialectJavaCompilerOrig;
    private static String droolsDialectDefaultOrig;

    @BeforeClass
    public static void backupPropertyValues() {
        droolsDialectJavaCompilerOrig = System.getProperty("drools.dialect.java.compiler");
        droolsDialectDefaultOrig = System.getProperty("drools.dialect.default");
    }

    @AfterClass
    public static void restorePropertyValues() {
        if (droolsDialectJavaCompilerOrig != null) {
            System.setProperty("drools.dialect.java.compiler", droolsDialectJavaCompilerOrig);
        }
        if (droolsDialectDefaultOrig != null) {
            System.setProperty("drools.dialect.default", droolsDialectDefaultOrig);
        }
    }

    @Before
    public void setUp() throws Exception {
        System.getProperties().remove("drools.dialect.java.compiler");
        System.getProperties().remove("drools.dialect.default");
    }

    @After
    public void tearDown() throws Exception {
        System.getProperties().remove("drools.dialect.java.compiler");
        System.getProperties().remove("drools.dialect.default");
        System.getProperties().remove("drools.kbuilder.severity.duplicateFunction");
    }

    @Test
    public void testProgrammaticProperties() {
        KnowledgeBuilderConfigurationImpl cfg = new KnowledgeBuilderConfigurationImpl();
        Assertions.assertThat((boolean)cfg.getDefaultDialect().equals("java")).isTrue();
        Properties properties = new Properties();
        properties.setProperty("drools.dialect.default", "mvel");
        KnowledgeBuilderConfigurationImpl cfg1 = new KnowledgeBuilderConfigurationImpl(properties);
        Assertions.assertThat((String)cfg1.getDefaultDialect()).isEqualTo("mvel");
        KnowledgeBuilderConfigurationImpl cfg2 = new KnowledgeBuilderConfigurationImpl(properties);
        Assertions.assertThat(cfg2.getDefaultDialect().getClass()).isEqualTo(cfg1.getDefaultDialect().getClass());
    }

    @Test
    public void testProgramaticProperties2() {
        JavaForMvelDialectConfiguration javaConf = new JavaForMvelDialectConfiguration();
        javaConf.init(new KnowledgeBuilderConfigurationImpl());
        javaConf.setCompiler(JavaConfiguration.CompilerType.ECLIPSE);
        KnowledgeBuilderConfigurationImpl cfg = new KnowledgeBuilderConfigurationImpl();
        cfg.setDialectConfiguration("java", (DialectConfiguration)javaConf);
        JavaForMvelDialectConfiguration javaConf2 = (JavaForMvelDialectConfiguration)cfg.getDialectConfiguration("java");
        Assertions.assertThat((Object)javaConf2).isSameAs((Object)javaConf);
        Assertions.assertThat((Comparable)javaConf2.getCompiler()).isEqualTo((Object)JavaConfiguration.CompilerType.ECLIPSE);
    }

    @Test
    public void testResultSeverity() {
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "ERROR");
        KnowledgeBuilderConfigurationImpl cfg = new KnowledgeBuilderConfigurationImpl();
        Assertions.assertThat((int)1).isEqualTo(cfg.getOptionKeys(KBuilderSeverityOption.class).size());
        Assertions.assertThat((Comparable)ResultSeverity.ERROR).isEqualTo((Object)((KBuilderSeverityOption)cfg.getOption(KBuilderSeverityOption.class, "duplicateFunction")).getSeverity());
    }

    @Test
    public void testResultSeverityNonExistingValueDefaultToInfo() {
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "FOO");
        KnowledgeBuilderConfigurationImpl cfg = new KnowledgeBuilderConfigurationImpl();
        Assertions.assertThat((int)1).isEqualTo(cfg.getOptionKeys(KBuilderSeverityOption.class).size());
        Assertions.assertThat((Comparable)ResultSeverity.INFO).isEqualTo((Object)((KBuilderSeverityOption)cfg.getOption(KBuilderSeverityOption.class, "duplicateFunction")).getSeverity());
    }

    @Test
    public void testMockDialect() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.pkg1");
        KnowledgeBuilderConfigurationImpl cfg1 = new KnowledgeBuilderConfigurationImpl();
        MockDialectConfiguration mockConf = new MockDialectConfiguration();
        cfg1.addDialect("mock", (DialectConfiguration)mockConf);
        cfg1.setDefaultDialect("mock");
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg, cfg1);
        PackageRegistry pkgRegistry = builder.getPackageRegistry(pkg.getName());
        DialectCompiletimeRegistry dialectRegistry = pkgRegistry.getDialectCompiletimeRegistry();
        MockDialect mockDialect2 = (MockDialect)dialectRegistry.getDialect(cfg1.getDefaultDialect());
        Assertions.assertThat((Object)mockDialect2.getPkg()).isSameAs((Object)pkg);
        Assertions.assertThat((Object)mockDialect2.getRuleDescr()).isNull();
        RuleDescr ruleDescr = new RuleDescr("test rule");
        ruleDescr.addAttribute(new AttributeDescr("dialect", "mock"));
        ruleDescr.setLhs(new AndDescr());
        EvalDescr evalDescr = new EvalDescr();
        ruleDescr.getLhs().addDescr((BaseDescr)evalDescr);
        PackageDescr pkgDescr = new PackageDescr("org.pkg1");
        pkgDescr.addImport(new ImportDescr("java.util.HashMap"));
        FunctionImportDescr functionImportDescr = new FunctionImportDescr();
        functionImportDescr.setTarget("java.lang.System.currentTimeMillis");
        pkgDescr.addFunctionImport(functionImportDescr);
        pkgDescr.addRule(ruleDescr);
        builder.addPackage(pkgDescr);
        Assertions.assertThat((Object)mockDialect2.getRuleDescr()).isSameAs((Object)ruleDescr);
        Assertions.assertThat((boolean)mockDialect2.getImport().contains("java.util.HashMap")).isTrue();
        Assertions.assertThat((boolean)mockDialect2.getStaticImport().contains("java.lang.System.currentTimeMillis")).isTrue();
        Assertions.assertThat((Object)evalDescr.getContent()).isEqualTo((Object)"eval was built");
        Assertions.assertThat((Object)ruleDescr.getConsequence()).isEqualTo((Object)"consequence was built");
        Assertions.assertThat((boolean)mockDialect2.isCompileAll()).isTrue();
        Assertions.assertThat((Object)pkg.getRule("test rule")).isNotNull();
        Assertions.assertThat((boolean)builder.hasErrors()).isFalse();
    }

    public static class MockConsequenceBuilder
    implements ConsequenceBuilder {
        public void build(RuleBuildContext context, String name) {
            context.getRuleDescr().setConsequence((Object)"consequence was built");
        }
    }

    public static class MockEvalBuilder
    implements RuleConditionBuilder {
        public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
            EvalDescr evalDescr = (EvalDescr)descr;
            evalDescr.setContent((Object)"eval was built");
            return null;
        }

        public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
            return null;
        }
    }

    public static class MockDialect
    implements Dialect {
        private InternalKnowledgePackage pkg;
        private RuleDescr ruleDescr;
        private RuleImpl rule;
        private List<String> imports = new ArrayList<String>();
        private boolean compileAll = false;

        public MockDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
            this.pkg = pkg;
        }

        public void init(RuleDescr ruleDescr) {
            this.ruleDescr = ruleDescr;
        }

        public InternalKnowledgePackage getPkg() {
            return this.pkg;
        }

        public RuleDescr getRuleDescr() {
            return this.ruleDescr;
        }

        public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        }

        public void addImport(ImportDescr importDescr) {
            this.imports.add(importDescr.getTarget());
        }

        public List getImport() {
            return this.imports;
        }

        public void addStaticImport(ImportDescr importDescr) {
            this.imports.add(importDescr.getTarget());
        }

        public List getStaticImport() {
            return this.imports;
        }

        public void addRule(RuleBuildContext context) {
            this.rule = context.getRule();
        }

        public RuleImpl getRule() {
            return this.rule;
        }

        public void compileAll() {
            this.compileAll = true;
        }

        public boolean isCompileAll() {
            return this.compileAll;
        }

        public AccumulateBuilder getAccumulateBuilder() {
            return null;
        }

        public RuleConditionBuilder getBuilder(Class clazz) {
            if (clazz == EvalDescr.class) {
                return this.getEvalBuilder();
            }
            if (clazz == AndDescr.class) {
                return new GroupElementBuilder();
            }
            throw new RuntimeException("clazz " + clazz + " is not yet configured ");
        }

        public Map getBuilders() {
            return null;
        }

        public ConsequenceBuilder getConsequenceBuilder() {
            return new MockConsequenceBuilder();
        }

        public RuleConditionBuilder getEvalBuilder() {
            return new MockEvalBuilder();
        }

        public String getExpressionDialectName() {
            return null;
        }

        public FromBuilder getFromBuilder() {
            return null;
        }

        public PatternBuilder getPatternBuilder() {
            return null;
        }

        public PredicateBuilder getPredicateBuilder() {
            return null;
        }

        public QueryBuilder getQueryBuilder() {
            return null;
        }

        public List<KnowledgeBuilderResult> getResults() {
            return null;
        }

        public void clearResults() {
        }

        public ReturnValueBuilder getReturnValueBuilder() {
            return null;
        }

        public RuleClassBuilder getRuleClassBuilder() {
            return null;
        }

        public SalienceBuilder getSalienceBuilder() {
            return null;
        }

        public TypeResolver getTypeResolver() {
            return null;
        }

        public String getId() {
            return "mock";
        }

        public void init(ProcessDescr processDescr) {
        }

        public EntryPointBuilder getEntryPointBuilder() {
            return null;
        }

        public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        }

        public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        }

        public EnabledBuilder getEnabledBuilder() {
            return null;
        }

        public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
        }

        public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
            return null;
        }

        public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes) {
            return null;
        }

        public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
            return null;
        }

        public PackageRegistry getPackageRegistry() {
            return null;
        }
    }

    public static class MockDialectConfiguration
    implements DialectConfiguration {
        private KnowledgeBuilderConfigurationImpl conf;

        public Dialect newDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
            return new MockDialect(rootClassLoader, pkgConf, pkgRegistry, pkg);
        }

        public KnowledgeBuilderConfigurationImpl getPackageBuilderConfiguration() {
            return this.conf;
        }

        public void init(KnowledgeBuilderConfigurationImpl configuration) {
            this.conf = configuration;
        }
    }
}

