/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler.xml.changeset;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.core.io.impl.UrlResource;
import org.drools.core.xml.XmlChangeSetReader;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.ChangeSet;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.io.ResourceFactory;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class ChangeSetTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ChangeSetTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testXmlParser() throws SAXException, IOException {
        KnowledgeBuilderConfigurationImpl conf = new KnowledgeBuilderConfigurationImpl();
        XmlChangeSetReader xmlReader = new XmlChangeSetReader(conf.getSemanticModules());
        xmlReader.setClassLoader(ChangeSetTest.class.getClassLoader(), ChangeSetTest.class);
        String str = "";
        str = str + "<change-set ";
        str = str + "xmlns='http://drools.org/drools-5.0/change-set' ";
        str = str + "xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' ";
        str = str + "xs:schemaLocation='http://drools.org/drools-5.0/change-set change-set-1.0.0.xsd' >";
        str = str + "    <add> ";
        str = str + "        <resource source='http://www.domain.com/test.drl' type='DRL' />";
        str = str + "        <resource source='http://www.domain.com/test.xls' type='DTABLE' >";
        str = str + "            <decisiontable-conf worksheet-name='sheet10' input-type='XLS' />";
        str = str + "        </resource>";
        str = str + "    </add> ";
        str = str + "</change-set>";
        StringReader reader = new StringReader(str);
        ChangeSet changeSet = xmlReader.read((Reader)reader);
        Assertions.assertThat((int)changeSet.getResourcesAdded().size()).isEqualTo(2);
        UrlResource resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(0);
        Assertions.assertThat((String)resource.getURL().toString()).isEqualTo("http://www.domain.com/test.drl");
        Assertions.assertThat((Object)resource.getResourceType()).isEqualTo((Object)ResourceType.DRL);
        resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(1);
        Assertions.assertThat((String)resource.getURL().toString()).isEqualTo("http://www.domain.com/test.xls");
        Assertions.assertThat((Object)resource.getResourceType()).isEqualTo((Object)ResourceType.DTABLE);
        DecisionTableConfiguration dtConf = (DecisionTableConfiguration)resource.getConfiguration();
        Assertions.assertThat((Comparable)dtConf.getInputType()).isEqualTo((Object)DecisionTableInputType.XLS);
    }

    @Test
    public void testIntegregation() {
        Resource changeSet = ResourceFactory.newClassPathResource((String)"changeset1Test.xml", this.getClass());
        changeSet.setResourceType(ResourceType.CHANGE_SET);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{changeSet});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("rule1", "rule2"))).isTrue();
    }

    @Test(timeout=10000L)
    public void testCustomClassLoader() throws Exception {
        String absolutePath = new File("file").getAbsolutePath();
        URL url = ChangeSetTest.class.getResource(ChangeSetTest.class.getSimpleName() + ".class");
        File file = new File(url.toURI());
        File jar = null;
        while (!(jar = new File(file = file.getParentFile(), "/src/test/resources/org/drools/mvel/compiler/compiler/xml/changeset/changeset.jar")).exists()) {
        }
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{jar.toURI().toURL()}, this.getClass().getClassLoader());
        Resource changeSet = ResourceFactory.newClassPathResource((String)"changeset1.xml", (ClassLoader)classLoader);
        changeSet.setResourceType(ResourceType.CHANGE_SET);
        KieModuleModel kieModuleModel = KieUtil.createKieModuleModel((Boolean)this.kieBaseTestConfiguration.useAlphaNetworkCompiler());
        KieFileSystem kieFileSystem = KieUtil.getKieFileSystemWithKieModule((KieModuleModel)kieModuleModel, (ReleaseId)KieServices.get().getRepository().getDefaultReleaseId(), (Resource[])new Resource[]{changeSet});
        KieBuilder kbuilder = KieServices.Factory.get().newKieBuilder(kieFileSystem, (ClassLoader)classLoader);
        if (this.kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            kbuilder.buildAll((Class)this.kieBaseTestConfiguration.getExecutableModelProjectClass().get());
        } else {
            kbuilder.buildAll(DrlProject.class);
        }
        List errors = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }
}

