/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler.xml.rules;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.xml.XmlPackageReader;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.MVELExprDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.util.StringUtils;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.DrlDumper;
import org.junit.Test;

public class XmlPackageReaderTest
extends CommonTestMethodBase {
    @Test
    public void testParseFrom() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseFrom.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        PatternDescr patterndescr = (PatternDescr)obj.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)patterndescr.getSource();
        MVELExprDescr accessordescriptor = (MVELExprDescr)from.getDataSource();
        Assertions.assertThat((String)accessordescriptor.getExpression()).isEqualTo("cheesery.getCheeses(i+4)");
        Assertions.assertThat((String)"Cheese").isEqualTo(patterndescr.getObjectType());
        Assertions.assertThat((String)"cheese").isEqualTo(patterndescr.getIdentifier());
    }

    @Test
    public void testAccumulate() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        Assertions.assertThat((boolean)(patternobj instanceof PatternDescr)).isTrue();
        PatternDescr patterncheese = (PatternDescr)patternobj;
        Assertions.assertThat((String)"cheese").isEqualTo(patterncheese.getIdentifier());
        Assertions.assertThat((String)"Cheese").isEqualTo(patterncheese.getObjectType());
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        Assertions.assertThat((String)accumulatedescr.getActionCode()).isEqualTo("total += $cheese.getPrice();");
        Assertions.assertThat((String)accumulatedescr.getInitCode()).isEqualTo("int total = 0;");
        Assertions.assertThat((String)accumulatedescr.getResultCode()).isEqualTo("new Integer( total ) );");
        patternobj = obj.getLhs().getDescrs().get(1);
        Assertions.assertThat((boolean)(patternobj instanceof PatternDescr)).isTrue();
        PatternDescr patternmax = (PatternDescr)patternobj;
        Assertions.assertThat((String)"max").isEqualTo(patternmax.getIdentifier());
        Assertions.assertThat((String)"Number").isEqualTo(patternmax.getObjectType());
        accumulatedescr = (AccumulateDescr)patternmax.getSource();
        Assertions.assertThat((boolean)accumulatedescr.isExternalFunction()).isTrue();
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)accumulatedescr.getFunctions().get(0)).getFunction()).isEqualTo("max");
        Assertions.assertThat((String)accumulatedescr.getInitCode()).isNull();
        Assertions.assertThat((String)accumulatedescr.getActionCode()).isNull();
        Assertions.assertThat((String)accumulatedescr.getResultCode()).isNull();
        Assertions.assertThat((String)accumulatedescr.getReverseCode()).isNull();
    }

    @Test
    public void testAccumulateMultiPattern() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(1);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        Assertions.assertThat((boolean)(patternobj instanceof PatternDescr)).isTrue();
        PatternDescr patterncheese = (PatternDescr)patternobj;
        Assertions.assertThat((String)"cheese").isEqualTo(patterncheese.getIdentifier());
        Assertions.assertThat((String)"Cheese").isEqualTo(patterncheese.getObjectType());
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        Assertions.assertThat((String)accumulatedescr.getActionCode()).isEqualTo("total += $cheese.getPrice();");
        Assertions.assertThat((String)accumulatedescr.getInitCode()).isEqualTo("int total = 0;");
        Assertions.assertThat((String)accumulatedescr.getResultCode()).isEqualTo("new Integer( total ) );");
        AndDescr anddescr = (AndDescr)accumulatedescr.getInput();
        List descrlist = anddescr.getDescrs();
        PatternDescr[] listpattern = descrlist.toArray(new PatternDescr[descrlist.size()]);
        Assertions.assertThat((String)"Milk").isEqualTo(listpattern[0].getObjectType());
        Assertions.assertThat((String)"Cup").isEqualTo(listpattern[1].getObjectType());
    }

    @Test
    public void testParseForall() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseForall.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        ForallDescr forall = (ForallDescr)obj.getLhs().getDescrs().get(0);
        List forallPaterns = forall.getDescrs();
        PatternDescr pattarnState = (PatternDescr)forallPaterns.get(0);
        PatternDescr personState = (PatternDescr)forallPaterns.get(1);
        PatternDescr cheeseState = (PatternDescr)forallPaterns.get(2);
        Assertions.assertThat((String)"State").isEqualTo(pattarnState.getObjectType());
        Assertions.assertThat((String)"Person").isEqualTo(personState.getObjectType());
        Assertions.assertThat((String)"Cheese").isEqualTo(cheeseState.getObjectType());
    }

    @Test
    public void testParseExists() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseExists.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object existdescr = obj.getLhs().getDescrs().get(0);
        Assertions.assertThat((boolean)(existdescr instanceof ExistsDescr)).isTrue();
        Object patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        Assertions.assertThat((boolean)(patternDescriptor instanceof PatternDescr)).isTrue();
        Assertions.assertThat((String)"Person").isEqualTo(((PatternDescr)patternDescriptor).getObjectType());
        Object notDescr = obj.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)NotDescr.class.getName()).isEqualTo(notDescr.getClass().getName());
        existdescr = ((NotDescr)notDescr).getDescrs().get(0);
        patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        Assertions.assertThat((boolean)(patternDescriptor instanceof PatternDescr)).isTrue();
        Assertions.assertThat((String)"Cheese").isEqualTo(((PatternDescr)patternDescriptor).getObjectType());
    }

    @Test
    public void testParseCollect() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseCollect.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseCollect.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParsePackageName() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParsePackageName.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("com.sample");
    }

    @Test
    public void testParseImport() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseImport.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("com.sample");
        List imports = packageDescr.getImports();
        Assertions.assertThat((int)imports.size()).isEqualTo(2);
        Assertions.assertThat((String)((ImportDescr)imports.get(0)).getTarget()).isEqualTo("java.util.HashMap");
        Assertions.assertThat((String)((ImportDescr)imports.get(1)).getTarget()).isEqualTo("org.drools.mvel.compiler.*");
        List functionImport = packageDescr.getFunctionImports();
        Assertions.assertThat((String)((FunctionImportDescr)functionImport.get(0)).getTarget()).isEqualTo("org.drools.function");
    }

    @Test
    public void testParseGlobal() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseGlobal.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("com.sample");
        List imports = packageDescr.getImports();
        Assertions.assertThat((int)imports.size()).isEqualTo(2);
        Assertions.assertThat((String)((ImportDescr)imports.get(0)).getTarget()).isEqualTo("java.util.HashMap");
        Assertions.assertThat((String)((ImportDescr)imports.get(1)).getTarget()).isEqualTo("org.drools.mvel.compiler.*");
        List globals = packageDescr.getGlobals();
        Assertions.assertThat((int)globals.size()).isEqualTo(2);
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assertions.assertThat((String)x.getType()).isEqualTo("com.sample.X");
        Assertions.assertThat((String)x.getIdentifier()).isEqualTo("x");
        Assertions.assertThat((String)yada.getType()).isEqualTo("com.sample.Yada");
        Assertions.assertThat((String)yada.getIdentifier()).isEqualTo("yada");
    }

    @Test
    public void testParseFunction() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseFunction.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("com.sample");
        List imports = packageDescr.getImports();
        Assertions.assertThat((int)imports.size()).isEqualTo(2);
        Assertions.assertThat((String)((ImportDescr)imports.get(0)).getTarget()).isEqualTo("java.util.HashMap");
        Assertions.assertThat((String)((ImportDescr)imports.get(1)).getTarget()).isEqualTo("org.drools.mvel.compiler.*");
        List globals = packageDescr.getGlobals();
        Assertions.assertThat((int)globals.size()).isEqualTo(2);
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assertions.assertThat((String)x.getType()).isEqualTo("com.sample.X");
        Assertions.assertThat((String)x.getIdentifier()).isEqualTo("x");
        Assertions.assertThat((String)yada.getType()).isEqualTo("com.sample.Yada");
        Assertions.assertThat((String)yada.getIdentifier()).isEqualTo("yada");
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        Assertions.assertThat(names.get(0)).isEqualTo((Object)"foo");
        Assertions.assertThat(names.get(1)).isEqualTo((Object)"bada");
        List types = functionDescr.getParameterTypes();
        Assertions.assertThat(types.get(0)).isEqualTo((Object)"Bar");
        Assertions.assertThat(types.get(1)).isEqualTo((Object)"Bing");
        Assertions.assertThat((String)functionDescr.getText().trim()).isEqualTo("System.out.println(\"hello world\");");
    }

    @Test
    public void testParseRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRule.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRule.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        System.out.println(expectedWithoutHeader);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParseSimpleRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_SimpleRule1.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("com.sample");
        List imports = packageDescr.getImports();
        Assertions.assertThat((int)imports.size()).isEqualTo(2);
        Assertions.assertThat((String)((ImportDescr)imports.get(0)).getTarget()).isEqualTo("java.util.List");
        Assertions.assertThat((String)((ImportDescr)imports.get(1)).getTarget()).isEqualTo("org.drools.mvel.compiler.Person");
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("simple_rule1");
        AndDescr lhs = ruleDescr.getLhs();
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Person");
        ExprConstraintDescr expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assertions.assertThat((String)expr.getExpression()).isEqualTo("name == \"darth\"");
        ruleDescr = (RuleDescr)packageDescr.getRules().get(1);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("simple_rule2");
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Person");
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assertions.assertThat((String)expr.getExpression()).isEqualTo("age == 35 || == -3.5");
        ruleDescr = (RuleDescr)packageDescr.getRules().get(2);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("simple_rule3");
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Person");
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assertions.assertThat((String)expr.getExpression()).isEqualTo("age == 35 || (!= 7.0 && != -70)");
        ruleDescr = (RuleDescr)packageDescr.getRules().get(3);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("simple_rule3");
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Person");
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assertions.assertThat((String)expr.getExpression()).isEqualTo("name == $s");
        ruleDescr = (RuleDescr)packageDescr.getRules().get(4);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("simple_rule4");
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Person");
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assertions.assertThat((String)expr.getExpression()).isEqualTo("(name == $s) || (age == 35 || (!= 7.0 && != -70))");
        ruleDescr = (RuleDescr)packageDescr.getRules().get(5);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("simple_rule5");
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Person");
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assertions.assertThat((String)expr.getExpression()).isEqualTo("(name == $s) || ((age != 34) && (age != 37) && (name != \"yoda\"))");
    }

    @Test
    public void testParseLhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseLhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseLhs.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParseRhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("com.sample");
        List imports = packageDescr.getImports();
        Assertions.assertThat((int)imports.size()).isEqualTo(2);
        Assertions.assertThat((String)((ImportDescr)imports.get(0)).getTarget()).isEqualTo("java.util.HashMap");
        Assertions.assertThat((String)((ImportDescr)imports.get(1)).getTarget()).isEqualTo("org.drools.mvel.compiler.*");
        List globals = packageDescr.getGlobals();
        Assertions.assertThat((int)globals.size()).isEqualTo(2);
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assertions.assertThat((String)x.getType()).isEqualTo("com.sample.X");
        Assertions.assertThat((String)x.getIdentifier()).isEqualTo("x");
        Assertions.assertThat((String)yada.getType()).isEqualTo("com.sample.Yada");
        Assertions.assertThat((String)yada.getIdentifier()).isEqualTo("yada");
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        Assertions.assertThat(names.get(0)).isEqualTo((Object)"foo");
        Assertions.assertThat(names.get(1)).isEqualTo((Object)"bada");
        List types = functionDescr.getParameterTypes();
        Assertions.assertThat(types.get(0)).isEqualTo((Object)"Bar");
        Assertions.assertThat(types.get(1)).isEqualTo((Object)"Bing");
        Assertions.assertThat((String)functionDescr.getText().trim()).isEqualTo("System.out.println(\"hello world\");");
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("my rule");
        String consequence = (String)ruleDescr.getConsequence();
        Assertions.assertThat((String)consequence).isNotNull();
        Assertions.assertThat((String)consequence.trim()).isEqualTo("System.out.println( \"hello\" );");
    }

    @Test
    public void testParseQuery() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseQuery.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("com.sample");
        List imports = packageDescr.getImports();
        Assertions.assertThat((int)imports.size()).isEqualTo(2);
        Assertions.assertThat((String)((ImportDescr)imports.get(0)).getTarget()).isEqualTo("java.util.HashMap");
        Assertions.assertThat((String)((ImportDescr)imports.get(1)).getTarget()).isEqualTo("org.drools.mvel.compiler.*");
        List globals = packageDescr.getGlobals();
        Assertions.assertThat((int)globals.size()).isEqualTo(2);
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assertions.assertThat((String)x.getType()).isEqualTo("com.sample.X");
        Assertions.assertThat((String)x.getIdentifier()).isEqualTo("x");
        Assertions.assertThat((String)yada.getType()).isEqualTo("com.sample.Yada");
        Assertions.assertThat((String)yada.getIdentifier()).isEqualTo("yada");
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        Assertions.assertThat(names.get(0)).isEqualTo((Object)"foo");
        Assertions.assertThat(names.get(1)).isEqualTo((Object)"bada");
        List types = functionDescr.getParameterTypes();
        Assertions.assertThat(types.get(0)).isEqualTo((Object)"Bar");
        Assertions.assertThat(types.get(1)).isEqualTo((Object)"Bing");
        Assertions.assertThat((String)functionDescr.getText().trim()).isEqualTo("System.out.println(\"hello world\");");
        QueryDescr queryDescr = (QueryDescr)packageDescr.getRules().get(0);
        Assertions.assertThat((String)queryDescr.getName()).isEqualTo("my query");
        AndDescr lhs = queryDescr.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(1);
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Foo");
    }

    private XmlPackageReader getXmReader() {
        KnowledgeBuilderConfigurationImpl conf = new KnowledgeBuilderConfigurationImpl();
        XmlPackageReader xmlReader = new XmlPackageReader(conf.getSemanticModules());
        xmlReader.getParser().setClassLoader(XmlPackageReaderTest.class.getClassLoader());
        return xmlReader;
    }

    private String removeLicenseHeader(String content) {
        String[] lines = content.trim().split("\n");
        StringBuilder result = new StringBuilder();
        if (lines.length > 1 && lines[0].startsWith("/*")) {
            boolean inHeader = true;
            for (String line : lines) {
                if (line.trim().startsWith("package")) {
                    inHeader = false;
                }
                if (inHeader) continue;
                result.append(line);
                result.append("\n");
            }
            return result.toString();
        }
        return content;
    }
}

