/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import java.util.LinkedList;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DRLFactory;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.DRLParser;
import org.drools.compiler.lang.DroolsEditorType;
import org.drools.compiler.lang.DroolsSentence;
import org.drools.compiler.lang.DroolsToken;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRLContextTest {
    @Before
    public void setUp() throws Exception {
        new EvaluatorRegistry();
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_OPERATORS_AND_COMPLEMENT1() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property memberOf collection ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_OPERATORS_AND_COMPLEMENT2() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property not memberOf collection";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_COMPOSITE_OPERATOR1() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property in ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION1() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule \n\twhen \n\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION2() {
        String input = "rule MyRule \n\twhen \n\t\tClass( condition == true ) \n\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION3() {
        String input = "rule MyRule \n\twhen \n\t\tclass: Class( condition == true, condition2 == null ) \n\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION4() {
        String input = "rule MyRule \n\twhen \n\t\tCl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION5() {
        String input = "rule MyRule \n\twhen \n\t\tClass( condition == true ) \n\t\tCl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION6() {
        String input = "rule MyRule \n\twhen \n\t\tclass: Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION7() {
        String input = "rule MyRule \n\twhen \n\t\tclass:Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START1() {
        String input = "rule MyRule \n\twhen \n\t\tClass (";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( na";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START3() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name.subProperty['test'].subsu";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START4() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( condition == true, ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START5() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( condition == true, na";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START6() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( \n\t\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START7() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( condition == true, \n\t\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START8() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( c: condition, \n\t\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DroolsToken token = (DroolsToken)((DroolsSentence)parser.getEditorInterface().get(0)).getContent().get(11);
        Assertions.assertThat((String)token.getText()).isEqualTo("c");
        Assertions.assertThat((Comparable)token.getEditorType()).isEqualTo((Object)DroolsEditorType.IDENTIFIER_VARIABLE);
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START9a() {
        String input = "rule MyRule \n   when \n       Class ( name:";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START9b() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name: ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START10() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name:";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR1() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR2() {
        String input = "rule MyRule \n\twhen \n\t\tClass(property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR3() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name : property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR4() {
        String input = "rule MyRule \n\twhen \n\t\tClass (name:property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR5() {
        String input = "rule MyRule \n\twhen \n\t\tClass (name:property   ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR6() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name1 : property1, name : property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR7() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name1 : property1 == \"value\", name : property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR8() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name1 : property1 == \"value\",property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR9() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name1 : property1, \n\t\t\tname : property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT1() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property == ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property== ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT3() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name : property <= ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT4() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name:property != ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT5() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name1 : property1, property2 == ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT6() {
        String input = "rule MyRule \n\twhen \n\t\tClass (name:property== ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT7a() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property == otherPropertyN";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT7b() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property == otherPropertyN ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT8() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property == \"someth";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT9a() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property contains ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT9b() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property not contains ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT10() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property excludes ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT11() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property matches \"prop";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT12() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property in ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END1() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property in ('1', '2') ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START11() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property in ('1', '2'), ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    @Ignore
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT13() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property not in ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property not in ('1', '2') ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START12() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property not in ('1', '2'), ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT14() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property memberOf ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    @Ignore
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END3() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property memberOf collection ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START13() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property memberOf collection, ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT15() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property not memberOf ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END4() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property not memberOf collection ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START14() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property not memberOf collection, ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedList list = ((DroolsSentence)parser.getEditorInterface().get(0)).getContent();
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS1() {
        String input = "rule MyRule \n\twhen \n\t\texists ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS2() {
        String input = "rule MyRule \n\twhen \n\t\texists ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS3() {
        String input = "rule MyRule \n\twhen \n\t\texists(";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS4() {
        String input = "rule MyRule \n\twhen \n\t\texists Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS5() {
        String input = "rule MyRule \n\twhen \n\t\texists ( Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS6() {
        String input = "rule MyRule \n\twhen \n\t\texists ( name : Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDeterminationINSIDE_CONDITION_START16() {
        String input = "rule MyRule \n\twhen \n\t\texists Class (";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION() {
        String input = "rule MyRule \n\twhen \n\t\texists Class ( ) \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_NOT1() {
        String input = "rule MyRule \n\twhen \n\t\tnot ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(4);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_NOT2() {
        String input = "rule MyRule \n\twhen \n\t\tnot Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(4);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS7() {
        String input = "rule MyRule \n\twhen \n\t\tnot ( exists ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS8() {
        String input = "rule MyRule \n\twhen \n\t\tnot ( exists Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START21() {
        String input = "rule MyRule \n\twhen \n\t\tnot Class (";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START22() {
        String input = "rule MyRule \n\twhen \n\t\tnot ( exists Class (";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START23() {
        String input = "rule MyRule \n\twhen \n\t\tnot ( exists name : Class (";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION9() {
        String input = "rule MyRule \n\twhen \n\t\tnot Class () \n\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR1() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and  ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR3() {
        String input = "rule MyRule \n\twhen \n\t\tClass () and   ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR4() {
        String input = "rule MyRule \n\twhen \n\t\tname : Class ( name: property ) and ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
        DroolsToken token = (DroolsToken)((DroolsSentence)parser.getEditorInterface().get(0)).getContent().get(12);
        Assertions.assertThat((Comparable)token.getEditorType()).isEqualTo((Object)DroolsEditorType.IDENTIFIER_VARIABLE);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR5() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name: property ) \n       and ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR6() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR7() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and name : Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR8() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and name : Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION31() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and Class ( ) \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION32() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and not Class ( ) \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION33() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and exists Class ( ) \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START20() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and Class ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR21() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and Class ( name ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR22() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and Class ( name == ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_NOT() {
        String input = "rule MyRule \n\twhen \n\t\texists Class ( ) and not ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(4);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS() {
        String input = "rule MyRule \n\twhen \n\t\texists Class ( ) and exists ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION30() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) and not Class ( ) \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR21() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR22() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR23() {
        String input = "rule MyRule \n\twhen \n\t\tClass () or   ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR24() {
        String input = "rule MyRule \n\twhen \n\t\tname : Class ( name: property ) or ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR25() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name: property ) \n       or ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR26() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR27() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or name : Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_AND_OR28() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or name : Cl";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION40() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or Class ( ) \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START40() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or Class ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or Class ( name ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT30() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( ) or Class ( name == ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_EGIN_OF_CONDITION_NOT() {
        String input = "rule MyRule \n\twhen \n\t\texists Class ( ) or not ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(4);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION_EXISTS40() {
        String input = "rule MyRule \n\twhen \n\t\texists Class ( ) or exists ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL1() {
        String input = "rule MyRule \n\twhen \n\t\teval ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL2() {
        String input = "rule MyRule \n\twhen \n\t\teval(";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL3() {
        String input = "rule MyRule \n\twhen \n\t\teval( myCla";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL4() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getMetho";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL5() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getMethod(";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL6() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getMethod().get";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL7() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getMethod(\"someStringWith)))\").get";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL8() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getMethod(\"someStringWith(((\").get";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL9() {
        String input = "rule MyRule \n\twhen \n\t\teval( true )";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION50() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getProperty(name).isTrue() )";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION51() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getProperty(\"someStringWith(((\").isTrue() )";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_EVAL10() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getProperty((((String) s) )";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(200);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION52() {
        String input = "rule MyRule \n\twhen \n\t\teval( param.getProperty((((String) s))))";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION53() {
        String input = "rule MyRule \n\twhen \n\t\teval( true ) \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR12() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 && ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR13() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name : property1, property2 > 0 && ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR14() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property1 < 20, property2 > 0 && ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT20() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 && < ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END6() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 && < 10 ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START41() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 && < 10, ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR60() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 || ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR61() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 && \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR62() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( name : property1, property2 > 0 || ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR63() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property1 < 20, property2 > 0 || ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END10() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END11() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END12() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 && < 10 ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END13() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 || < 10 ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_END14() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property == \"test\" || == \"test2\" ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(103);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION60() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION61() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) fr";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM1() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(300);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from myGlob";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(300);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM3() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from myGlobal.get";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(300);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION75() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from myGlobal.getList() \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION71() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from getDroolsFunction() \n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE1() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(302);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate(";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(302);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION73() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( int total = 0; ), \n\t\t\taction( total += $cheese.getPrice(); ), \n           result( new Integer( total ) ) \n\t\t) \n\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE_INIT_INSIDE() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(304);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE_ACTION_INSIDE() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( int total = 0; ), \n\t\t\taction( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(306);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE_ACTION_INSIDE3() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( int total = 0; ), \n\t\t\taction( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(306);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE_RESULT_INSIDE() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( int total = 0; ), \n\t\t\taction( total += $cheese.getPrice(); ), \n           result( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(310);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE_INIT_INSIDE2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( int total =";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(304);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE_ACTION_INSIDE2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( int total = 0; ), \n\t\t\taction( total += $ch";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(306);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_ACCUMULATE_RESULT_INSIDE2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == $likes ), \n\t\t\tinit( int total = 0; ), \n\t\t\taction( total += $cheese.getPrice(); ), \n           result( new Integer( tot";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(310);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR40() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from accumulate( \n\t\t\t$cheese : Cheese( type == ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_COLLECT1() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from collect ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(301);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM_COLLECT2() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from collect(";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(301);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION67() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from collect ( \n\t\t\tCheese( type == $likes )\t\t) \n\t\t";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START31() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from collect ( \n\t\t\tCheese( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR31() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from collect ( \n\t\t\tCheese( type ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT21() {
        String input = "rule MyRule \n\twhen \n\t\tClass ( property > 0 ) from collect ( \n\t\t\tCheese( type == ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION68() {
        String input = "rule MyRule \n\twhen \n\t\tArrayList(size > 50) from collect( Person( disabled == \"yes\", income > 100000 ) ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM5() {
        String input = "rule MyRule \n\twhen \n\t\tArrayList(size > 50) from collect( Person( disabled == \"yes\", income > 100000 ) from ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(300);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION69() {
        String input = "rule MyRule \n\twhen \n\t\tArrayList(size > 50) from collect( Person( disabled == \"yes\", income > 100000 ) from town.getPersons() )";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION70() {
        String input = "rule MyRule \n\twhen \n\t\tArrayList(size > 50) from accumulate( Person( disabled == \"yes\", income > 100000 ) ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_FROM6() {
        String input = "rule MyRule \n\twhen \n\t\tArrayList(size > 50) from accumulate( Person( disabled == \"yes\", income > 100000 ) from ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(300);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION81() {
        String input = "rule MyRule \n\twhen \n\t\tforall ( ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START32() {
        String input = "rule MyRule \n\twhen \n\t\tforall (            Class ( pr";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_OPERATOR32() {
        String input = "rule MyRule \n\twhen \n\t\tforall (            Class ( property ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(101);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_ARGUMENT22() {
        String input = "rule MyRule \n\twhen \n\t\tforall (            Class ( property == ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(102);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION76() {
        String input = "rule MyRule \n\twhen \n\t\tforall (            Class ( property == \"test\")           C";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION77a() {
        String input = "rule MyRule \n\twhen \n\t\tArrayList(size > 50) from accumulate( Person( disabled == \"yes\", income > 100000 ) from town.getPersons() ) ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_BEGIN_OF_CONDITION77b() {
        String input = "rule MyRule \n   when \n       ArrayList(size > 50) from accumulate( Person( disabled == \"yes\", income > 100000 ) from town.getPersons() )";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START45a() {
        String input = "rule MyRule \n   when \n       Class ( name :";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckLHSLocationDetermination_INSIDE_CONDITION_START45b() {
        String input = "rule MyRule \n   when \n       Class ( name : ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testCheckRHSLocationDetermination_firstLineOfLHS() {
        String input = "rule MyRule \n\twhen\n\t\tClass ( )\n   then\n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1000);
    }

    @Test(timeout=10000L)
    public void testCheckRHSLocationDetermination_startOfNewlINE() {
        String input = "rule MyRule \n\twhen\n\t\tClass ( )\n   then\n       assert(null);\n       ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1000);
    }

    @Test(timeout=10000L)
    public void testCheckRHSLocationDetermination3() {
        String input = "rule MyRule \n\twhen\n\t\tClass ( )\n   then\n       meth";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1000);
        Object lastElement = ((DroolsSentence)parser.getEditorInterface().get(0)).getContent().getLast();
        Assertions.assertThat((boolean)(lastElement instanceof Token)).isTrue();
        Token lastToken = (Token)lastElement;
        Assertions.assertThat((String)lastToken.getText()).isEqualTo("meth");
    }

    @Test(timeout=10000L)
    public void testCheckRuleHeaderLocationDetermination() {
        String input = "rule MyRule ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2000);
    }

    @Test(timeout=10000L)
    public void testCheckRuleHeaderLocationDetermination2() {
        String input = "rule MyRule \n\tsalience 12 activation-group \"my";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DroolsToken token = this.getLastTokenOnList(((DroolsSentence)parser.getEditorInterface().get(0)).getContent());
        Assertions.assertThat((String)token.getText().toLowerCase()).isEqualTo("group");
        Assertions.assertThat((Comparable)token.getEditorType()).isEqualTo((Object)DroolsEditorType.KEYWORD);
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2001);
    }

    @Test(timeout=10000L)
    public void testCheckRuleHeaderLocationDetermination3() {
        String input = "rule \"Hello World\" ruleflow-group \"hello\" s";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2000);
    }

    @Test(timeout=10000L)
    public void testCheckRuleHeaderLocationDetermination_dialect1() {
        String input = "rule MyRule \n\tdialect \"java\"";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2000);
    }

    @Test(timeout=10000L)
    public void testCheckRuleHeaderLocationDetermination_dialect2() {
        String input = "rule MyRule \n\tdialect \"mvel\"";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2000);
    }

    @Test(timeout=10000L)
    public void testCheckRuleHeaderLocationDetermination_dialect3() {
        String input = "rule MyRule \n\tdialect ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DroolsToken token = this.getLastTokenOnList(((DroolsSentence)parser.getEditorInterface().get(0)).getContent());
        Assertions.assertThat((String)token.getText().toLowerCase()).isEqualTo("dialect");
        Assertions.assertThat((Comparable)token.getEditorType()).isEqualTo((Object)DroolsEditorType.KEYWORD);
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2001);
    }

    @Test(timeout=10000L)
    public void testCheckRuleHeaderLocationDetermination_dialect4() {
        String input = "rule MyRule \n\tdialect \"";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DroolsToken token = this.getLastTokenOnList(((DroolsSentence)parser.getEditorInterface().get(0)).getContent());
        Assertions.assertThat((String)token.getText().toLowerCase()).isEqualTo("dialect");
        Assertions.assertThat((Comparable)token.getEditorType()).isEqualTo((Object)DroolsEditorType.KEYWORD);
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2001);
    }

    @Test(timeout=10000L)
    public void testCheckQueryLocationDetermination_RULE_HEADER1() {
        String input = "query MyQuery ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2000);
    }

    @Test(timeout=10000L)
    public void testCheckQueryLocationDetermination_RULE_HEADER2() {
        String input = "query \"MyQuery\" ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(2000);
    }

    @Test(timeout=10000L)
    public void testCheckQueryLocationDetermination_LHS_BEGIN_OF_CONDITION() {
        String input = "query MyQuery() ";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testCheckQueryLocationDetermination_LHS_INSIDE_CONDITION_START() {
        String input = "query MyQuery \n\tClass (";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    @Test(timeout=10000L)
    public void testRuleParameters_PATTERN_1() {
        String input = "rule MyRule \n    when \n        c: Class (";
        DRLParser parser = this.getParser(input);
        parser.enableEditorInterface();
        try {
            parser.compilationUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorInterface().get(0)).getContent())).isEqualTo(100);
    }

    private int getLastIntegerValue(LinkedList list) {
        int lastIntergerValue = -1;
        for (Object object : list) {
            if (!(object instanceof Integer)) continue;
            lastIntergerValue = (Integer)object;
        }
        return lastIntergerValue;
    }

    private DroolsToken getLastTokenOnList(LinkedList list) {
        DroolsToken lastToken = null;
        for (Object object : list) {
            if (!(object instanceof DroolsToken)) continue;
            lastToken = (DroolsToken)object;
        }
        return lastToken;
    }

    private DRLParser getParser(String text) {
        return DRLFactory.buildParser((String)text, (LanguageLevelOption)LanguageLevelOption.DRL5);
    }
}

