/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.ConnectiveType;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.compiler.lang.descr.RelationalExprDescr;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRLExprParserTest {
    DrlExprParser parser;

    @Before
    public void setUp() throws Exception {
        new EvaluatorRegistry();
        this.parser = new DrlExprParser(LanguageLevelOption.DRL6);
    }

    @After
    public void tearDown() throws Exception {
        this.parser = null;
    }

    @Test
    public void testSimpleExpression() throws Exception {
        String source = "a > b";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(1);
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo(">");
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("a");
        Assertions.assertThat((String)right.getExpression()).isEqualTo("b");
    }

    @Test
    public void testAndConnective() throws Exception {
        String source = "a > b && 10 != 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(2);
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo(">");
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("a");
        Assertions.assertThat((String)right.getExpression()).isEqualTo("b");
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo("!=");
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("10");
        Assertions.assertThat((String)right.getExpression()).isEqualTo("20");
    }

    @Test
    public void testConnective2() throws Exception {
        String source = "(a > b || 10 != 20) && someMethod(10) == 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(2);
        ConstraintConnectiveDescr or = (ConstraintConnectiveDescr)result.getDescrs().get(0);
        Assertions.assertThat((Comparable)or.getConnective()).isEqualTo((Object)ConnectiveType.OR);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        RelationalExprDescr expr = (RelationalExprDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo(">");
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("a");
        Assertions.assertThat((String)right.getExpression()).isEqualTo("b");
        expr = (RelationalExprDescr)or.getDescrs().get(1);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo("!=");
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("10");
        Assertions.assertThat((String)right.getExpression()).isEqualTo("20");
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo("==");
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("someMethod(10)");
        Assertions.assertThat((String)right.getExpression()).isEqualTo("20");
    }

    @Test
    public void testBinding() throws Exception {
        String source = "$x : property";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(1);
        BindingDescr bind = (BindingDescr)result.getDescrs().get(0);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("property");
    }

    @Test
    public void testBindingConstraint() throws Exception {
        String source = "$x : property > value";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(1);
        RelationalExprDescr rel = (RelationalExprDescr)result.getDescrs().get(0);
        Assertions.assertThat((String)rel.getOperator()).isEqualTo(">");
        BindingDescr bind = (BindingDescr)rel.getLeft();
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("property");
        AtomicExprDescr right = (AtomicExprDescr)rel.getRight();
        Assertions.assertThat((String)right.getExpression()).isEqualTo("value");
    }

    @Test
    public void testBindingWithRestrictions() throws Exception {
        String source = "$x : property > value && < 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(2);
        RelationalExprDescr rel = (RelationalExprDescr)result.getDescrs().get(0);
        Assertions.assertThat((String)rel.getOperator()).isEqualTo(">");
        BindingDescr bind = (BindingDescr)rel.getLeft();
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("property");
        AtomicExprDescr right = (AtomicExprDescr)rel.getRight();
        Assertions.assertThat((String)right.getExpression()).isEqualTo("value");
        rel = (RelationalExprDescr)result.getDescrs().get(1);
        Assertions.assertThat((String)rel.getOperator()).isEqualTo("<");
        AtomicExprDescr left = (AtomicExprDescr)rel.getLeft();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("property");
        right = (AtomicExprDescr)rel.getRight();
        Assertions.assertThat((String)right.getExpression()).isEqualTo("20");
    }

    @Test
    public void testDoubleBinding() throws Exception {
        String source = "$x : x.m( 1, a ) && $y : y[z].foo";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(2);
        BindingDescr bind = (BindingDescr)result.getDescrs().get(0);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("x.m( 1, a )");
        bind = (BindingDescr)result.getDescrs().get(1);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$y");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("y[z].foo");
    }

    @Test
    public void testDeepBinding() throws Exception {
        String source = "($a : a > $b : b[10].prop || 10 != 20) && $x : someMethod(10) == 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(2);
        ConstraintConnectiveDescr or = (ConstraintConnectiveDescr)result.getDescrs().get(0);
        Assertions.assertThat((Comparable)or.getConnective()).isEqualTo((Object)ConnectiveType.OR);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        RelationalExprDescr expr = (RelationalExprDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo(">");
        BindingDescr leftBind = (BindingDescr)expr.getLeft();
        BindingDescr rightBind = (BindingDescr)expr.getRight();
        Assertions.assertThat((String)leftBind.getVariable()).isEqualTo("$a");
        Assertions.assertThat((String)leftBind.getExpression()).isEqualTo("a");
        Assertions.assertThat((String)rightBind.getVariable()).isEqualTo("$b");
        Assertions.assertThat((String)rightBind.getExpression()).isEqualTo("b[10].prop");
        expr = (RelationalExprDescr)or.getDescrs().get(1);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo("!=");
        AtomicExprDescr leftExpr = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr rightExpr = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)leftExpr.getExpression()).isEqualTo("10");
        Assertions.assertThat((String)rightExpr.getExpression()).isEqualTo("20");
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo("==");
        leftBind = (BindingDescr)expr.getLeft();
        rightExpr = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)leftBind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)leftBind.getExpression()).isEqualTo("someMethod(10)");
        Assertions.assertThat((String)rightExpr.getExpression()).isEqualTo("20");
    }

    @Test(timeout=10000L)
    public void testNestedExpression() throws Exception {
        String source = "(((((((((((((((((((((((((((((((((((((((((((((((((( a > b ))))))))))))))))))))))))))))))))))))))))))))))))))";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)result.getConnective()).isEqualTo((Object)ConnectiveType.AND);
        Assertions.assertThat((int)result.getDescrs().size()).isEqualTo(1);
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        Assertions.assertThat((String)expr.getOperator()).isEqualTo(">");
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        Assertions.assertThat((String)left.getExpression()).isEqualTo("a");
        Assertions.assertThat((String)right.getExpression()).isEqualTo("b");
    }
}

