/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import java.util.LinkedList;
import org.antlr.runtime.RecognitionException;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.DroolsSentence;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRLIncompleteCodeTest {
    @Before
    public void setup() {
        new EvaluatorRegistry();
    }

    @Test
    @Ignore
    public void testIncompleteCode1() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collexction ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        System.out.println(parser.getErrors());
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((String)descr.getNamespace()).isEqualTo("a.b.c");
        Assertions.assertThat((String)((ImportDescr)descr.getImports().get(0)).getTarget()).isEqualTo("a.b.c.*");
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(2)).getContent())).isEqualTo(103);
    }

    @Test
    public void testIncompleteCode2() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property memberOf collection ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(0)).getContent())).isEqualTo(103);
    }

    @Test
    public void testIncompleteCode3() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property > somevalue ) then end query MyQuery Class ( property == collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((String)((RuleDescr)descr.getRules().get(0)).getName()).isEqualTo("MyRule");
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((String)((RuleDescr)descr.getRules().get(1)).getName()).isEqualTo("MyQuery");
        Assertions.assertThat((int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(0)).getContent())).isEqualTo(1000);
    }

    @Test
    public void testIncompleteCode4() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property == collection ) then end  query MyQuery Class ( property == collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((String)descr.getNamespace()).isEqualTo("a.b.c");
        Assertions.assertThat((String)((ImportDescr)descr.getImports().get(0)).getTarget()).isEqualTo("a.b.c.*");
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((String)((RuleDescr)descr.getRules().get(0)).getName()).isEqualTo("MyRule");
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((String)((RuleDescr)descr.getRules().get(1)).getName()).isEqualTo("MyQuery");
    }

    @Test
    public void testIncompleteCode5() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    @Test
    public void testIncompleteCode6() throws DroolsParserException, RecognitionException {
        String input = "packe 1111.111 import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    @Test
    public void testIncompleteCode7() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c imrt a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    @Test
    public void testIncompleteCode8() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.1111.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        System.out.println(parser.getErrors());
        Assertions.assertThat((String)descr.getNamespace()).isEqualTo("a.b.c");
        Assertions.assertThat((boolean)parser.hasErrors()).isEqualTo(true);
    }

    @Test
    @Ignore
    public void testIncompleteCode9() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule xxxxx Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((String)descr.getNamespace()).isEqualTo("a.b.c");
        Assertions.assertThat((String)((ImportDescr)descr.getImports().get(0)).getTarget()).isEqualTo("a.b.c.*");
        Assertions.assertThat((int)descr.getRules().size()).isEqualTo(1);
        Assertions.assertThat((String)((RuleDescr)descr.getRules().get(0)).getName()).isEqualTo("MyQuery");
    }

    @Test
    @Ignore
    public void testIncompleteCode10() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule xxxxx Class ( property memberOf  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((String)descr.getNamespace()).isEqualTo("a.b.c");
        Assertions.assertThat((String)((ImportDescr)descr.getImports().get(0)).getTarget()).isEqualTo("a.b.c.*");
        Assertions.assertThat((int)descr.getRules().size()).isEqualTo(0);
    }

    @Test
    public void testIncompleteCode11() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  qzzzzuery MyQuery Class ( property ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((String)descr.getNamespace()).isEqualTo("a.b.c");
        Assertions.assertThat((String)((ImportDescr)descr.getImports().get(0)).getTarget()).isEqualTo("a.b.c.*");
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((String)((RuleDescr)descr.getRules().get(0)).getName()).isEqualTo("MyRule");
    }

    @Test
    public void testIncompleteCode12() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule  when     m: Message(  )       thenend ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
        Assertions.assertThat((String)descr.getNamespace()).isEqualTo("a.b.c");
        Assertions.assertThat((String)((ImportDescr)descr.getImports().get(0)).getTarget()).isEqualTo("a.b.c.*");
    }

    @Test
    public void testIncompleteCode13() throws DroolsParserException, RecognitionException {
        String input = "package com.sample import com.sample.DroolsTest.Message; rule \"Hello World\"  when   then     \\\" end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    private int getLastIntegerValue(LinkedList list) {
        int lastIntergerValue = -1;
        for (Object object : list) {
            if (!(object instanceof Integer)) continue;
            lastIntergerValue = (Integer)object;
        }
        return lastIntergerValue;
    }
}

