/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.oopath.model.Child;
import org.drools.mvel.compiler.oopath.model.Man;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class OOPathAccumulateTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathAccumulateTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testAccumulateAverage() {
        this.testAccumulate("average", 10);
    }

    @Test
    public void testAccumulateMin() {
        this.testAccumulate("min", 8);
    }

    @Test
    public void testAccumulateMax() {
        this.testAccumulate("max", 12);
    }

    @Test
    public void testAccumulateCount() {
        this.testAccumulate("count", 2);
    }

    @Test
    public void testAccumulateSum() {
        this.testAccumulate("sum", 20);
    }

    @Test
    public void testAccumulateCollectList() {
        this.testAccumulateCollection("collectList", 12, 8);
    }

    @Test
    public void testAccumulateCollectSet() {
        this.testAccumulateCollection("collectSet", 12, 8);
    }

    private void testAccumulate(String accumulateFunction, Number expectedResult) {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.lang.Object globalVar\n\nrule R when\n  accumulate ( Adult( $child: /children ) ; $accumulateResult: " + accumulateFunction + "($child.getAge()) )\nthen\n  kcontext.getKieRuntime().setGlobal(\"globalVar\", $accumulateResult);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        Man bob = new Man("Bob", 40);
        bob.addChild(new Child("Charles", 12));
        bob.addChild(new Child("Debbie", 8));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Number result = (Number)ksession.getGlobal("globalVar");
        if (result instanceof Double) {
            Assertions.assertThat((double)expectedResult.doubleValue()).isEqualTo(result.doubleValue());
        } else {
            Assertions.assertThat((long)expectedResult.longValue()).isEqualTo(result.longValue());
        }
    }

    private void testAccumulateCollection(String accumulateFunction, Integer ... expectedResults) {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Collection<Integer> globalVar\n\nrule R when\n  accumulate ( Adult( $child: /children ) ; $accumulateResult: " + accumulateFunction + "($child.getAge()) )\nthen\n  kcontext.getKieRuntime().setGlobal(\"globalVar\", $accumulateResult);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        Man bob = new Man("Bob", 40);
        bob.addChild(new Child("Charles", 12));
        bob.addChild(new Child("Debbie", 8));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Collection result = (Collection)ksession.getGlobal("globalVar");
        Assertions.assertThat((Iterable)result).containsExactlyInAnyOrder((Object[])expectedResults);
    }
}

