/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.runtime.pipeline.impl;

import com.sun.tools.xjc.Options;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DroolsJaxbHelperTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String simpleXsdRelativePath = "simple.xsd";

    public DroolsJaxbHelperTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testXsdModelInRule() {
        Field[] declaredFields;
        Method m2;
        String s1 = "package test; global java.util.List list; rule Init when then   insert( new Sub() );   insert( new Message() );   insert( new Test() );   insert( new Left() ); end\nrule CheckSub when  $s : Sub() then   list.add( \"Sub\" );  end\nrule CheckMsg when  $s : Message() then   list.add( \"Message\" );  end\n ";
        List resources = KieUtil.getResourcesFromDrls((String[])new String[]{"package test; global java.util.List list; rule Init when then   insert( new Sub() );   insert( new Message() );   insert( new Test() );   insert( new Left() ); end\nrule CheckSub when  $s : Sub() then   list.add( \"Sub\" );  end\nrule CheckMsg when  $s : Message() then   list.add( \"Message\" );  end\n "});
        InputStream simpleXsdStream = this.getClass().getResourceAsStream(simpleXsdRelativePath);
        ((AbstractInputStreamAssert)Assertions.assertThat((InputStream)simpleXsdStream).as("Could not find resource: simple.xsd", new Object[0])).isNotNull();
        InputStreamResource xsdResource = new InputStreamResource(simpleXsdStream);
        xsdResource.setResourceType(ResourceType.XSD);
        xsdResource.setSourcePath("src/main/resources/simple.xsd");
        Options xjcOptions = new Options();
        xsdResource.setConfiguration((ResourceConfiguration)new JaxbConfigurationImpl(xjcOptions, "test-system-id"));
        resources.add(xsdResource);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])resources.toArray(new Resource[0]));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("Sub", "Message"))).isTrue();
        Collection fhs = ks.getFactHandles();
        Iterator iter = fhs.iterator();
        DefaultFactHandle subFh = null;
        DefaultFactHandle msgFh = null;
        DefaultFactHandle leftFh = null;
        DefaultFactHandle testFh = null;
        while (iter.hasNext()) {
            DefaultFactHandle dfh = (DefaultFactHandle)iter.next();
            if (dfh.getObjectClassName().equals("test.Sub")) {
                subFh = dfh;
                continue;
            }
            if (dfh.getObjectClassName().equals("test.Message")) {
                msgFh = dfh;
                continue;
            }
            if (dfh.getObjectClassName().equals("test.Left")) {
                leftFh = dfh;
                continue;
            }
            if (dfh.getObjectClassName().equals("test.Test")) {
                testFh = dfh;
                continue;
            }
            Assertions.fail((String)("Unexpected FH class: " + dfh.getObjectClassName()));
        }
        ((ObjectAssert)Assertions.assertThat(subFh).as("No FactHandle for Sub found!", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat(msgFh).as("No FactHandle for Message found!", new Object[0])).isNotNull();
        Object xsdObj = subFh.getObject();
        Class<?> xsdClass = xsdObj.getClass();
        try {
            m2 = xsdClass.getMethod("getFld", new Class[0]);
            Assertions.assertThat((Object)m2).isNotNull();
            Assertions.assertThat(m2.getReturnType()).isEqualTo(String.class);
            Assertions.assertThat((int)xsdClass.getFields().length).isEqualTo(0);
            declaredFields = xsdClass.getDeclaredFields();
            Assertions.assertThat((int)declaredFields.length).isEqualTo(1);
            Assertions.assertThat((String)declaredFields[0].getName()).isEqualTo("fld");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
        xsdObj = msgFh.getObject();
        xsdClass = xsdObj.getClass();
        try {
            m2 = xsdClass.getMethod("getContent", new Class[0]);
            Assertions.assertThat((Object)m2).isNotNull();
            Assertions.assertThat(m2.getReturnType()).isEqualTo(List.class);
            Assertions.assertThat((int)xsdClass.getFields().length).isEqualTo(0);
            declaredFields = xsdClass.getDeclaredFields();
            Assertions.assertThat((int)declaredFields.length).isEqualTo(1);
            Assertions.assertThat((String)declaredFields[0].getName()).isEqualTo("content");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

