/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.mvel.DrlDumper;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.definition.KieDescr;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DRLDumperTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static Logger logger = LoggerFactory.getLogger(DRLDumperTest.class);

    public DRLDumperTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDumpers() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        InputStreamResource resource = new InputStreamResource(this.getClass().getResourceAsStream("drl/test_Dumpers.drl"));
        PackageDescr pkg = parser.parse((Resource)resource);
        if (parser.hasErrors()) {
            for (DroolsError error : parser.getErrors()) {
                logger.warn(error.toString());
            }
            Assertions.fail((String)parser.getErrors().toString());
        }
        Resource descrResource = KieServices.Factory.get().getResources().newDescrResource((KieDescr)pkg);
        descrResource.setSourcePath("src/main/resources/test_Dumpers.descr");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{descrResource});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"3 1");
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"MAIN");
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"1 1");
        DrlDumper drlDumper = new DrlDumper();
        String drlResult = drlDumper.dump(pkg);
        System.out.println(drlResult);
        kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlResult});
        ksession = kbase.newKieSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"3 1");
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"MAIN");
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"1 1");
    }
}

