/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.DebugRuleRuntimeEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class DynamicEvalTest {
    KieBase kbase;
    KieSession session;
    SessionPseudoClock clock;
    Collection<? extends Object> effects;
    KnowledgeBuilder kbuilder;
    KieBaseConfiguration baseConfig;
    KieSessionConfiguration sessionConfig;

    @Before
    public void setUp() throws Exception {
        this.baseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        this.baseConfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        this.kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)this.baseConfig);
        this.sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        this.sessionConfig.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        this.session = this.kbase.newKieSession(this.sessionConfig, null);
        this.clock = (SessionPseudoClock)this.session.getSessionClock();
    }

    public void loadPackages(Resource res, ResourceType type) {
        this.kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        this.kbuilder.add(res, type);
        KnowledgeBuilderErrors errors = this.kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
    }

    @After
    public void tearDown() {
        if (this.session != null) {
            this.session.dispose();
        }
        this.kbase = null;
        this.effects = null;
        this.clock = null;
        this.kbuilder = null;
        this.baseConfig = null;
        this.sessionConfig = null;
    }

    @Test
    public void testDynamicAdd() {
        String test = "\nrule id3\nwhen\neval(0 < 1)\nthen\ninsertLogical( \"done\" );\nend";
        this.loadPackages(ResourceFactory.newByteArrayResource((byte[])test.getBytes()), ResourceType.DRL);
        ((KnowledgeBaseImpl)this.session.getKieBase()).addPackages(this.kbuilder.getKnowledgePackages());
        this.session.addEventListener((RuleRuntimeEventListener)new DebugRuleRuntimeEventListener());
        int fired = this.session.fireAllRules();
        System.out.println(fired);
        this.effects = this.session.getObjects();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.effects.contains("done")).as("fired", new Object[0])).isTrue();
        String test2 = "\nrule id4\nwhen\neval(0 == 0 )\nthen\ninsertLogical( \"done2\" );\nend";
        this.loadPackages(ResourceFactory.newByteArrayResource((byte[])test2.getBytes()), ResourceType.DRL);
        ((KnowledgeBaseImpl)this.session.getKieBase()).addPackages(this.kbuilder.getKnowledgePackages());
        fired = this.session.fireAllRules();
        System.out.println(fired);
        this.effects = this.session.getObjects();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.effects.contains("done2")).as("fired", new Object[0])).isTrue();
    }

    @Test
    public void testDynamicAdd2() {
        String test = "rule id3\nwhen\neval(0 == 0)\nString( this == \"go\" )\nthen\ninsertLogical( \"done\" );\nend\nrule id5\nwhen\neval(0 == 0)\nInteger( this == 7 )\nthen\ninsertLogical( \"done3\" );\nend\n";
        this.loadPackages(ResourceFactory.newByteArrayResource((byte[])test.getBytes()), ResourceType.DRL);
        ((KnowledgeBaseImpl)this.session.getKieBase()).addPackages(this.kbuilder.getKnowledgePackages());
        this.session.addEventListener((RuleRuntimeEventListener)new DebugRuleRuntimeEventListener());
        this.session.insert((Object)"go");
        this.session.insert((Object)5);
        this.session.insert((Object)7);
        int fired = this.session.fireAllRules();
        System.out.println(fired);
        this.effects = this.session.getObjects();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.effects.contains("done")).as("fired", new Object[0])).isTrue();
        String test2 = "\nrule id4\nwhen\neval(0 == 0 )\nInteger( this == 5 )\nthen\ninsertLogical( \"done2\" );\nend";
        this.loadPackages(ResourceFactory.newByteArrayResource((byte[])test2.getBytes()), ResourceType.DRL);
        ((KnowledgeBaseImpl)this.session.getKieBase()).addPackages(this.kbuilder.getKnowledgePackages());
        fired = this.session.fireAllRules();
        System.out.println(fired);
        this.effects = this.session.getObjects();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.effects.contains("done2")).as("fired", new Object[0])).isTrue();
        for (Object o : this.session.getObjects()) {
            System.out.println(o);
        }
    }
}

