/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieBuilder;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DynamicRuleRemovalTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DynamicRuleRemovalTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDynamicRuleRemoval() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.addRule(kbase, "rule1");
        this.addRule(kbase, "rule2");
        this.addRule(kbase, "rule3");
        KieSession ksession = kbase.newKieSession();
        ArrayList rulesList = new ArrayList();
        ksession.setGlobal("list", rulesList);
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        Assertions.assertThat((int)rulesList.size()).isEqualTo(3);
        Assertions.assertThat((boolean)rulesList.contains("rule1")).isTrue();
        Assertions.assertThat((boolean)rulesList.contains("rule2")).isTrue();
        Assertions.assertThat((boolean)rulesList.contains("rule3")).isTrue();
        this.removeRule(kbase, "rule1");
        rulesList.clear();
        ksession.insert((Object)"3");
        ksession.fireAllRules();
        Assertions.assertThat((int)rulesList.size()).isEqualTo(2);
        Assertions.assertThat((boolean)rulesList.contains("rule1")).isFalse();
        Assertions.assertThat((boolean)rulesList.contains("rule2")).isTrue();
        Assertions.assertThat((boolean)rulesList.contains("rule3")).isTrue();
    }

    private void addRule(InternalKnowledgeBase kbase, String ruleName) {
        String rule = this.createDRL(ruleName);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)true, (String[])new String[]{rule});
        Collection pkgs = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder).getKiePackages();
        kbase.addPackages(pkgs);
    }

    private void removeRule(InternalKnowledgeBase kbase, String ruleName) {
        kbase.removeRule("org.kie.test", ruleName);
    }

    private String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\nwhen\n   $s: String()\nthen\nlist.add( drools.getRule().getName() );\nend\n";
    }
}

