/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;

@RunWith(value=Parameterized.class)
public class KieServicesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieServices ks;

    public KieServicesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void init() {
        this.ks = KieServices.Factory.get();
        ((KieServicesImpl)this.ks).nullKieClasspathContainer();
        ((KieServicesImpl)this.ks).nullAllContainerIds();
    }

    @After
    public void shutdown() {
        ((KieServicesImpl)this.ks).nullKieClasspathContainer();
        ((KieServicesImpl)this.ks).nullAllContainerIds();
    }

    @Test
    public void testGetKieClasspathIDs() {
        String myId = "myId";
        KieContainer c1 = this.ks.getKieClasspathContainer(myId);
        Assertions.assertThat((Object)this.ks.getKieClasspathContainer()).isEqualTo((Object)c1);
        Assertions.assertThat((Object)this.ks.getKieClasspathContainer(myId)).isEqualTo((Object)c1);
        try {
            this.ks.getKieClasspathContainer("invalid");
            Assertions.fail((String)"this is not the containerId for the global singleton.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNewKieClasspathIDs() {
        KieContainer c1 = this.ks.newKieClasspathContainer("id1");
        KieContainer c2 = this.ks.newKieClasspathContainer("id2");
        try {
            this.ks.newKieClasspathContainer("id2");
            Assertions.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNewKieContainerIDs() {
        ReleaseId releaseId = this.ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieModule km = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("ruleA")});
        KieContainer c1 = this.ks.newKieContainer("id1", releaseId);
        KieContainer c2 = this.ks.newKieClasspathContainer("id2");
        try {
            this.ks.newKieContainer("id2", releaseId);
            Assertions.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ks.newKieClasspathContainer("id1");
            Assertions.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDisposeClearTheIDReference() {
        ReleaseId releaseId = this.ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieModule km = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("ruleA")});
        KieContainer c1 = this.ks.newKieContainer("id1", releaseId);
        try {
            this.ks.newKieClasspathContainer("id1");
            Assertions.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((KieContainerImpl)c1).dispose();
        this.ks.newKieClasspathContainer("id1");
    }

    private String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\nwhen\nthen\nlist.add( drools.getRule().getName() );\nend\n";
    }
}

