/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class KnowledgeBuilderTest {
    private FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager().setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    @Test
    public void testCompositeKnowledgeBuilder() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nrule R1 when\n   $fieldA : FactA( $fieldB : fieldB )\n   FactB( this == $fieldB, fieldA == $fieldA )\nthen\nend";
        String declarationA = "package org.drools.mvel.compiler.test\ndeclare FactA\n    fieldB: FactB\nend\n";
        String declarationB = "package org.drools.mvel.compiler.test\ndeclare FactB\n    fieldA: FactA\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isTrue();
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isTrue();
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.batch().add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL).build();
        if (kbuilder2.hasErrors()) {
            Assertions.fail((String)kbuilder2.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder2.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        Object a = aType.newInstance();
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object b = bType.newInstance();
        aType.set(a, "fieldB", b);
        bType.set(b, "fieldA", a);
        a.toString();
        b.toString();
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testDifferentPackages() throws Exception {
        String rule = "package org.drools.mvel.compiler.test.rule\nimport org.drools.mvel.compiler.testA.FactA\nimport org.drools.mvel.compiler.testB.FactB\nrule R1 when\n   $fieldA : FactA( $fieldB : fieldB, bigint == 1 )\n   FactB( this == $fieldB, fieldA == $fieldA )\nthen\n   list.add(\"OK\");end";
        String declarationA = "package org.drools.mvel.compiler.testA\nimport org.drools.mvel.compiler.testB.FactB\nimport java.math.BigInteger\ndeclare FactA\n    fieldB: FactB\n    bigint: BigInteger\nend\n";
        String declarationB = "package org.drools.mvel.compiler.testB\nimport org.drools.mvel.compiler.testA.FactA\nglobal java.util.List list\ndeclare FactB\n    fieldA: FactA\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes())).build();
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        String declarationC = "package org.drools.mvel.compiler.testA\ndeclare FactC\n    field : UnknownClass\nend\n";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationC.getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isTrue();
        kbuilder.undo();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.testA", "FactA");
        Object a = aType.newInstance();
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.testB", "FactB");
        Object b = bType.newInstance();
        aType.set(a, "fieldB", b);
        aType.set(a, "bigint", (Object)new BigInteger("1"));
        bType.set(b, "fieldA", a);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"OK");
    }

    @Test
    @Ignore(value="All the classes generated by type declarations are now defined in the ProjectClassLoader")
    public void testUndoTypeDeclaration() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.compiler.test.FactA\nimport org.drools.compiler.test.FactB\nrule R1 when\n   FactA( i == 1 )\n   FactB( i == 1 )\nthen\n   list.add(\"OK\");end\n";
        String declarationA = "package org.drools.mvel.compiler.test\nglobal java.util.List list\ndeclare FactA\n    j : int\nend\n";
        String declarationB = "package org.drools.mvel.compiler.test\ndeclare FactB\n    i : int\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).build();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isTrue();
        kbuilder.undo();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        declarationA = "package org.drools.mvel.compiler.test\nglobal java.util.List list\ndeclare FactA\n    i : int\nend\n";
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).build();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        Object a = aType.newInstance();
        aType.set(a, "i", (Object)1);
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object b = bType.newInstance();
        bType.set(b, "i", (Object)1);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"OK");
    }

    @Test
    public void testUndoRule() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nglobal java.util.List list\nimport org.drools.mvel.compiler.test.FactA\nimport org.drools.mvel.compiler.test.FactB\nrule R1 when\n   FactA( j == 1 )\n   FactB( i == 1 )\nthen\n   list.add(\"OK\");end\n";
        String declarationA = "package org.drools.mvel.compiler.test\ndeclare FactA\n    i : int\nend\n";
        String declarationB = "package org.drools.mvel.compiler.test\ndeclare FactB\n    i : int\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).build();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isTrue();
        kbuilder.undo();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        rule = "package org.drools.mvel.compiler.test\nglobal java.util.List list\nimport org.drools.mvel.compiler.test.FactA\nimport org.drools.mvel.compiler.test.FactB\nrule R1 when\n   FactA( i == 1 )\n   FactB( i == 1 )\nthen\n   list.add(\"OK\");end\n";
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).build();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        Object a = aType.newInstance();
        aType.set(a, "i", (Object)1);
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object b = bType.newInstance();
        bType.set(b, "i", (Object)1);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"OK");
    }

    @Test
    public void testAddPackageSingle() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\nrule R1 when\n   StockTick()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kbuilder.hasErrors()).as(kbuilder.getErrors().toString(), new Object[0])).isFalse();
        Collection kpkgs = kbuilder.getKnowledgePackages();
        Assertions.assertThat((int)kpkgs.size()).isEqualTo(2);
        KiePackage kpkg = (KiePackage)kpkgs.iterator().next();
        Assertions.assertThat((int)kpkg.getRules().size()).isEqualTo(1);
    }

    @Test
    public void testAddPackageArray() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\ndeclare StockTick @role(event) end\nrule R1 when\n   StockTick()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kbuilder.hasErrors()).as(kbuilder.getErrors().toString(), new Object[0])).isFalse();
        Collection kpkgs = kbuilder.getKnowledgePackages();
        Assertions.assertThat((int)kpkgs.size()).isEqualTo(2);
    }

    @Ignore
    @Test
    public void testResourceMapping() throws Exception {
        ServiceRegistry.Impl serviceRegistry = (ServiceRegistry.Impl)ServiceRegistry.getInstance();
        serviceRegistry.reset();
        serviceRegistry.reload();
        String rule = "package org.drools.mvel.compiler.test\nrule R1 when\n \nthen\nend\n";
        Resource res1 = ResourceFactory.newByteArrayResource((byte[])rule.getBytes());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(res1, ResourceType.DRL);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kbuilder.hasErrors()).as(kbuilder.getErrors().toString(), new Object[0])).isFalse();
        KiePackage kp1 = (KiePackage)kbuilder.getKnowledgePackages().iterator().next();
        Assertions.assertThat((int)kp1.getRules().size()).isEqualTo(1);
        Rule r = (Rule)kp1.getRules().iterator().next();
        Assertions.assertThat((Object)((RuleImpl)r).getResource()).isEqualTo((Object)res1);
        String pmml = "<PMML version=\"4.0\"><Header/></PMML>";
        Resource res2 = ResourceFactory.newByteArrayResource((byte[])pmml.getBytes());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add(res2, ResourceType.PMML);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kbuilder2.hasErrors()).as(kbuilder2.getErrors().toString(), new Object[0])).isFalse();
        KiePackage kp2 = (KiePackage)kbuilder2.getKnowledgePackages().iterator().next();
        Assertions.assertThat((int)kp2.getRules().size()).isEqualTo(1);
        Rule r2 = (Rule)kp2.getRules().iterator().next();
        Assertions.assertThat((Object)((RuleImpl)r2).getResource()).isEqualTo((Object)res2);
    }

    @Test
    public void testRepeatedDeclarationInMultiplePackages() {
        String str = "package org.drools.test1;\nimport org.drools.mvel.compiler.Cheese;\nrule R\nwhen Cheese() then end \n";
        String str2 = "package org.drools.test2;\nimport org.drools.mvel.compiler.Cheese;\nrule S\nwhen Cheese() then end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        Assertions.assertThat((int)kbuilder.getKnowledgePackages().size()).isEqualTo(3);
        for (KiePackage kp : kbuilder.getKnowledgePackages()) {
            KnowledgePackageImpl kpi = (KnowledgePackageImpl)kp;
            TypeDeclaration cheez = kpi.getTypeDeclaration("Cheese");
            if ("org.drools.mvel.compiler".equals(kpi.getName())) {
                Assertions.assertThat((Comparable)cheez).isNotNull();
                continue;
            }
            Assertions.assertThat((Comparable)cheez).isNull();
        }
    }
}

