/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.WorkingMemory;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Pet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class MapConstraintTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MapConstraintTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMapAccess() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MapAccess.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", 28);
        ksession.insert(map);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains(map)).isTrue();
    }

    @Test
    public void testMapAccessWithVariable() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MapAccessWithVariable.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        ksession.insert(map);
        ksession.insert((Object)"name");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains(map)).isTrue();
    }

    @Test
    public void testMapAccessWithVariable2() {
        String str = "package org.drools.compiler;\nimport java.util.Map;\nrule \"map access with variable\"\n    when\n        $key : String( )\n        $p1 : Person( name == 'Bob', namedAddresses[$key] != null, $na : namedAddresses[$key] )\n        $p2 : Person( name == 'Mark', namedAddresses[$key] == $na )\n    then\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler;\nimport java.util.Map;\nrule \"map access with variable\"\n    when\n        $key : String( )\n        $p1 : Person( name == 'Bob', namedAddresses[$key] != null, $na : namedAddresses[$key] )\n        $p2 : Person( name == 'Mark', namedAddresses[$key] == $na )\n    then\nend\n"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test
    public void testMapNullConstraint() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_mapNullConstraints.drl"});
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        new WorkingMemoryConsoleLogger((WorkingMemory)ksession);
        HashMap<Object, Address> addresses = new HashMap<Object, Address>();
        addresses.put("home", new Address("home street"));
        Person bob = new Person("Bob");
        bob.setNamedAddresses(addresses);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)4))).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        AfterMatchFiredEvent aaf = (AfterMatchFiredEvent)arg.getAllValues().get(0);
        Assertions.assertThat((String)aaf.getMatch().getRule().getName()).isEqualTo("1. home != null");
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(1);
        Assertions.assertThat((String)aaf.getMatch().getRule().getName()).isEqualTo("2. not home == null");
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(2);
        Assertions.assertThat((String)aaf.getMatch().getRule().getName()).isEqualTo("7. work == null");
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(3);
        Assertions.assertThat((String)aaf.getMatch().getRule().getName()).isEqualTo("8. not work != null");
    }

    @Test
    public void testMapAccessorWithPrimitiveKey() {
        String str = "package com.sample\nimport " + MapContainerBean.class.getCanonicalName() + ";\nrule R1 when\n  MapContainerBean( map[1] == \"one\" )\nthen\nend\nrule R2 when\n  MapContainerBean( map[1+1] == \"two\" )\nthen\nend\nrule R3 when\n  MapContainerBean( map[this.get3()] == \"three\" )\nthen\nend\nrule R4 when\n  MapContainerBean( map[4] == null )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new MapContainerBean());
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(4);
        ksession.dispose();
    }

    @Test
    public void testMapModel() {
        String str = "package org.drools.compiler\nimport java.util.Map\nrule \"test\"\nwhen\n    Map( type == \"Person\", name == \"Bob\" );\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\nimport java.util.Map\nrule \"test\"\nwhen\n    Map( type == \"Person\", name == \"Bob\" );\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        HashMap<String, String> mark = new HashMap<String, String>();
        mark.put("type", "Person");
        mark.put("name", "Mark");
        ksession.insert(mark);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(0);
        HashMap<String, String> bob = new HashMap<String, String>();
        bob.put("type", "Person");
        bob.put("name", "Bob");
        ksession.insert(bob);
        rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testListOfMaps() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_TestMapVariableRef.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        HashMap<String, String> mapOne = new HashMap<String, String>();
        HashMap<String, String> mapTwo = new HashMap<String, String>();
        mapOne.put("MSG", "testMessage");
        mapTwo.put("MSGTWO", "testMessage");
        list.add(mapOne);
        list.add(mapTwo);
        ksession.insert(list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
    }

    @Test
    public void testAccessingMapValues() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.mvel.compiler;\n";
        rule = rule + "import org.drools.mvel.compiler.Pet;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  when\n";
        rule = rule + "    $pet: Pet()\n";
        rule = rule + "    Pet( \n";
        rule = rule + "      ownerName == $pet.attributes[\"key\"] \n";
        rule = rule + "    )\n";
        rule = rule + "  then\n";
        rule = rule + "    System.out.println(\"hi pet\");\n";
        rule = rule + "end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession session = kbase.newKieSession();
        Assertions.assertThat((Object)session).isNotNull();
        Pet pet1 = new Pet("Toni");
        pet1.getAttributes().put("key", "value");
        Pet pet2 = new Pet("Toni");
        session.insert((Object)pet1);
        session.insert((Object)pet2);
        session.fireAllRules();
    }

    @Test
    public void testMapOfMap() {
        String str = "package org.drools.compiler\nimport " + MapOfMapContainerBean.class.getCanonicalName() + ";\nimport java.util.Map\nrule \"test\"\nwhen\n  MapOfMapContainerBean( map['key1']['key2'] == \"ok\" )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        MapOfMapContainerBean bean = new MapOfMapContainerBean();
        Map<String, Map<String, String>> map = bean.getMap();
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("key2", "ok");
        map.put("key1", innerMap);
        ksession.insert((Object)bean);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    public static class MapOfMapContainerBean {
        private final Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();

        public Map<String, Map<String, String>> getMap() {
            return this.map;
        }
    }

    public static class MapContainerBean {
        private final Map<Integer, String> map = new HashMap<Integer, String>();

        MapContainerBean() {
            this.map.put(1, "one");
            this.map.put(2, "two");
            this.map.put(3, "three");
        }

        public Map<Integer, String> getMap() {
            return this.map;
        }

        public int get3() {
            return 3;
        }
    }
}

