/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.ClockType;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.mvel.compiler.util.debug.DebugList;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.conf.MultithreadEvaluationOption;

@RunWith(value=Parameterized.class)
public class ParallelEvaluationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ParallelEvaluationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test(timeout=40000L)
    public void test() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, ""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        EntryPointNode epn = ((InternalKnowledgeBase)kbase).getRete().getEntryPointNode(EntryPointId.DEFAULT);
        ObjectTypeNode otn = (ObjectTypeNode)epn.getObjectTypeNodes().get(new ClassObjectType(Integer.class));
        Assertions.assertThat((boolean)((CompositePartitionAwareObjectSinkAdapter)otn.getObjectSinkPropagator()).isHashed()).isTrue();
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)i);
            ksession.insert((Object)("" + i));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
    }

    @Test(timeout=40000L)
    public void testWithInsertions() {
        StringBuilder sb = new StringBuilder(4000);
        sb.append("global java.util.List list;\n");
        int ruleNr = 200;
        for (int i = 0; i < ruleNr; ++i) {
            sb.append(this.getRule(i, "insert( $i + 10 );\ninsert( \"\" + ($i + 10) );\n"));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)i);
            ksession.insert((Object)("" + i));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(ruleNr);
    }

    @Test(timeout=40000L)
    public void testWithDeletes() {
        int i;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (i = 1; i < 11; ++i) {
            sb.append(this.getRule(i, "delete( $i );\n"));
        }
        for (i = 1; i < 11; ++i) {
            sb.append(this.getNotRule(i));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i2 = 1; i2 < 11; ++i2) {
            ksession.insert((Object)i2);
            ksession.insert((Object)("" + i2));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(20);
    }

    @Test(timeout=40000L)
    public void testWithAsyncInsertions() {
        StringBuilder sb = new StringBuilder(4000);
        sb.append("global java.util.List list;\n");
        int ruleNr = 200;
        for (int i = 0; i < ruleNr; ++i) {
            sb.append(this.getRule(i, "insertAsync( $i + 10 );\ninsertAsync( \"\" + ($i + 10) );\n"));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        StatefulKnowledgeSessionImpl session = (StatefulKnowledgeSessionImpl)ksession;
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i = 0; i < 10; ++i) {
            session.insertAsync((Object)i);
            session.insertAsync((Object)("" + i));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(ruleNr);
    }

    private String getRule(int i, String rhs) {
        return this.getRule(i, rhs, "");
    }

    private String getRule(int i, String rhs, String attributes) {
        return "rule R" + i + " " + attributes + "when\n    $i : Integer( intValue == " + i + " )    String( toString == $i.toString )\nthen\n    list.add($i);\n" + rhs + "end\n";
    }

    private String getNotRule(int i) {
        return "rule Rnot" + i + " when\n    String( toString == \"" + i + "\" )\n    not Integer( intValue == " + i + " )then\n    list.add(" + -i + ");\nend\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    public void testFireUntilHalt() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, ""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        CountDownLatch done = new CountDownLatch(1);
        DebugList list = new DebugList();
        list.onItemAdded = l -> {
            if (l.size() == 10) {
                ksession.halt();
                done.countDown();
            }
        };
        ksession.setGlobal("list", list);
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            for (int i = 0; i < 10; ++i) {
                ksession.insert((Object)i);
                ksession.insert((Object)("" + i));
            }
            try {
                done.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertThat((int)list.size()).isEqualTo(10);
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    @Ignore(value="this test is failing on Jenkins but not locally, we need to figure out why")
    public void testFireUntilHalt2() {
        int rulesNr = 4;
        int factsNr = 1;
        int fireNr = rulesNr * factsNr;
        String drl = "import " + A.class.getCanonicalName() + ";\nimport " + B.class.getCanonicalName() + ";\nglobal java.util.concurrent.atomic.AtomicInteger counter\nglobal java.util.concurrent.CountDownLatch done\nglobal java.util.List list;\n";
        for (int i = 0; i < rulesNr; ++i) {
            drl = drl + this.getFireUntilHaltRule(fireNr, i);
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        for (int loop = 0; loop < 10; ++loop) {
            System.out.println("Starting loop " + loop);
            KieSession ksession = kbase.newKieSession();
            Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
            CountDownLatch done = new CountDownLatch(1);
            ksession.setGlobal("done", (Object)done);
            AtomicInteger counter = new AtomicInteger(0);
            ksession.setGlobal("counter", (Object)counter);
            DebugList list = new DebugList();
            ksession.setGlobal("list", list);
            new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
            try {
                A a = new A(rulesNr + 1);
                ksession.insert((Object)a);
                for (int i = 0; i < factsNr; ++i) {
                    ksession.insert((Object)new B(rulesNr + i + 3));
                }
                try {
                    done.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assertions.assertThat((int)counter.get()).isEqualTo(fireNr);
            }
            finally {
                ksession.halt();
                ksession.dispose();
            }
            System.out.println("Loop " + loop + " terminated");
        }
    }

    private String getFireUntilHaltRule(int fireNr, int i) {
        return "rule R" + i + " when\n  A( $a : value > " + i + ")\n  B( $b : value > $a )\nthen\n  list.add( drools.getRule().getName() );  if (counter.incrementAndGet() == " + fireNr + " ) {\n    drools.halt();\n    done.countDown();\n  }\nend\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    public void testFireUntilHaltWithAsyncInsert() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, ""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        StatefulKnowledgeSessionImpl session = (StatefulKnowledgeSessionImpl)ksession;
        CountDownLatch done = new CountDownLatch(1);
        DebugList list = new DebugList();
        list.onItemAdded = l -> {
            if (l.size() == 10) {
                ksession.halt();
                done.countDown();
            }
        };
        ksession.setGlobal("list", list);
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            for (int i = 0; i < 10; ++i) {
                session.insertAsync((Object)i);
                session.insertAsync((Object)("" + i));
            }
            try {
                done.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertThat((int)list.size()).isEqualTo(10);
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    @Test(timeout=40000L)
    public void testDisableParallelismOnSinglePartition() {
        String drl = "rule R1 when\n    $i : Integer( this == 4 )    String( length > $i )\nthen end \nrule R2 when\n    $i : Integer( this == 4 )    String( length == $i )\nthen end \nrule R3 when\n    $i : Integer( this == 4 )    String( length < $i )\nthen end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        InternalWorkingMemory session = (InternalWorkingMemory)ksession;
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isFalse();
    }

    @Test(timeout=40000L)
    public void testEventsExpiration() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        sb.append("import " + MyEvent.class.getCanonicalName() + ";\n");
        sb.append("declare MyEvent @role( event ) @expires( 20ms ) @timestamp( timestamp ) end\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRuleWithEvent(i));
        }
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBaseTestConfiguration streamConfig = TestParametersUtil.getStreamInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)streamConfig, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)streamConfig, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
        sessionClock.setStartupTime(0L);
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)new MyEvent(i, (long)i * 2L));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(10L);
        sessionClock.advanceTime(29L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(5L);
        sessionClock.advanceTime(12L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
    }

    @Test(timeout=40000L)
    public void testImmediateEventsExpiration() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        sb.append("import " + MyEvent.class.getCanonicalName() + ";\n");
        sb.append("declare MyEvent @role( event ) @expires( 1ms ) @timestamp( timestamp ) end\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRuleWithEvent(i));
        }
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        KieBaseTestConfiguration streamConfig = TestParametersUtil.getStreamInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)streamConfig, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)streamConfig, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)new MyEvent(i, (long)i * 2L));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
    }

    private String getRuleWithEvent(int i) {
        return "rule R" + i + " when\n    $i : MyEvent( id == " + i + " )then\n    list.add($i);\nend\n";
    }

    private String getRuleWithEventForExpiration(int i) {
        return "rule R" + i + " when\n    $i : MyEvent( id == " + i + " )\nthen\n    list.add($i);\n    insert(" + i + ");\nend\nrule R" + i + "not when\n    Integer( this == " + i + " )\n    not MyEvent( id == " + i + " )\nthen\n    list.add(" + i + ");\nend\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    public void testFireUntilHaltWithExpiration() {
        int i;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        sb.append("import " + MyEvent.class.getCanonicalName() + ";\n");
        sb.append("declare MyEvent @role( event ) @expires( 20ms ) @timestamp( timestamp ) end\n");
        for (i = 0; i < 5; ++i) {
            sb.append(this.getRuleWithEventForExpiration(i));
        }
        sb.append("rule R_ex1\n when MyEvent(id == 100)\n then\n end\n");
        for (i = 5; i < 10; ++i) {
            sb.append(this.getRuleWithEventForExpiration(i));
        }
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBaseTestConfiguration streamConfig = TestParametersUtil.getStreamInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)streamConfig, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)streamConfig, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
        sessionClock.setStartupTime(0L);
        DebugList list = new DebugList();
        CountDownLatch done1 = new CountDownLatch(1);
        list.onItemAdded = l -> {
            if (l.size() == 10) {
                done1.countDown();
            }
        };
        ksession.setGlobal("list", list);
        for (int i2 = 0; i2 < 10; ++i2) {
            ksession.insert((Object)new MyEvent(i2, (long)i2 * 2L));
        }
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            try {
                done1.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertThat((int)list.size()).isEqualTo(10);
            list.clear();
            CountDownLatch done2 = new CountDownLatch(1);
            list.onItemAdded = l -> {
                if (l.size() == 5) {
                    done2.countDown();
                }
            };
            ksession.insert((Object)1);
            sessionClock.advanceTime(29L, TimeUnit.MILLISECONDS);
            try {
                done2.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertThat((int)list.size()).isEqualTo(5);
            list.clear();
            CountDownLatch done3 = new CountDownLatch(1);
            list.onItemAdded = l -> {
                if (l.size() == 5) {
                    done3.countDown();
                }
            };
            sessionClock.advanceTime(12L, TimeUnit.MILLISECONDS);
            try {
                done3.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertThat((int)list.size()).isEqualTo(5);
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    @Ignore(value="this test is failing on Jenkins but not locally, we need to figure out why")
    public void testFireUntilHaltWithExpiration2() throws InterruptedException {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\ndeclare A @role( event ) @expires(11ms) end\ndeclare B @role( event ) @expires(11ms) end\nglobal java.util.concurrent.atomic.AtomicInteger counter;\nglobal java.util.concurrent.CountDownLatch fireLatch;\nrule R0 when\n  $A: A( $Aid : value > 0 )\n  $B: B( ($Bid: value <= $Aid) && (value > ($Aid - 1 )))\nthen\n  counter.incrementAndGet();\n  fireLatch.countDown();end\nrule R1 when\n  $A: A( $Aid: value > 1 )\n  $B: B( ($Bid: value <= $Aid) && (value > ($Aid - 1 )))\nthen\n  counter.incrementAndGet();\n  fireLatch.countDown();end\nrule R2 when\n  $A: A( $Aid: value > 2 )\n  $B: B( ($Bid: value <= $Aid) && (value > ($Aid - 1 )))\nthen\n  counter.incrementAndGet();\n  fireLatch.countDown();end\nrule R3 when\n  $A: A( $Aid: value > 3 )\n  $B: B( ($Bid: value <= $Aid) && (value > ($Aid - 1 )))\nthen\n  counter.incrementAndGet();\n  fireLatch.countDown();end";
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBaseTestConfiguration streamConfig = TestParametersUtil.getStreamInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)streamConfig, (String[])new String[]{drl});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)streamConfig, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        try {
            Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(0L);
            AtomicInteger counter = new AtomicInteger(0);
            ksession.setGlobal("counter", (Object)counter);
            new Thread(() -> ksession.fireUntilHalt()).start();
            int eventsNr = 5;
            CountDownLatch fireLatch = new CountDownLatch(eventsNr * 4);
            ksession.setGlobal("fireLatch", (Object)fireLatch);
            for (int i = 0; i < eventsNr; ++i) {
                ksession.insert((Object)new A(i + 4));
                ksession.insert((Object)new B(i + 4));
                sessionClock.advanceTime(10L, TimeUnit.MILLISECONDS);
            }
            fireLatch.await();
            Assertions.assertThat((int)counter.get()).isEqualTo(eventsNr * 4);
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    @Test(timeout=40000L)
    public void testWithUpdates() {
        int i;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i2 = 0; i2 < 10; ++i2) {
            sb.append(this.getRule(i2, ""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        FactHandle[] fhs = new FactHandle[10];
        for (i = 0; i < 10; ++i) {
            fhs[i] = ksession.insert((Object)i);
            ksession.insert((Object)("" + i));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
        list.clear();
        for (i = 0; i < 10; ++i) {
            ksession.update(fhs[i], (Object)i);
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
    }

    @Test(timeout=40000L)
    public void testDisableParallelismWithAgendaGroups() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        sb.append("rule first\nwhen\nthen\n    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup(\"agenda\").setFocus();\nend\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, "", "agenda-group \"agenda\""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isFalse();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)i);
            ksession.insert((Object)("" + i));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
    }

    @Test(timeout=40000L)
    public void testDisableParallelismWithSalience() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, "", "salience " + i));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isFalse();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)i);
            ksession.insert((Object)("" + i));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
        Assertions.assertThat(Arrays.asList(9, 8, 7, 6, 5, 4, 3, 2, 1, 0)).isEqualTo(list);
    }

    @Test(timeout=40000L)
    public void testMultipleParallelKieSessionsWithInsertions() throws InterruptedException, ExecutionException, TimeoutException {
        int NUMBER_OF_PARALLEL_SESSIONS = 5;
        StringBuilder sb = new StringBuilder();
        sb.append("global java.util.List list;\n");
        int ruleNr = 200;
        for (int i = 0; i < 200; ++i) {
            sb.append(this.getRule(i, "insert( $i + 10 );\ninsert( \"\" + ($i + 10) );\n"));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < 5; ++i) {
            tasks.add(this.getMultipleParallelKieSessionsWithInsertionsCallable(kBase, 200));
        }
        this.runTasksInParallel(tasks);
    }

    private Callable<Void> getMultipleParallelKieSessionsWithInsertionsCallable(final KieBase kBase, final int ruleNr) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                KieSession ksession = kBase.newKieSession();
                Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
                DebugList list = new DebugList();
                ksession.setGlobal("list", list);
                ParallelEvaluationTest.this.insertFacts(ksession, 10);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(ruleNr);
                return null;
            }
        };
    }

    @Test(timeout=40000L)
    public void testMultipleParallelKieSessionsWithUpdates() throws InterruptedException, ExecutionException, TimeoutException {
        int NUMBER_OF_PARALLEL_SESSIONS = 5;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, ""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < 5; ++i) {
            tasks.add(this.getMultipleParallelKieSessionsWithUpdatesCallable(kBase));
        }
        this.runTasksInParallel(tasks);
    }

    private Callable<Void> getMultipleParallelKieSessionsWithUpdatesCallable(final KieBase kBase) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                KieSession ksession = kBase.newKieSession();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).as("Parallel agenda has to be enabled", new Object[0])).isTrue();
                DebugList list = new DebugList();
                ksession.setGlobal("list", list);
                FactHandle[] fhs = new FactHandle[10];
                fhs = ParallelEvaluationTest.this.insertFacts(ksession, 10);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(10);
                list.clear();
                for (int i = 0; i < 10; ++i) {
                    ksession.update(fhs[i], (Object)i);
                }
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(10);
                return null;
            }
        };
    }

    @Test(timeout=40000L)
    public void testMultipleParallelKieSessionsWithDeletes() throws InterruptedException, ExecutionException, TimeoutException {
        int i;
        int NUMBER_OF_PARALLEL_SESSIONS = 5;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (i = 1; i < 11; ++i) {
            sb.append(this.getRule(i, "delete( $i );\n"));
        }
        for (i = 1; i < 11; ++i) {
            sb.append(this.getNotRule(i));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i2 = 0; i2 < 5; ++i2) {
            tasks.add(this.getMultipleParallelKieSessionsWithDeletesCallable(kbase));
        }
        this.runTasksInParallel(tasks);
    }

    private Callable<Void> getMultipleParallelKieSessionsWithDeletesCallable(final KieBase kbase) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                KieSession ksession = kbase.newKieSession();
                Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
                DebugList list = new DebugList();
                ksession.setGlobal("list", list);
                ParallelEvaluationTest.this.insertFacts(ksession, 11);
                ksession.fireAllRules();
                Assertions.assertThat((Iterable)ksession.getObjects()).isEmpty();
                Assertions.assertThat((int)list.size()).isEqualTo(20);
                return null;
            }
        };
    }

    @Test(timeout=40000L)
    public void testMultipleParallelKieSessionsFireUntilHalt() throws InterruptedException, ExecutionException, TimeoutException {
        int NUMBER_OF_PARALLEL_SESSIONS = 5;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, ""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < 5; ++i) {
            tasks.add(this.getMultipleParallelKieSessionsFireUntilHaltCallable(kbase, false));
        }
        this.runTasksInParallel(tasks);
    }

    private Callable<Void> getMultipleParallelKieSessionsFireUntilHaltCallable(KieBase kBase, boolean asyncInsert) {
        return () -> {
            KieSession ksession = kBase.newKieSession();
            Assertions.assertThat((boolean)((InternalWorkingMemory)ksession).getAgenda().isParallelAgenda()).isTrue();
            CountDownLatch done = new CountDownLatch(1);
            DebugList list = new DebugList();
            list.onItemAdded = l -> {
                if (l.size() == 10) {
                    ksession.halt();
                    done.countDown();
                }
            };
            ksession.setGlobal("list", list);
            new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
            if (asyncInsert) {
                StatefulKnowledgeSessionImpl session = (StatefulKnowledgeSessionImpl)ksession;
                for (int i = 0; i < 10; ++i) {
                    session.insertAsync((Object)i);
                    session.insertAsync((Object)("" + String.valueOf(i)));
                }
            } else {
                this.insertFacts(ksession, 10);
            }
            try {
                done.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertThat((int)list.size()).isEqualTo(10);
            return null;
        };
    }

    @Test(timeout=40000L)
    public void testMultipleParallelKieSessionsFireUntilHaltWithAsyncInsert() throws InterruptedException, ExecutionException, TimeoutException {
        int NUMBER_OF_PARALLEL_SESSIONS = 5;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i = 0; i < 10; ++i) {
            sb.append(this.getRule(i, ""));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{MultithreadEvaluationOption.YES});
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < 5; ++i) {
            tasks.add(this.getMultipleParallelKieSessionsFireUntilHaltCallable(kbase, true));
        }
        this.runTasksInParallel(tasks);
    }

    private FactHandle[] insertFacts(KieSession ksession, int n) {
        FactHandle[] fhs = new FactHandle[n];
        for (int i = 0; i < n; ++i) {
            fhs[i] = ksession.insert((Object)i);
            ksession.insert((Object)String.valueOf(i));
        }
        return fhs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasksInParallel(List<Callable<Void>> tasks) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(tasks.size());
        try {
            List<Future<Void>> futures = executorService.invokeAll(tasks);
            Assertions.assertThat((int)futures.size()).isEqualTo(tasks.size());
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public static class MyEvent {
        private final int id;
        private final long timestamp;

        public MyEvent(int id, long timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "MyEvent[" + this.id + "]";
        }
    }

    public static class B {
        private int value;

        public B(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class A {
        private int value;

        public A(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

