/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.EntryPointId;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PathEndNodeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PathEndNodeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSubNetworkSharing() throws Exception {
        String str = "package org.test \nrule xxx \nwhen \n  $s : String()\n  not( Integer() and Long() )\nthen \nend  \nrule yyy \nwhen \n  $s : String()\n  not( Integer() and Long() )\nthen \nend  \n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        EntryPointNode epn = kbase.getRete().getEntryPointNode(EntryPointId.DEFAULT);
        ObjectTypeNode otn = (ObjectTypeNode)epn.getObjectTypeNodes().get(new ClassObjectType(Long.class));
        BetaNode beta1 = (BetaNode)otn.getObjectSinkPropagator().getSinks()[0];
        RightInputAdapterNode rian = (RightInputAdapterNode)beta1.getSinkPropagator().getSinks()[0];
        BetaNode beta2 = (BetaNode)rian.getObjectSinkPropagator().getSinks()[0];
        LeftTupleSink[] sinks = beta2.getSinkPropagator().getSinks();
        RuleTerminalNode rtn1 = (RuleTerminalNode)sinks[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)sinks[1];
        Assertions.assertThat((int)rian.getPathEndNodes().length).isEqualTo(3);
        Assertions.assertThat((boolean)Arrays.asList(rian.getPathEndNodes()).containsAll(Arrays.asList(rtn1, rtn2, rian))).isTrue();
        kbase.removeRule("org.test", "xxx");
        Assertions.assertThat((int)rian.getPathEndNodes().length).isEqualTo(2);
        RuleTerminalNode remainingRTN = rtn1.getRule().getName().equals("yyy") ? rtn1 : rtn2;
        Assertions.assertThat((boolean)Arrays.asList(rian.getPathEndNodes()).containsAll(Arrays.asList(remainingRTN, rian))).isTrue();
    }
}

