/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.mvel.integrationtests.LinkingTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class SegmentCreationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SegmentCreationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSingleEmptyLhs() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" ");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, InitialFactImpl.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem.getRootNode()).isEqualTo((Object)liaNode);
        Assertions.assertThat((Object)smem.getTipNode()).isEqualTo((Object)rtn);
        Assertions.assertThat((Object)smem.getNext()).isNull();
        Assertions.assertThat((Object)((SegmentMemory)smem.getFirst())).isNull();
    }

    @Test
    public void testSingleSharedEmptyLhs() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" ", " ");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, InitialFactImpl.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[1];
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem.getRootNode()).isEqualTo((Object)liaNode);
        Assertions.assertThat((Object)smem.getTipNode()).isEqualTo((Object)liaNode);
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assertions.assertThat((Object)rtnSmem1.getRootNode()).isEqualTo((Object)rtn1);
        Assertions.assertThat((Object)rtnSmem1.getTipNode()).isEqualTo((Object)rtn1);
        SegmentMemory rtnSmem2 = rtnSmem1.getNext();
        Assertions.assertThat((Object)rtnSmem2.getRootNode()).isEqualTo((Object)rtn2);
        Assertions.assertThat((Object)rtnSmem2.getTipNode()).isEqualTo((Object)rtn2);
    }

    @Test
    public void testSinglePattern() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("   A() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem).isNull();
    }

    @Test
    public void testSingleSharedPattern() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("   A() B()\n", "   A() B()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode beta = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[1];
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.fireAllRules();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem.getRootNode()).isEqualTo((Object)liaNode);
        Assertions.assertThat((Object)smem.getTipNode()).isEqualTo((Object)beta);
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assertions.assertThat((Object)rtnSmem1.getRootNode()).isEqualTo((Object)rtn1);
        Assertions.assertThat((Object)rtnSmem1.getTipNode()).isEqualTo((Object)rtn1);
        SegmentMemory rtnSmem2 = rtnSmem1.getNext();
        Assertions.assertThat((Object)rtnSmem2.getRootNode()).isEqualTo((Object)rtn2);
        Assertions.assertThat((Object)rtnSmem2.getTipNode()).isEqualTo((Object)rtn2);
    }

    @Test
    public void testMultiSharedPattern() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" X() A() \n", "  X()  A() B() \n", "  X() A() B() C() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode dotn = this.getObjectTypeNode(kbase, LinkingTest.X.class);
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)dotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode beta = (JoinNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)beta.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn2 = (RuleTerminalNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn3 = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        BetaMemory betaMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)beta);
        SegmentMemory smem = betaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem.getRootNode()).isEqualTo((Object)lian);
        Assertions.assertThat((Object)smem.getTipNode()).isEqualTo((Object)beta);
        Assertions.assertThat((Object)((SegmentMemory)smem.getFirst())).isNull();
        Assertions.assertThat((Object)smem.getNext()).isNull();
        wm.fireAllRules();
        wm.flushPropagations();
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assertions.assertThat((Object)rtnSmem1.getRootNode()).isEqualTo((Object)rtn1);
        Assertions.assertThat((Object)rtnSmem1.getTipNode()).isEqualTo((Object)rtn1);
        SegmentMemory bSmem = rtnSmem1.getNext();
        Assertions.assertThat((Object)bSmem.getRootNode()).isEqualTo((Object)bNode);
        Assertions.assertThat((Object)bSmem.getTipNode()).isEqualTo((Object)bNode);
        SegmentMemory rtnSmem2 = (SegmentMemory)bSmem.getFirst();
        Assertions.assertThat((Object)rtnSmem2.getRootNode()).isEqualTo((Object)rtn2);
        Assertions.assertThat((Object)rtnSmem2.getTipNode()).isEqualTo((Object)rtn2);
        SegmentMemory cSmem = rtnSmem2.getNext();
        Assertions.assertThat((Object)cSmem.getRootNode()).isEqualTo((Object)cNode);
        Assertions.assertThat((Object)cSmem.getTipNode()).isEqualTo((Object)rtn3);
    }

    @Test
    public void testSubnetworkNoSharing() throws Exception {
        KieBase kbase = this.buildKnowledgeBase(" A()  not ( B() and C() ) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode = (RightInputAdapterNode)cNode.getSinkPropagator().getSinks()[0];
        NotNode notNode = (NotNode)liaNode.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn1 = (RuleTerminalNode)notNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem.getRootNode()).isEqualTo((Object)liaNode);
        Assertions.assertThat((Object)smem.getTipNode()).isEqualTo((Object)liaNode);
        Assertions.assertThat((Object)smem.getNext()).isNull();
        smem = (SegmentMemory)smem.getFirst();
        SegmentMemory bSmem = wm.getNodeMemory((MemoryFactory)bNode).getSegmentMemory();
        Assertions.assertThat((Object)bSmem).isEqualTo((Object)smem);
        Assertions.assertThat((Object)bSmem.getRootNode()).isEqualTo((Object)bNode);
        Assertions.assertThat((Object)bSmem.getTipNode()).isEqualTo((Object)riaNode);
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)notNode);
        Assertions.assertThat((Object)smem.getNext()).isEqualTo((Object)bm.getSegmentMemory());
        Assertions.assertThat((Object)bm.getRiaRuleMemory().getSegmentMemory()).isEqualTo((Object)bSmem);
    }

    @Test
    public void tesSubnetworkAfterShare() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("  X() A() \n", "   X() A()  not ( B() and C() ) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        ObjectTypeNode dotn = this.getObjectTypeNode(kbase, LinkingTest.X.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)dotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode joinNode = (JoinNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)joinNode.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)joinNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode = (RightInputAdapterNode)cNode.getSinkPropagator().getSinks()[0];
        NotNode notNode = (NotNode)joinNode.getSinkPropagator().getSinks()[2];
        RuleTerminalNode rtn2 = (RuleTerminalNode)notNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.fireAllRules();
        BetaMemory liaMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem.getRootNode()).isEqualTo((Object)lian);
        Assertions.assertThat((Object)smem.getTipNode()).isEqualTo((Object)joinNode);
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assertions.assertThat((Object)rtnSmem1.getRootNode()).isEqualTo((Object)rtn1);
        Assertions.assertThat((Object)rtnSmem1.getTipNode()).isEqualTo((Object)rtn1);
        SegmentMemory bSmem = rtnSmem1.getNext();
        Assertions.assertThat((Object)bSmem.getRootNode()).isEqualTo((Object)bNode);
        Assertions.assertThat((Object)bSmem.getTipNode()).isEqualTo((Object)riaNode);
        SegmentMemory notSmem = bSmem.getNext();
        Assertions.assertThat((Object)notSmem.getRootNode()).isEqualTo((Object)notNode);
        Assertions.assertThat((Object)notSmem.getTipNode()).isEqualTo((Object)rtn2);
        Assertions.assertThat((Object)((SegmentMemory)bSmem.getFirst())).isNull();
    }

    @Test
    public void tesShareInSubnetwork() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("  X() A() \n", "   X() A() B() C() \n", "   X() A()  not ( B() and C() ) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        ObjectTypeNode dotn = this.getObjectTypeNode(kbase, LinkingTest.X.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)dotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode beta = (JoinNode)aotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)beta.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode = (RightInputAdapterNode)cNode.getSinkPropagator().getSinks()[1];
        NotNode notNode = (NotNode)beta.getSinkPropagator().getSinks()[2];
        RuleTerminalNode rtn3 = (RuleTerminalNode)notNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.insert((Object)new LinkingTest.B());
        wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)lian);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((Object)smem.getRootNode()).isEqualTo((Object)lian);
        Assertions.assertThat((Object)smem.getTipNode()).isEqualTo((Object)beta);
        Assertions.assertThat((Object)((SegmentMemory)smem.getFirst())).isNull();
        wm.fireAllRules();
        SegmentMemory rtnSmem1 = (SegmentMemory)smem.getFirst();
        Assertions.assertThat((Object)rtnSmem1.getRootNode()).isEqualTo((Object)rtn1);
        Assertions.assertThat((Object)rtnSmem1.getTipNode()).isEqualTo((Object)rtn1);
        SegmentMemory bSmem = rtnSmem1.getNext();
        Assertions.assertThat((Object)bSmem.getRootNode()).isEqualTo((Object)bNode);
        Assertions.assertThat((Object)bSmem.getTipNode()).isEqualTo((Object)cNode);
        SegmentMemory rtn2Smem = (SegmentMemory)bSmem.getFirst();
        Assertions.assertThat((Object)rtn2Smem.getRootNode()).isEqualTo((Object)rtn2);
        Assertions.assertThat((Object)rtn2Smem.getTipNode()).isEqualTo((Object)rtn2);
        SegmentMemory riaSmem = rtn2Smem.getNext();
        Assertions.assertThat((Object)riaSmem.getRootNode()).isEqualTo((Object)riaNode);
        Assertions.assertThat((Object)riaSmem.getTipNode()).isEqualTo((Object)riaNode);
        SegmentMemory notSmem = bSmem.getNext();
        Assertions.assertThat((Object)notSmem.getRootNode()).isEqualTo((Object)notNode);
        Assertions.assertThat((Object)notSmem.getTipNode()).isEqualTo((Object)rtn3);
    }

    @Test
    public void testBranchCESingleSegment() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("   $a : A() \n   if ( $a != null ) do[t1] \n   B() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        ConditionalBranchNode cen1Node = (ConditionalBranchNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)cen1Node.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)bNode.getSinkPropagator().getSinks()[0];
        FactHandle bFh = wm.insert((Object)new LinkingTest.B());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory smem = liaMem.getSegmentMemory();
        Assertions.assertThat((long)smem.getAllLinkedMaskTest()).isEqualTo(1L);
        Assertions.assertThat((long)smem.getLinkedNodeMask()).isEqualTo(4L);
        Assertions.assertThat((boolean)smem.isSegmentLinked()).isFalse();
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        Assertions.assertThat((long)pmem.getAllLinkedMaskTest()).isEqualTo(1L);
        Assertions.assertThat((long)pmem.getLinkedSegmentMask()).isEqualTo(0L);
        Assertions.assertThat((boolean)pmem.isRuleLinked()).isFalse();
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        Assertions.assertThat((long)smem.getLinkedNodeMask()).isEqualTo(5L);
        Assertions.assertThat((boolean)smem.isSegmentLinked()).isTrue();
        Assertions.assertThat((long)pmem.getLinkedSegmentMask()).isEqualTo(1L);
        Assertions.assertThat((boolean)pmem.isRuleLinked()).isTrue();
        wm.delete(bFh);
        wm.flushPropagations();
        Assertions.assertThat((long)pmem.getLinkedSegmentMask()).isEqualTo(1L);
        Assertions.assertThat((boolean)pmem.isRuleLinked()).isTrue();
    }

    @Test
    public void testBranchCEMultipleSegments() throws Exception {
        KieBase kbase = this.buildKnowledgeBase("  X() $a : A() \n", "  X()  $a : A() \n   if ( $a != null ) do[t1] \n   B() \n", "  X() $a : A() \n   if ( $a != null ) do[t1] \n   B() \n   C() \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase, LinkingTest.A.class);
        LeftTupleSource liaNode = (LeftTupleSource)aotn.getObjectSinkPropagator().getSinks()[0];
        ConditionalBranchNode cen1Node = (ConditionalBranchNode)liaNode.getSinkPropagator().getSinks()[1];
        JoinNode bNode = (JoinNode)cen1Node.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[1];
        RuleTerminalNode rtn3 = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        FactHandle bFh = wm.insert((Object)new LinkingTest.B());
        FactHandle cFh = wm.insert((Object)new LinkingTest.C());
        wm.flushPropagations();
        BetaMemory bNodeBm = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode);
        SegmentMemory bNodeSmem = bNodeBm.getSegmentMemory();
        Assertions.assertThat((long)bNodeSmem.getAllLinkedMaskTest()).isEqualTo(0L);
        Assertions.assertThat((long)bNodeSmem.getLinkedNodeMask()).isEqualTo(2L);
        PathMemory pmemr2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        Assertions.assertThat((long)pmemr2.getAllLinkedMaskTest()).isEqualTo(1L);
        Assertions.assertThat((long)pmemr2.getLinkedSegmentMask()).isEqualTo(2L);
        Assertions.assertThat((int)pmemr2.getSegmentMemories().length).isEqualTo(3);
        Assertions.assertThat((boolean)pmemr2.isRuleLinked()).isFalse();
        PathMemory pmemr3 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn3);
        Assertions.assertThat((long)pmemr3.getAllLinkedMaskTest()).isEqualTo(1L);
        Assertions.assertThat((int)pmemr3.getSegmentMemories().length).isEqualTo(3);
        Assertions.assertThat((boolean)pmemr3.isRuleLinked()).isFalse();
        BetaMemory cNodeBm = (BetaMemory)wm.getNodeMemory((MemoryFactory)cNode);
        SegmentMemory cNodeSmem = cNodeBm.getSegmentMemory();
        Assertions.assertThat((long)cNodeSmem.getAllLinkedMaskTest()).isEqualTo(1L);
        Assertions.assertThat((long)cNodeSmem.getLinkedNodeMask()).isEqualTo(1L);
        wm.insert((Object)new LinkingTest.X());
        wm.insert((Object)new LinkingTest.A());
        wm.flushPropagations();
        Assertions.assertThat((boolean)pmemr2.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)pmemr3.isRuleLinked()).isTrue();
        wm.delete(bFh);
        wm.delete(cFh);
        wm.flushPropagations();
        Assertions.assertThat((long)pmemr2.getLinkedSegmentMask()).isEqualTo(3L);
        Assertions.assertThat((boolean)pmemr2.isRuleLinked()).isTrue();
        Assertions.assertThat((long)pmemr3.getLinkedSegmentMask()).isEqualTo(3L);
        Assertions.assertThat((boolean)pmemr3.isRuleLinked()).isTrue();
    }

    private KieBase buildKnowledgeBase(String ... rules) {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + LinkingTest.A.class.getCanonicalName() + "\n";
        str = str + "import " + LinkingTest.B.class.getCanonicalName() + "\n";
        str = str + "import " + LinkingTest.C.class.getCanonicalName() + "\n";
        str = str + "import " + LinkingTest.X.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        int i = 0;
        for (String lhs : rules) {
            str = str + "rule rule" + i++ + "  when \n";
            str = str + lhs;
            str = str + "then \n";
            str = str + "then[t1] \n";
            str = str + "end \n";
        }
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        return kbase;
    }

    public ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }
}

