/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import org.assertj.core.api.Assertions;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.reteoo.ReteComparator;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class MarshallingIssuesTest
extends CommonTestMethodBase {
    @Test
    public void testJBRULES_1946() {
        KieBase kbase = this.loadKnowledgeBase("../Sample.drl");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KieBase kieBase = (KieBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            Assertions.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_2() {
        KieBase kbase = this.loadKnowledgeBase("../Sample.drl");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            DroolsObjectInputStream ois = new DroolsObjectInputStream((InputStream)bais);
            KieBase kieBase = (KieBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            Assertions.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_3() {
        KieBase kbase = this.loadKnowledgeBase("../Sample.drl");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KieBase kb2 = (KieBase)ois.readObject();
            Assertions.fail((String)"Should have raised an IllegalArgumentException since the kbase was serialized with a Drools Stream but deserialized with a regular stream");
        }
        catch (IllegalArgumentException baos) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_2331() throws Exception {
        String source = "package test.drl\n";
        source = source + "rule dummy_rule\n";
        source = source + "when\n";
        source = source + "eval( false )\n";
        source = source + "then\n";
        source = source + "end\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(source);
        KieSession ksession = kbase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Assertions.assertThat((Object)ksession).isNotNull();
        ksession.dispose();
    }

    @Test
    public void testMarshallWithAccumulate() throws Exception {
        String drl1 = "import java.util.concurrent.atomic.AtomicInteger\nglobal java.util.List list;\nrule R when\n  $a : AtomicInteger( get() > 3 )\n  $i : Integer( this == $a.get() )\n  accumulate ( $s : String( length == $i ), $result : count( ) )\nthen\n  list.add($result);\nend";
        KieBase kb1 = new KieHelper().addContent(drl1, ResourceType.DRL).build(new KieBaseOption[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
        oos.writeObject((Object)kb1);
        oos.flush();
        oos.close();
        baos.flush();
        baos.close();
        byte[] serializedKb = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
        DroolsObjectInputStream ois = new DroolsObjectInputStream((InputStream)bais);
        ois.close();
        bais.close();
        KieBase kb2 = (KieBase)ois.readObject();
        Assertions.assertThat((boolean)ReteComparator.areEqual((KieBase)kb1, (KieBase)kb2)).isTrue();
    }
}

