/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.mvel.integrationtests.phreak.A;
import org.drools.mvel.integrationtests.phreak.B;
import org.drools.mvel.integrationtests.phreak.C;
import org.drools.mvel.integrationtests.phreak.E;
import org.drools.mvel.integrationtests.phreak.X;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.rule.Match;

@RunWith(value=Parameterized.class)
public class AddRuleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AddRuleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testPopulatedSingleRuleNoSharing() {
        KieServices ks = KieServices.get();
        KieContainer kieContainer = KieUtil.getKieContainerFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, (String[])new String[0]);
        InternalWorkingMemory wm = (InternalWorkingMemory)kieContainer.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        String rule = this.buildKnowledgePackageDrl("r1", "   A() B() C(object == 2) X() E()\n");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "testPopulatedSingleRuleNoSharing", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{rule});
        kieContainer.updateToVersion(releaseId2);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ObjectTypeNode aotn = this.getObjectTypeNode(wm.getKnowledgeBase().getRete(), A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
    }

    @Test
    public void testPopulatedSingleRuleNoSharingWithSubnetworkAtStart() throws Exception {
        KieServices ks = KieServices.get();
        KieContainer kieContainer = KieUtil.getKieContainerFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, (String[])new String[0]);
        InternalWorkingMemory wm = (InternalWorkingMemory)kieContainer.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.insert((Object)new C(2));
        wm.fireAllRules();
        String rule = this.buildKnowledgePackageDrl("r1", "   A() not( B() and C() ) X() E()\n");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "testPopulatedSingleRuleNoSharingWithSubnetworkAtStart", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{rule});
        kieContainer.updateToVersion(releaseId2);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ObjectTypeNode aotn = this.getObjectTypeNode(wm.getKnowledgeBase().getRete(), A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        SegmentMemory subSm = (SegmentMemory)sm.getFirst();
        SegmentMemory mainSm = subSm.getNext();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
    }

    @Test
    public void testPopulatedRuleMidwayShare() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a : A() B() C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B() C(2;) X() E()\n"));
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)bNode.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm.getFirst());
        Assertions.assertThat((int)c1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c1Mem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        Assertions.assertThat((Object)c2Mem.getSegmentMemory()).isSameAs((Object)c2Smem);
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(3)).getDeclarationValue("a")).getObject()).isEqualTo((Object)3);
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(4)).getDeclarationValue("a")).getObject()).isEqualTo((Object)2);
        Assertions.assertThat((String)((Match)list.get(5)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(5)).getDeclarationValue("a")).getObject()).isEqualTo((Object)1);
    }

    @Test
    public void testPopulatedRuleWithEvals() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a:A() B() eval(1==1) eval(1==1) C(1;) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a:A() B() eval(1==1) eval(1==1) C(2;) \n"));
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e1 = (EvalConditionNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e2 = (EvalConditionNode)e1.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)e2.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)e2.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm.getFirst());
        Assertions.assertThat((int)c1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c1Mem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        Assertions.assertThat((Object)c2Mem.getSegmentMemory()).isSameAs((Object)c2Smem);
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(3)).getDeclarationValue("a")).getObject()).isEqualTo((Object)3);
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(4)).getDeclarationValue("a")).getObject()).isEqualTo((Object)2);
        Assertions.assertThat((String)((Match)list.get(5)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(5)).getDeclarationValue("a")).getObject()).isEqualTo((Object)1);
    }

    @Test
    public void testPopulatedSharedLiaNode() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B(1;) C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new B(2));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B(2;) C() X() E()\n"));
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode1 = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode bNode2 = (JoinNode)liaNode.getSinkPropagator().getLastLeftTupleSink();
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode2);
        SegmentMemory sm = bm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((String)((Match)list.get(5)).getRule().getName()).isEqualTo("r2");
        ArrayList<Object> results = new ArrayList<Object>();
        results.add(((A)((Match)list.get(3)).getDeclarationValue("a")).getObject());
        results.add(((A)((Match)list.get(4)).getDeclarationValue("a")).getObject());
        results.add(((A)((Match)list.get(5)).getDeclarationValue("a")).getObject());
        Assertions.assertThat((boolean)results.containsAll(Arrays.asList(1, 2, 3))).isTrue();
    }

    @Test
    public void testPopulatedSharedToRtn() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B() C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A() B() C() X() E()\n"));
        ObjectTypeNode eotn = this.getObjectTypeNode((KieBase)kbase1, E.class);
        JoinNode eNode = (JoinNode)eotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)eNode.getSinkPropagator().getLastLeftTupleSink();
        PathMemory pm = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        SegmentMemory sm = pm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
    }

    @Test
    public void testPopulatedMultipleShares() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new B(2));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        wm.fireAllRules();
        System.out.println(list);
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r3");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r2");
    }

    @Test
    public void testSplitTwoBeforeCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new E(1));
        wm.insert((Object)new E(2));
        wm.flushPropagations();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", (KieBase)kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", (KieBase)kbase1);
        RuleTerminalNode rtn3 = this.getRtn("org.kie.r3", (KieBase)kbase1);
        RuleTerminalNode rtn4 = this.getRtn("org.kie.r4", (KieBase)kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        SegmentMemory sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(4L);
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) \n"));
        smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(5);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[2]).isNull();
        sm = smems[3];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(3);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(8L);
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", (KieBase)kbase1);
        PathMemory pm5 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn5);
        smems = pm5.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(2);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
    }

    @Test
    public void testSplitOneBeforeCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new X(1));
        wm.insert((Object)new X(2));
        wm.flushPropagations();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", (KieBase)kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", (KieBase)kbase1);
        RuleTerminalNode rtn3 = this.getRtn("org.kie.r3", (KieBase)kbase1);
        RuleTerminalNode rtn4 = this.getRtn("org.kie.r4", (KieBase)kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[2]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        SegmentMemory sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(2L);
        PathMemory pm3 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn3);
        SegmentMemory[] smemsP3 = pm3.getSegmentMemories();
        Assertions.assertThat((int)smemsP3.length).isEqualTo(3);
        Assertions.assertThat((Object)smemsP3[0]).isNull();
        Assertions.assertThat((Object)smemsP3[2]).isNull();
        sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(2L);
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) \n"));
        smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(5);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        Assertions.assertThat((Object)smems[4]).isNull();
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(4L);
        smems = pm3.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(4L);
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", (KieBase)kbase1);
        PathMemory pm5 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn5);
        smems = pm5.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(2);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
    }

    @Test
    public void testSplitOnCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new X(1));
        wm.insert((Object)new X(2));
        wm.insert((Object)new X(3));
        wm.flushPropagations();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", (KieBase)kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(2L);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[2]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        SegmentMemory sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(3;)\n"));
        wm.fireAllRules();
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(6L);
        smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(5);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        Assertions.assertThat((Object)smems[4]).isNull();
        sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", (KieBase)kbase1);
        PathMemory pm5 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn5);
        Assertions.assertThat((long)pm5.getLinkedSegmentMask()).isEqualTo(6L);
        smems = pm5.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(3);
        Assertions.assertThat((Object)smems[0]).isNull();
        sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
    }

    private RuleTerminalNode getRtn(String ruleName, KieBase kbase) {
        return (RuleTerminalNode)((KnowledgeBaseImpl)kbase).getReteooBuilder().getTerminalNodes(ruleName)[0];
    }

    private InternalKnowledgeBase buildKnowledgeBase(String ruleName, String rule) {
        return (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.buildKnowledgePackageDrl(ruleName, rule)});
    }

    private String buildKnowledgePackageDrl(String ruleName, String rule) {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule " + ruleName + "  when \n";
        str = str + rule;
        str = str + "then \n";
        str = str + " list.add( kcontext.getMatch() );\n";
        str = str + "end \n";
        return str;
    }

    private Collection<KiePackage> buildKnowledgePackage(String ruleName, String rule) {
        return KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.buildKnowledgePackageDrl(ruleName, rule)}).getKiePackages();
    }

    public ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        return this.getObjectTypeNode(((KnowledgeBaseImpl)kbase).getRete(), nodeClass);
    }

    public ObjectTypeNode getObjectTypeNode(Rete rete, Class<?> nodeClass) {
        List nodes = rete.getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (n.getObjectType().getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }
}

