/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalFactHandle;
import org.drools.mvel.integrationtests.phreak.A;
import org.drools.mvel.integrationtests.phreak.B;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class PhreakLiaNodeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PhreakLiaNodeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void test() {
        String str = "package org.drools.mvel.compiler.test\n\nimport " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\n\nglobal java.util.List result;\nrule r1 \n    when \n        $a : A( object == 1 )\n    then \n        System.out.println( $a ); \n        result.add(kcontext.getRule().getName());\nend \nrule r2 \n    when \n        $a : A( object == 2 )\n    then \n        System.out.println( $a ); \n        result.add(kcontext.getRule().getName());\nend \n rule r3 \n    when \n        $a : A( object == 2 )\n        $b : B( )\n    then \n        System.out.println( $a ); \n        result.add(kcontext.getRule().getName());\nend \n rule r4 \n    when \n        $a : A( object == 3 )\n    then \n        System.out.println( $a ); \n        result.add(kcontext.getRule().getName());\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList<String> result = new ArrayList<String>();
        ksession.setGlobal("result", result);
        InternalFactHandle fhB = (InternalFactHandle)ksession.insert((Object)B.b((Object)1));
        InternalFactHandle fhA = (InternalFactHandle)ksession.insert((Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---1---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---2---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)2));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r2", "r3");
        System.out.println("---3---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)2));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r2", "r3");
        System.out.println("---4---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)3));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r4");
        System.out.println("---5---");
        ksession.update((FactHandle)fhB, (Object)B.b((Object)1));
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)3));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r4");
        System.out.println("---6---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---7---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---8---");
        ksession.dispose();
    }

    private void assertFiredRules(List<String> result, String ... ruleNames) {
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])ruleNames);
        result.clear();
    }

    @Test
    public void test2() {
        String str = "package org.drools.mvel.compiler.test\n\nimport " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\n\nglobal java.util.List result;\nrule r1 \n    when \n        $a : A( object == 1 )\n    then \n        System.out.println( $a ); \n        result.add(kcontext.getRule().getName());\nend \nrule r2 \n    when \n        $a : A( object == 2 )\n    then \n        System.out.println( $a ); \n        result.add(kcontext.getRule().getName());\nend \n rule r3 \n    when \n        $a : A( object == 2 )\n        $b : B( )\n    then \n        System.out.println( $a + \" : \" + $b  );        result.add(kcontext.getRule().getName());\n        modify($a) { setObject(3) };\nend \n rule r4 \n    when \n        $a : A( object == 3 )\n    then \n        System.out.println( $a ); \n        result.add(kcontext.getRule().getName());\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList<String> result = new ArrayList<String>();
        ksession.setGlobal("result", result);
        InternalFactHandle fhB = (InternalFactHandle)ksession.insert((Object)B.b((Object)1));
        InternalFactHandle fhA = (InternalFactHandle)ksession.insert((Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---1---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---2---");
        ksession.insert((Object)B.b((Object)2));
        ksession.insert((Object)B.b((Object)3));
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)2));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r2", "r3", "r4");
        System.out.println("---3---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)2));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r2", "r3", "r4");
        System.out.println("---4---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)3));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r4");
        System.out.println("---5---");
        ksession.update((FactHandle)fhB, (Object)B.b((Object)1));
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)3));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r4");
        System.out.println("---6---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---7---");
        ksession.update((FactHandle)fhA, (Object)A.a((Integer)1));
        ksession.fireAllRules();
        this.assertFiredRules(result, "r1");
        System.out.println("---8---");
        ksession.dispose();
    }
}

