/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class RuleRuntimeEventTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleRuntimeEventTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testEventModel() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_EventModel.drl"});
        KieSession wm = kbase.newKieSession();
        RuleRuntimeEventListener wmel = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
        wm.addEventListener(wmel);
        Cheese stilton = new Cheese("stilton", 15);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ArgumentCaptor oic = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectInserted((ObjectInsertedEvent)oic.capture());
        Assertions.assertThat((Object)((ObjectInsertedEvent)oic.getValue()).getFactHandle()).isSameAs((Object)stiltonHandle);
        wm.update(stiltonHandle, (Object)stilton);
        ArgumentCaptor ouc = ArgumentCaptor.forClass(ObjectUpdatedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectUpdated((ObjectUpdatedEvent)ouc.capture());
        Assertions.assertThat((Object)((ObjectUpdatedEvent)ouc.getValue()).getFactHandle()).isSameAs((Object)stiltonHandle);
        wm.delete(stiltonHandle);
        ArgumentCaptor orc = ArgumentCaptor.forClass(ObjectDeletedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectDeleted((ObjectDeletedEvent)orc.capture());
        Assertions.assertThat((Object)((ObjectDeletedEvent)orc.getValue()).getFactHandle()).isSameAs((Object)stiltonHandle);
    }
}

