/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.ancompiler.CompiledNetwork;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.util.DateUtils;
import org.drools.core.util.index.AlphaRangeIndex;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.MyComparable;
import org.drools.testcoverage.common.model.MyComparableHolder;
import org.drools.testcoverage.common.model.Order;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.conf.AlphaRangeIndexThresholdOption;

@RunWith(value=Parameterized.class)
public class AlphaNodeRangeIndexingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String BASIC_DRL = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 25 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age < 60 )\nthen\n end\nrule test5\n when\n   Person( age > 12 )\nthen\n end\nrule test6\n when\n   Person( age <= 4 )\nthen\n end\n";

    public AlphaNodeRangeIndexingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testInteger() {
        String drl = BASIC_DRL;
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 6, 6, 0, 6);
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(5);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    private KieBase createKieBaseWithRangeIndexThresholdValue(String drl, int rangeIndexThresholdValue) {
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBaseConfiguration kieBaseConfiguration = this.kieBaseTestConfiguration.getKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)AlphaRangeIndexThresholdOption.get((int)rangeIndexThresholdValue));
        return kieContainer.newKieBase(kieBaseConfiguration);
    }

    private void assertSinks(KieBase kbase, Class<?> factClass, int sinksLength, int sinkAdapterSize, int rangeIndexableSinksSize, int rangeIndexSize) {
        ObjectTypeNode otn = KieUtil.getObjectTypeNode((KieBase)kbase, factClass);
        Assertions.assertThat((Object)otn).isNotNull();
        ObjectSinkPropagator objectSinkPropagator = otn.getObjectSinkPropagator();
        if (this.kieBaseTestConfiguration.useAlphaNetworkCompiler()) {
            objectSinkPropagator = ((CompiledNetwork)objectSinkPropagator).getOriginalSinkPropagator();
        }
        CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)objectSinkPropagator;
        ObjectSink[] sinks = sinkAdapter.getSinks();
        Assertions.assertThat((int)sinks.length).isEqualTo(sinksLength);
        Assertions.assertThat((int)sinkAdapter.size()).isEqualTo(sinkAdapterSize);
        if (rangeIndexableSinksSize == 0) {
            Assertions.assertThat((List)sinkAdapter.getRangeIndexableSinks()).isNull();
        } else {
            Assertions.assertThat((int)sinkAdapter.getRangeIndexableSinks().size()).isEqualTo(rangeIndexableSinksSize);
        }
        if (rangeIndexSize == 0) {
            Assertions.assertThat((Map)sinkAdapter.getRangeIndexMap()).isNull();
        } else {
            long count = sinkAdapter.getRangeIndexMap().values().stream().flatMap(index -> index.getAllValues().stream()).count();
            Assertions.assertThat((long)count).isEqualTo((long)rangeIndexSize);
        }
    }

    @Test
    public void testNoMatch() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age < 20 )\nthen\n end\nrule test2\n when\n   Person( age <= 25 )\nthen\n end\nrule test3\n when\n   Person( age < 30 )\nthen\n end\nrule test4\n when\n   Person( age >= 40 )\nthen\n end\nrule test5\n when\n   Person( age > 45 )\nthen\n end\nrule test6\n when\n   Person( age >= 50 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 6, 6, 0, 6);
        ksession.insert((Object)new Person("John", 30));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(0);
        ksession.insert((Object)new Person("Paul", 40));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(1);
    }

    @Test
    public void testDouble() {
        String drl = "package org.drools.compiler.test\nimport " + Order.class.getCanonicalName() + "\nrule test1\n when\n   Order( total >= 18.0 )\nthen\n end\nrule test2\n when\n   Order( total < 25.0 )\nthen\n end\nrule test3\n when\n   Order( total > 8.0 )\nthen\n end\nrule test4\n when\n   Order( total < 60.0 )\nthen\n end\nrule test5\n when\n   Order( total > 12.0 )\nthen\n end\nrule test6\n when\n   Order( total <= 4.0 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Order.class, 6, 6, 0, 6);
        Order o1 = new Order();
        o1.setTotal(18.0);
        ksession.insert((Object)o1);
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(5);
        Order o2 = new Order();
        o2.setTotal(60.0);
        ksession.insert((Object)o2);
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    @Test
    public void testString() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( name >= \"Ann\" )\nthen\n end\nrule test2\n when\n   Person( name < \"Bob\" )\nthen\n end\nrule test3\n when\n   Person( name > \"Kent\" )\nthen\n end\nrule test4\n when\n   Person( name < \"Steve\" )\nthen\n end\nrule test5\n when\n   Person( name > \"John\" )\nthen\n end\nrule test6\n when\n   Person( name <= \"Paul\" )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 6, 6, 0, 6);
        ksession.insert((Object)new Person("John"));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
        ksession.insert((Object)new Person("Paul"));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(5);
    }

    @Test
    public void testBigDecimal() {
        String drl = "package org.drools.compiler.test\nimport " + Primitives.class.getCanonicalName() + "\nrule test1\n when\n   Primitives( bigDecimal >= 18.0 )\nthen\n end\nrule test2\n when\n   Primitives( bigDecimal < 25.0 )\nthen\n end\nrule test3\n when\n   Primitives( bigDecimal > 8.0 )\nthen\n end\nrule test4\n when\n   Primitives( bigDecimal < 60.0 )\nthen\n end\nrule test5\n when\n   Primitives( bigDecimal > 12.0 )\nthen\n end\nrule test6\n when\n   Primitives( bigDecimal <= 4.0 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Primitives.class, 6, 6, 0, 6);
        Primitives p1 = new Primitives();
        p1.setBigDecimal(new BigDecimal("18.0"));
        ksession.insert((Object)p1);
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(5);
        Primitives p2 = new Primitives();
        p2.setBigDecimal(new BigDecimal("60.0"));
        ksession.insert((Object)p2);
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    @Test
    public void testNull() {
        String drl = "package org.drools.compiler.test\nimport " + Primitives.class.getCanonicalName() + "\nrule test1\n when\n   Primitives( bigDecimal >= null )\nthen\n end\nrule test2\n when\n   Primitives( bigDecimal < 25.0 )\nthen\n end\nrule test3\n when\n   Primitives( bigDecimal > 8.0 )\nthen\n end\nrule test4\n when\n   Primitives( bigDecimal < 60.0 )\nthen\n end\nrule test5\n when\n   Primitives( bigDecimal > 12.0 )\nthen\n end\nrule test6\n when\n   Primitives( bigDecimal <= 4.0 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Primitives.class, 6, 6, 0, 5);
        Primitives p1 = new Primitives();
        p1.setBigDecimal(new BigDecimal("18.0"));
        ksession.insert((Object)p1);
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        Primitives p2 = new Primitives();
        p2.setBigDecimal(null);
        ksession.insert((Object)p2);
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(0);
    }

    @Test
    public void testEmpty() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( name >= \"Ann\" )\nthen\n end\nrule test2\n when\n   Person( name < \"Bob\" )\nthen\n end\nrule test3\n when\n   Person( name > \"\" )\nthen\n end\nrule test4\n when\n   Person( name < \"Steve\" )\nthen\n end\nrule test5\n when\n   Person( name > \"John\" )\nthen\n end\nrule test6\n when\n   Person( name <= \"Paul\" )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 6, 6, 0, 6);
        ksession.insert((Object)new Person("John"));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        ksession.insert((Object)new Person(""));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    @Test
    public void testDate() {
        String drl = "package org.drools.compiler.test\nimport " + Order.class.getCanonicalName() + "\nglobal java.util.List results;\nrule test1\n when\n   Order( date >= \"01-Oct-2020\" )\nthen\n   results.add(drools.getRule().getName());end\nrule test2\n when\n   Order( date < \"01-Nov-2020\" )\nthen\n   results.add(drools.getRule().getName());end\nrule test3\n when\n   Order( date > \"01-Oct-2010\" )\nthen\n   results.add(drools.getRule().getName());end\nrule test4\n when\n   Order( date < \"01-Oct-2030\" )\nthen\n   results.add(drools.getRule().getName());end\nrule test5\n when\n   Order( date > \"02-Oct-2020\" )\nthen\n   results.add(drools.getRule().getName());end\nrule test6\n when\n   Order( date <= \"02-Apr-2020\" )\nthen\n   results.add(drools.getRule().getName());end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Order.class, 6, 6, 0, 6);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Order o1 = new Order();
        o1.setDate(DateUtils.parseDate((String)"01-Oct-2020"));
        ksession.insert((Object)o1);
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        Assertions.assertThat(results).containsOnly((Object[])new String[]{"test1", "test2", "test3", "test4"});
        results.clear();
        Order o2 = new Order();
        o2.setDate(DateUtils.parseDate((String)"31-Dec-2010"));
        ksession.insert((Object)o2);
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        Assertions.assertThat(results).containsOnly((Object[])new String[]{"test2", "test3", "test4", "test6"});
    }

    @Test
    public void testUnderThreshold() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 25 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 2, 2, 2, 0);
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(1);
    }

    @Test
    public void testSurroundingRange() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 0 && < 20 )\nthen\n end\nrule test2\n when\n   Person( age >= 20 && < 40 )\nthen\n end\nrule test3\n when\n   Person( age >= 40 && < 60 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 3, 3, 0, 3);
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(1);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(0);
    }

    @Test
    public void testRemoveObjectSink() {
        String drl = BASIC_DRL;
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession1 = kbase.newKieSession();
        ksession1.insert((Object)new Person("John", 18));
        int fired1 = ksession1.fireAllRules();
        Assertions.assertThat((int)fired1).isEqualTo(5);
        ksession1.insert((Object)new Person("Paul", 60));
        fired1 = ksession1.fireAllRules();
        Assertions.assertThat((int)fired1).isEqualTo(3);
        ksession1.dispose();
        kbase.removeRule("org.drools.compiler.test", "test2");
        kbase.removeRule("org.drools.compiler.test", "test3");
        if (this.kieBaseTestConfiguration.useAlphaNetworkCompiler()) {
            return;
        }
        this.assertSinks(kbase, Person.class, 4, 4, 0, 4);
        KieSession ksession2 = kbase.newKieSession();
        ksession2.insert((Object)new Person("John", 18));
        int fired2 = ksession2.fireAllRules();
        Assertions.assertThat((int)fired2).isEqualTo(3);
        ksession2.insert((Object)new Person("Paul", 60));
        fired2 = ksession2.fireAllRules();
        Assertions.assertThat((int)fired2).isEqualTo(2);
        ksession2.dispose();
        kbase.removeRule("org.drools.compiler.test", "test4");
        kbase.removeRule("org.drools.compiler.test", "test5");
        this.assertSinks(kbase, Person.class, 2, 2, 2, 0);
        KieSession ksession3 = kbase.newKieSession();
        ksession3.insert((Object)new Person("John", 18));
        int fired3 = ksession3.fireAllRules();
        Assertions.assertThat((int)fired3).isEqualTo(1);
        ksession3.insert((Object)new Person("Paul", 60));
        fired3 = ksession3.fireAllRules();
        Assertions.assertThat((int)fired3).isEqualTo(1);
        ksession3.dispose();
    }

    @Test
    public void testCustomComparable() {
        String drl = "package org.drools.compiler.test\nimport " + MyComparableHolder.class.getCanonicalName() + "\nimport " + MyComparable.class.getCanonicalName() + "\nrule test1\n when\n   MyComparableHolder( myComparable >= MyComparable.ABC )\nthen\n end\nrule test2\n when\n   MyComparableHolder( myComparable < MyComparable.DEF )\nthen\n end\nrule test3\n when\n   MyComparableHolder( myComparable > MyComparable.GHI )\nthen\n end\nrule test4\n when\n   MyComparableHolder( myComparable < MyComparable.JKL )\nthen\n end\nrule test5\n when\n   MyComparableHolder( myComparable > MyComparable.MNO )\nthen\n end\nrule test6\n when\n   MyComparableHolder( myComparable <= MyComparable.PQR )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, MyComparableHolder.class, 6, 6, 0, 0);
        MyComparable abc = new MyComparable("ABC", Integer.valueOf(1));
        ksession.insert((Object)new MyComparableHolder(abc));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        MyComparable jkl = new MyComparable("JKL", Integer.valueOf(10));
        ksession.insert((Object)new MyComparableHolder(jkl));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    @Test
    public void testNestedProps() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( address.number >= 18 )\nthen\n end\nrule test2\n when\n   Person( address.number < 25 )\nthen\n end\nrule test3\n when\n   Person( address.number > 8 )\nthen\n end\nrule test4\n when\n   Person( address.number < 60 )\nthen\n end\nrule test5\n when\n   Person( address.number > 12 )\nthen\n end\nrule test6\n when\n   Person( address.number <= 4 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 6, 6, 0, 0);
        Person person1 = new Person("John", 18);
        person1.setAddress(new Address("ABC street", 18, "London"));
        ksession.insert((Object)person1);
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(5);
        Person person2 = new Person("Paul", 60);
        person2.setAddress(new Address("XYZ street", 60, "London"));
        ksession.insert((Object)person2);
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    @Test
    public void testMultipleProps() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 25 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age < 60 )\nthen\n end\nrule test5\n when\n   Person( age > 12 )\nthen\n end\nrule test6\n when\n   Person( age <= 4 )\nthen\n end\nrule test7\n when\n   Person( name >= \"Ann\" )\nthen\n end\nrule test8\n when\n   Person( name < \"Bob\" )\nthen\n end\nrule test9\n when\n   Person( name > \"Kent\" )\nthen\n end\nrule test10\n when\n   Person( name < \"Steve\" )\nthen\n end\nrule test11\n when\n   Person( name > \"John\" )\nthen\n end\nrule test12\n when\n   Person( name <= \"Paul\" )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        ObjectTypeNode otn = KieUtil.getObjectTypeNode((KieBase)kbase, Person.class);
        Assertions.assertThat((Object)otn).isNotNull();
        ObjectSinkPropagator objectSinkPropagator = otn.getObjectSinkPropagator();
        if (this.kieBaseTestConfiguration.useAlphaNetworkCompiler()) {
            objectSinkPropagator = ((CompiledNetwork)objectSinkPropagator).getOriginalSinkPropagator();
        }
        CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)objectSinkPropagator;
        ObjectSink[] sinks = sinkAdapter.getSinks();
        Assertions.assertThat((int)sinks.length).isEqualTo(12);
        Assertions.assertThat((int)sinkAdapter.size()).isEqualTo(12);
        Assertions.assertThat((List)sinkAdapter.getRangeIndexableSinks()).isNull();
        Collection values = sinkAdapter.getRangeIndexMap().values();
        Assertions.assertThat((int)values.size()).isEqualTo(2);
        for (AlphaRangeIndex alphaRangeIndex : values) {
            Assertions.assertThat((int)alphaRangeIndex.size()).isEqualTo(6);
        }
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(8);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(8);
    }

    @Test
    public void testModify() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 25 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age < 60 )\nthen\n end\nrule test5\n when\n   Person( age > 12 )\nthen\n end\nrule test6\n when\n   $p : Person( age <= 4 )\nthen\n  modify($p) { setAge(90) }\nend\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 6, 6, 0, 6);
        ksession.insert((Object)new Person("John", 0));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(6);
    }

    @Test
    public void testIncrementalCompilation() {
        String drl1 = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 25 )\nthen\n end\n";
        String drl2 = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 25 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age < 60 )\nthen\n end\nrule test5\n when\n   Person( age > 12 )\nthen\n end\nrule test6\n when\n   Person( age <= 4 )\nthen\n end\n";
        String drl3 = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test5\n when\n   Person( age > 12 )\nthen\n end\nrule test6\n when\n   Person( age <= 4 )\nthen\n end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBaseConfiguration kieBaseConfiguration = this.kieBaseTestConfiguration.getKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)AlphaRangeIndexThresholdOption.get((int)3));
        KieBase kbase = kc.newKieBase(kieBaseConfiguration);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(ksession.getKieBase(), Person.class, 2, 2, 2, 0);
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
        ksession.dispose();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        kieBaseConfiguration = this.kieBaseTestConfiguration.getKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)AlphaRangeIndexThresholdOption.get((int)3));
        kbase = kc.newKieBase(kieBaseConfiguration);
        ksession = kbase.newKieSession();
        this.assertSinks(ksession.getKieBase(), Person.class, 6, 6, 0, 6);
        ksession.insert((Object)new Person("Paul", 18));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(5);
        ksession.dispose();
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.2.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl3});
        kc.updateToVersion(releaseId3);
        kieBaseConfiguration = this.kieBaseTestConfiguration.getKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)AlphaRangeIndexThresholdOption.get((int)3));
        kbase = kc.newKieBase(kieBaseConfiguration);
        ksession = kbase.newKieSession();
        this.assertSinks(ksession.getKieBase(), Person.class, 2, 2, 2, 0);
        ksession.insert((Object)new Person("George", 18));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testDefaultThreshold() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 25 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age < 60 )\nthen\n end\nrule test5\n when\n   Person( age > 12 )\nthen\n end\nrule test6\n when\n   Person( age <= 4 )\nthen\n end\nrule test7\n when\n   Person( age < 1 )\nthen\n end\nrule test8\n when\n   Person( age > 99 )\nthen\n end\nrule test9\n when\n   Person( age <= 2 )\nthen\n end\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBase kbase = kieContainer.getKieBase();
        this.assertSinks(kbase, Person.class, 9, 9, 0, 9);
        kbase.removeRule("org.drools.compiler.test", "test9");
        if (this.kieBaseTestConfiguration.useAlphaNetworkCompiler()) {
            return;
        }
        this.assertSinks(kbase, Person.class, 8, 8, 8, 0);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(5);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    @Test
    public void testMixedRangeHashAndOther() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List results;\nrule test1\n when\n   Person( age >= 18 )\nthen\n   results.add(drools.getRule().getName());end\nrule test2\n when\n   Person( age < 25 )\nthen\n   results.add(drools.getRule().getName());end\nrule test3\n when\n   Person( age > 8 )\nthen\n   results.add(drools.getRule().getName());end\nrule test4\n when\n   Person( age == 60 )\nthen\n   results.add(drools.getRule().getName());end\nrule test5\n when\n   Person( age == 12 )\nthen\n   results.add(drools.getRule().getName());end\nrule test6\n when\n   Person( age == 4 )\nthen\n   results.add(drools.getRule().getName());end\nrule test7\n when\n   Person( age != 18 )\nthen\n   results.add(drools.getRule().getName());end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        ObjectTypeNode otn = KieUtil.getObjectTypeNode((KieBase)kbase, Person.class);
        Assertions.assertThat((Object)otn).isNotNull();
        ObjectSinkPropagator objectSinkPropagator = otn.getObjectSinkPropagator();
        if (this.kieBaseTestConfiguration.useAlphaNetworkCompiler()) {
            objectSinkPropagator = ((CompiledNetwork)objectSinkPropagator).getOriginalSinkPropagator();
        }
        CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)objectSinkPropagator;
        ObjectSink[] sinks = sinkAdapter.getSinks();
        Assertions.assertThat((int)sinks.length).isEqualTo(7);
        Assertions.assertThat((int)sinkAdapter.size()).isEqualTo(7);
        Assertions.assertThat((List)sinkAdapter.getRangeIndexableSinks()).isNull();
        Assertions.assertThat((int)((AlphaRangeIndex)sinkAdapter.getRangeIndexMap().entrySet().iterator().next().getValue()).size()).isEqualTo(3);
        Assertions.assertThat((int)sinkAdapter.getHashedSinkMap().size()).isEqualTo(3);
        Assertions.assertThat((int)sinkAdapter.getOtherSinks().size()).isEqualTo(1);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Person("John", 18));
        ksession.fireAllRules();
        Assertions.assertThat(results).containsOnly((Object[])new String[]{"test1", "test2", "test3"});
        results.clear();
        ksession.insert((Object)new Person("Paul", 60));
        ksession.fireAllRules();
        Assertions.assertThat(results).containsOnly((Object[])new String[]{"test1", "test3", "test4", "test7"});
    }

    @Ignore(value="No need to test. Fails with standard-drl")
    @Test
    public void testCoercionStringToNumber() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( name >= 20 )\nthen\n end\nrule test2\n when\n   Person( name < 40 )\nthen\n end\nrule test3\n when\n   Person( name > 50 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 3, 3, 0, 0);
        ksession.insert((Object)new Person("30"));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
        ksession.insert((Object)new Person("10"));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(1);
    }

    @Test
    public void testDifferentNumberOfDigitsInDecimal() {
        this.checkDifferentNumberOfDigitsInDecimal("10");
        this.checkDifferentNumberOfDigitsInDecimal("10.00");
        this.checkDifferentNumberOfDigitsInDecimal("10B");
    }

    private void checkDifferentNumberOfDigitsInDecimal(String value) {
        String drl = "import " + Factor.class.getCanonicalName() + ";\nrule R1 when\n    Factor( factorAmt > " + value + " )\nthen end\nrule R2 when\n    Factor( factorAmt > 0.0, factorAmt <= 1.0 )\nthen end\nrule R3 when\n    Factor( factorAmt > 1.0, factorAmt <= 3.0 )\nthen end\nrule R4 when\n    Factor( factorAmt > 3.0, factorAmt <= 6.0 )\nthen end\nrule R5 when\n    Factor( factorAmt > 6.0, factorAmt <= 10.0 )\nthen end\nrule R6 when\n    Factor( factorAmt > 10.0 )\nthen end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Factor(25.0));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testIntegerWithStaticMethodAddedBeforeThreshold() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nimport " + StaticUtil.class.getCanonicalName() + "\nrule test1\n when\n   Person( age < StaticUtil.getThirty() )\nthen\n end\nrule test2\n when\n   Person( age < 30 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age >= 18 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 4, 4, 0, 3);
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
    }

    @Test
    public void testIntegerWithStaticMethodAddedAfterThreshold() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nimport " + StaticUtil.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 30 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age < StaticUtil.getThirty() )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 4, 4, 0, 3);
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
    }

    @Test
    public void testSharedAlpha() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\n when\n   Person( age >= 18 )\nthen\n end\nrule test2\n when\n   Person( age < 30 )\nthen\n end\nrule test3\n when\n   Person( age > 8 )\nthen\n end\nrule test4\n when\n   Person( age < 30 )\nthen\n end\n";
        KieBase kbase = this.createKieBaseWithRangeIndexThresholdValue(drl, 3);
        KieSession ksession = kbase.newKieSession();
        this.assertSinks(kbase, Person.class, 3, 3, 0, 3);
        ksession.insert((Object)new Person("John", 18));
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
        ksession.insert((Object)new Person("Paul", 60));
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
    }

    public static class StaticUtil {
        public static int getThirty() {
            return 30;
        }
    }

    public static class Factor {
        private final double factorAmt;

        public Factor(double factorAmt) {
            this.factorAmt = factorAmt;
        }

        public double getFactorAmt() {
            return this.factorAmt;
        }
    }
}

