/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ConsequenceOffsetTest {
    @Test
    public void testConsequenceOffset() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)ConsequenceOffsetTest.class.getResourceAsStream("test_consequenceOffset.drl")), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        int offset = -1;
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        for (RuleDescr rule : ((PackageDescr)((KnowledgeBuilderImpl)kbuilder).getPackageDescrs("com.sample").get(0)).getRules()) {
            if (!rule.getName().equals("test")) continue;
            offset = rule.getConsequenceOffset();
        }
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)ConsequenceOffsetTest.class.getResourceAsStream("test_consequenceOffset2.drl")), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)ConsequenceOffsetTest.class.getResourceAsStream("test_consequenceOffset.drl")), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        for (RuleDescr rule : ((PackageDescr)((KnowledgeBuilderImpl)kbuilder).getPackageDescrs("com.sample").get(0)).getRules()) {
            if (!rule.getName().equals("test")) continue;
            Assertions.assertThat((int)rule.getConsequenceOffset()).isEqualTo(offset);
            return;
        }
        Assertions.fail((String)"Unexpected point in test");
    }

    @Test
    public void testLargeSetOfImports() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)ConsequenceOffsetTest.class.getResourceAsStream("test_consequenceOffsetImports.drl")), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
    }
}

