/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.ObjectType;
import org.drools.core.test.model.Cheese;
import org.drools.mvel.ConstraintTestUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class AgendaEventSupportTest {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();
    private final boolean useLambdaConstraint;

    public AgendaEventSupportTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Parameterized.Parameters(name="useLambdaConstraint={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    @Ignore(value="This test already failed before changing to LambdaConstraint")
    @Test
    public void testAgendaEventListener() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools.test");
        RuleImpl rule = new RuleImpl("test1");
        rule.setEager(true);
        rule.setAgendaGroup("test group");
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjectType);
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg.getClassFieldAccessorStore().setEagerWire(true);
        AlphaNodeFieldConstraint constraint = ConstraintTestUtil.createCheeseTypeEqualsConstraint(pkg.getClassFieldAccessorStore(), "cheddar", this.useLambdaConstraint);
        pattern.addConstraint((Constraint)constraint);
        rule.addPattern((RuleConditionElement)pattern);
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return null;
            }
        });
        pkg.addRule(rule);
        kbase.addPackages(Collections.singleton(pkg));
        KieSession ksession = kbase.newKieSession();
        final ArrayList agendaList = new ArrayList();
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void matchCancelled(MatchCancelledEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void matchCreated(MatchCreatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                Assertions.assertThat((Object)event.getKieRuntime()).isNotNull();
                agendaList.add(event);
            }
        };
        ksession.addEventListener(agendaEventListener);
        Assertions.assertThat((int)ksession.getAgendaEventListeners().size()).isEqualTo(1);
        Cheese cheddar = new Cheese("cheddar", 15);
        FactHandle cheddarHandle = ksession.insert((Object)cheddar);
        InternalAgenda agenda = (InternalAgenda)ksession.getAgenda();
        agenda.evaluateEagerList();
        Assertions.assertThat((int)agendaList.size()).isEqualTo(1);
        MatchCreatedEvent createdEvent = (MatchCreatedEvent)agendaList.get(0);
        Assertions.assertThat((Object)createdEvent.getMatch().getFactHandles().toArray()[0]).isSameAs((Object)cheddarHandle);
        ksession.getAgenda().clear();
        MatchCancelledEvent cancelledEvent = (MatchCancelledEvent)agendaList.get(1);
        Assertions.assertThat((Comparable)cancelledEvent.getCause()).isEqualTo((Object)MatchCancelledCause.CLEAR);
        agendaList.clear();
        cheddar.setPrice(14);
        ksession.update(cheddarHandle, (Object)cheddar);
        agenda.evaluateEagerList();
        Assertions.assertThat((int)agendaList.size()).isEqualTo(1);
        createdEvent = (MatchCreatedEvent)agendaList.get(0);
        Assertions.assertThat((Object)createdEvent.getMatch().getFactHandles().toArray()[0]).isSameAs((Object)cheddarHandle);
        agendaList.clear();
        cheddar.setPrice(14);
        ksession.update(cheddarHandle, (Object)cheddar);
        Assertions.assertThat((int)agendaList.size()).isEqualTo(0);
        ksession.retract(cheddarHandle);
        Assertions.assertThat((int)agendaList.size()).isEqualTo(1);
        cancelledEvent = (MatchCancelledEvent)agendaList.get(0);
        Assertions.assertThat((Object)((InternalFactHandle)cancelledEvent.getMatch().getFactHandles().toArray()[0]).getObject()).isNotNull();
        cheddarHandle = ksession.insert((Object)cheddar);
        agendaList.clear();
        ksession.getAgenda().getAgendaGroup("test group").setFocus();
        Assertions.assertThat((int)agendaList.size()).isEqualTo(1);
        AgendaGroupPushedEvent pushedEvent = (AgendaGroupPushedEvent)agendaList.get(0);
        Assertions.assertThat((String)pushedEvent.getAgendaGroup().getName()).isEqualTo("test group");
        agendaList.clear();
        ksession.fireAllRules();
        Assertions.assertThat((int)agendaList.size()).isEqualTo(3);
        BeforeMatchFiredEvent beforeEvent = (BeforeMatchFiredEvent)agendaList.get(0);
        Assertions.assertThat((Object)beforeEvent.getMatch().getFactHandles().toArray()[0]).isSameAs((Object)cheddarHandle);
        AfterMatchFiredEvent afterEvent = (AfterMatchFiredEvent)agendaList.get(1);
        Assertions.assertThat((Object)afterEvent.getMatch().getFactHandles().toArray()[0]).isSameAs((Object)cheddarHandle);
        AgendaGroupPoppedEvent poppedEvent = (AgendaGroupPoppedEvent)agendaList.get(2);
        Assertions.assertThat((String)poppedEvent.getAgendaGroup().getName()).isEqualTo("test group");
    }
}

