/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import org.assertj.core.api.Assertions;
import org.drools.core.base.BaseClassFieldReader;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.TestBean;
import org.drools.core.util.asm.BeanInherit;
import org.drools.core.util.asm.TestAbstract;
import org.drools.core.util.asm.TestAbstractImpl;
import org.drools.core.util.asm.TestInterface;
import org.drools.core.util.asm.TestInterfaceImpl;
import org.drools.mvel.asm.ClassFieldAccessorFactory;
import org.junit.Before;
import org.junit.Test;

public class BaseClassFieldAccessorFactoryTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testIt() throws Exception {
        ClassFieldAccessorFactory factory = new ClassFieldAccessorFactory();
        ClassFieldAccessorCache.CacheEntry cachEntry = new ClassFieldAccessorCache.CacheEntry(Thread.currentThread().getContextClassLoader());
        BaseClassFieldReader ex = factory.getClassFieldReader(TestBean.class, "name", cachEntry);
        Assertions.assertThat((Object)ex.getValue(null, (Object)new TestBean())).isEqualTo((Object)"michael");
        ex = factory.getClassFieldReader(TestBean.class, "age", cachEntry);
        Assertions.assertThat((int)((Number)ex.getValue(null, (Object)new TestBean())).intValue()).isEqualTo(42);
    }

    @Test
    public void testInterface() throws Exception {
        ClassFieldReader ex = this.store.getReader(TestInterface.class, "something");
        Assertions.assertThat((int)ex.getIndex()).isEqualTo(1);
        Assertions.assertThat((Object)ex.getValue(null, (Object)new TestInterfaceImpl())).isEqualTo((Object)"foo");
    }

    @Test
    public void testAbstract() throws Exception {
        ClassFieldReader ex = this.store.getReader(TestAbstract.class, "something");
        Assertions.assertThat((int)ex.getIndex()).isEqualTo(2);
        Assertions.assertThat((Object)ex.getValue(null, (Object)new TestAbstractImpl())).isEqualTo((Object)"foo");
    }

    @Test
    public void testInherited() throws Exception {
        ClassFieldReader ex = this.store.getReader(BeanInherit.class, "text");
        Assertions.assertThat((Object)ex.getValue(null, (Object)new BeanInherit())).isEqualTo((Object)"hola");
    }

    @Test
    public void testSelfReference() throws Exception {
        ClassFieldReader ex = this.store.getReader(BeanInherit.class, "this");
        TestBean bean = new TestBean();
        Assertions.assertThat((Object)ex.getValue(null, (Object)bean)).isEqualTo((Object)bean);
    }
}

