/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.command;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.process.instance.impl.DefaultWorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class RegisterWorkItemHandlerTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RegisterWorkItemHandlerTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testRegisterWorkItemHandlerWithStatelessSession() {
        String str = "package org.kie.workitem.test \nimport " + DefaultWorkItemManager.class.getCanonicalName() + "\nimport " + org.drools.core.process.instance.WorkItem.class.getCanonicalName() + "\nimport " + WorkItemImpl.class.getCanonicalName() + "\nrule r1 when \nthen \n  WorkItem wi = new WorkItemImpl(); \n  wi.setName( \"wihandler\" ); \n  DefaultWorkItemManager wim = ( DefaultWorkItemManager ) kcontext.getKieRuntime().getWorkItemManager(); \n  wim.internalExecuteWorkItem(wi); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        final boolean[] answer = new boolean[]{false};
        StatelessKieSession ks = kbase.newStatelessKieSession();
        ks.execute(CommandFactory.newRegisterWorkItemHandlerCommand((WorkItemHandler)new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                answer[0] = true;
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        }, (String)"wihandler"));
        Assertions.assertThat((boolean)answer[0]).isTrue();
    }
}

