/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.common.ActiveActivationIterator;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.util.Iterator;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ActiveActivationsIteratorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ActiveActivationsIteratorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testActiveActivationsIteratorTest() {
        String str = "package org.kie.test \n\nrule rule0 @Propagation(EAGER) agenda-group 'a1' salience ( Integer.parseInt('1'+$s) ) when\n    $s : String( this != 'xx' )\nthen\nend\nrule rule1 @Propagation(EAGER) agenda-group 'a2' salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\nend\nrule rule2 @Propagation(EAGER) agenda-group 'a3' salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\n    kcontext.getKieRuntime().halt();\nend\nrule rule3 @Propagation(EAGER) ruleflow-group 'r1' salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \nthen\nend\nrule rule4 @Propagation(EAGER) ruleflow-group 'r1' salience ( Integer.parseInt('1'+$s) ) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \n    eval( Integer.parseInt( $s ) > 3 ) \nthen\nend\nrule rule6 @Propagation(EAGER) when\n     java.util.Map()\nthen\nend\n\nrule rule7 @Propagation(EAGER) when\n    $s : String( this != 'xx' )\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 3; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ((InternalWorkingMemory)ksession).flushPropagations();
        ((InternalAgenda)ksession.getAgenda()).evaluateEagerList();
        Iterator it = ActiveActivationIterator.iterator((KieSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        AgendaItem act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule7:2:true", "rule7:0:true", "rule7:1:true", "rule0:2:true", "rule0:0:true", "rule0:1:true", "rule1:2:true", "rule1:0:true", "rule1:1:true", "rule2:2:true", "rule2:0:true", "rule2:1:true"}, list);
        ksession.fireAllRules();
        it = ActiveActivationIterator.iterator((KieSession)ksession);
        list = new ArrayList();
        act = (AgendaItem)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isQueued());
            act = (AgendaItem)it.next();
        }
        this.assertContains(new String[]{"rule0:2:true", "rule0:0:true", "rule0:1:true", "rule1:2:true", "rule1:0:true", "rule1:1:true", "rule2:2:true", "rule2:0:true", "rule2:1:true"}, list);
    }

    public void assertContains(Object[] objects, List list) {
        for (Object object : objects) {
            if (list.contains(object)) continue;
            Assertions.fail((String)("does not contain:" + object));
        }
    }
}

