/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.mvel.compiler.compiler.PackageDescrResourceVisitor;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescrResourceSetTest {
    protected static final transient Logger logger = LoggerFactory.getLogger(KnowledgeBuilderImpl.class);
    private static final PackageDescrResourceVisitor visitor = new PackageDescrResourceVisitor();
    private static final KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();

    @Test
    public void drlFilesTest() throws Exception {
        Set<File> drlFiles = this.getDrlFiles();
        for (File drl : drlFiles) {
            DrlParser parser = new DrlParser(((KnowledgeBuilderConfigurationImpl)conf).getLanguageLevel());
            InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(drl));
            PackageDescr pkgDescr = parser.parse((Resource)resource);
            if (parser.hasErrors()) continue;
            visitor.visit(pkgDescr);
        }
        logger.debug(drlFiles.size() + " drl tested.");
    }

    private Set<File> getDrlFiles() throws Exception {
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File dir = new File(url.toURI());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dir.exists()).as("Does not exist: " + url.toString(), new Object[0])).isTrue();
        FileFilter drlFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".drl");
            }
        };
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        TreeSet<File> drls = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(dir);
        while (!dirs.isEmpty()) {
            dir = (File)dirs.poll();
            drls.addAll(Arrays.asList(dir.listFiles(drlFilter)));
            dirs.addAll(Arrays.asList(dir.listFiles(dirFilter)));
        }
        return drls;
    }
}

