/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kproject.memory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.compiler.io.memory.MemoryFolder;
import org.junit.Test;

public class MemoryFolderTest {
    @Test
    public void testGetParentWithLeadingAndTrailingSlash() {
        MemoryFileSystem mfs = new MemoryFileSystem();
        Assertions.assertThat((String)new MemoryFolder(mfs, "/src").getParent().getPath().toPortableString()).isEqualTo("");
        Assertions.assertThat((String)new MemoryFolder(mfs, "src/").getParent().getPath().toPortableString()).isEqualTo("");
        Assertions.assertThat((String)new MemoryFolder(mfs, "/src/").getParent().getPath().toPortableString()).isEqualTo("");
        Assertions.assertThat((String)new MemoryFolder(mfs, "/src/main").getParent().getPath().toPortableString()).isEqualTo("src");
        Assertions.assertThat((String)new MemoryFolder(mfs, "src/main/").getParent().getPath().toPortableString()).isEqualTo("src");
        Assertions.assertThat((String)new MemoryFolder(mfs, "/src/main/").getParent().getPath().toPortableString()).isEqualTo("src");
        Assertions.assertThat((String)new MemoryFolder(mfs, "/src/main/java").getParent().getPath().toPortableString()).isEqualTo("src/main");
        Assertions.assertThat((String)new MemoryFolder(mfs, "src/main/java/").getParent().getPath().toPortableString()).isEqualTo("src/main");
        Assertions.assertThat((String)new MemoryFolder(mfs, "/src/main/java/").getParent().getPath().toPortableString()).isEqualTo("src/main");
    }

    @Test
    public void testRecursiveFolderCreation() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/resources");
        Assertions.assertThat((boolean)mres.exists()).isFalse();
        mres.create();
        Assertions.assertThat((boolean)mres.exists()).isTrue();
        Folder fld = fs.getFolder("src/main");
        Assertions.assertThat((boolean)fld.exists()).isTrue();
        Folder src = fs.getFolder("src");
        Assertions.assertThat((boolean)src.exists()).isTrue();
    }

    @Test
    public void testFolderGetParent() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/resources");
        mres.create();
        Assertions.assertThat((String)mres.getParent().getPath().toPortableString()).isEqualTo("src/main");
        Assertions.assertThat((String)mres.getParent().getParent().getPath().toPortableString()).isEqualTo("src");
    }

    @Test
    public void testNestedRelativePath() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder f1 = fs.getFolder("src/main/java");
        Folder f2 = fs.getFolder("src/main/java/org");
        f1.create();
        f2.create();
        Assertions.assertThat((String)f2.getPath().toRelativePortableString(f1.getPath())).isEqualTo("org");
        fs = new MemoryFileSystem();
        f1 = fs.getFolder("src/main/java");
        f2 = fs.getFolder("src/main/java/org/drools/reteoo");
        f1.create();
        f2.create();
        Assertions.assertThat((String)f2.getPath().toRelativePortableString(f1.getPath())).isEqualTo("org/drools/reteoo");
    }

    @Test
    public void testNestedRelativePathReverseArguments() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder f1 = fs.getFolder("src/main/java/org");
        Folder f2 = fs.getFolder("src/main/java/");
        f1.create();
        f2.create();
        Assertions.assertThat((String)f2.getPath().toRelativePortableString(f1.getPath())).isEqualTo("..");
        fs = new MemoryFileSystem();
        f1 = fs.getFolder("src/main/java/org/drools/reteoo");
        f2 = fs.getFolder("src/main/java");
        f1.create();
        f2.create();
        Assertions.assertThat((String)f2.getPath().toRelativePortableString(f1.getPath())).isEqualTo("../../..");
    }

    @Test
    public void testNestedRelativeDifferentPath() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder f1 = fs.getFolder("src/main/java");
        Folder f2 = fs.getFolder("src/main/resources");
        f1.create();
        f2.create();
        Assertions.assertThat((String)f2.getPath().toRelativePortableString(f1.getPath())).isEqualTo("../resources");
        fs = new MemoryFileSystem();
        f1 = fs.getFolder("src/main/java/org/drools");
        f2 = fs.getFolder("src/main/resources/org/drools/reteoo");
        f1.create();
        f2.create();
        Assertions.assertThat((String)f2.getPath().toRelativePortableString(f1.getPath())).isEqualTo("../../../resources/org/drools/reteoo");
    }

    @Test
    public void testFolderRemoval() throws IOException {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder fld = fs.getFolder("src/main/resources/org/domain");
        fld.create();
        fld = fs.getFolder("src/main");
        File file = fld.getFile("MyClass1.java");
        file.create((InputStream)new ByteArrayInputStream("ABC1".getBytes()));
        file = fld.getFile("MyClass2.java");
        file.create((InputStream)new ByteArrayInputStream("ABC2".getBytes()));
        fld = fs.getFolder("src/main/resources/org");
        file = fld.getFile("MyClass3.java");
        file.create((InputStream)new ByteArrayInputStream("ABC3".getBytes()));
        file = fld.getFile("MyClass4.java");
        file.create((InputStream)new ByteArrayInputStream("ABC4".getBytes()));
        fld = fs.getFolder("src/main/resources/org/domain");
        file = fld.getFile("MyClass4.java");
        file.create((InputStream)new ByteArrayInputStream("ABC5".getBytes()));
        Assertions.assertThat((boolean)fs.getFolder("src/main").exists()).isTrue();
        Assertions.assertThat((boolean)fs.getFile("src/main/MyClass1.java").exists()).isTrue();
        Assertions.assertThat((boolean)fs.getFile("src/main/MyClass2.java").exists()).isTrue();
        Assertions.assertThat((boolean)fs.getFile("src/main/resources/org/MyClass3.java").exists()).isTrue();
        Assertions.assertThat((boolean)fs.getFile("src/main/resources/org/MyClass4.java").exists()).isTrue();
        Assertions.assertThat((boolean)fs.getFile("src/main/resources/org/domain/MyClass4.java").exists()).isTrue();
        fs.remove(fs.getFolder("src/main"));
        Assertions.assertThat((boolean)fs.getFolder("src/main").exists()).isFalse();
        Assertions.assertThat((boolean)fs.getFile("src/main/MyClass1.java").exists()).isFalse();
        Assertions.assertThat((boolean)fs.getFile("src/main/MyClass2.java").exists()).isFalse();
        Assertions.assertThat((boolean)fs.getFile("src/main/resources/org/MyClass3.java").exists()).isFalse();
        Assertions.assertThat((boolean)fs.getFile("src/main/resources/org/MyClass4.java").exists()).isFalse();
        Assertions.assertThat((boolean)fs.getFile("src/main/resources/org/domain/MyClass4.java").exists()).isFalse();
    }

    @Test
    public void trimLeadingAndTrailing() {
        Assertions.assertThat((String)MemoryFolder.trimLeadingAndTrailing((String)"")).isEqualTo("");
        Assertions.assertThat((String)MemoryFolder.trimLeadingAndTrailing((String)"/src/main")).isEqualTo("src/main");
        Assertions.assertThat((String)MemoryFolder.trimLeadingAndTrailing((String)"src/main/")).isEqualTo("src/main");
        Assertions.assertThat((String)MemoryFolder.trimLeadingAndTrailing((String)"/src/main/")).isEqualTo("src/main");
    }

    @Test
    public void testCreateAndCopyFolder() {
        MemoryFileSystem memoryFileSystem = new MemoryFileSystem();
        Folder emptyFolder = memoryFileSystem.getFolder("emptyfolder");
        MemoryFolder destinationFolder = new MemoryFolder(memoryFileSystem, "destinationfolder");
        memoryFileSystem.createFolder(destinationFolder);
        memoryFileSystem.copyFolder(emptyFolder, memoryFileSystem, (Folder)destinationFolder, new String[0]);
    }
}

