/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.lang.MVELDumper;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.core.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.core.base.evaluators.SetEvaluatorsDefinition;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class MVELDumperTest {
    private MVELDumper dumper;

    @Before
    public void setUp() throws Exception {
        new SetEvaluatorsDefinition();
        new MatchesEvaluatorsDefinition();
        this.dumper = new MVELDumper();
    }

    @Test
    public void testDump() throws Exception {
        String input = "price > 10 && < 20 || == $val || == 30";
        String expected = "( price > 10 && price < 20 || price == $val || price == 30 )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpMatches() throws Exception {
        String input = "type.toString matches \"something\\swith\\tsingle escapes\"";
        String expected = "type.toString ~= \"something\\swith\\tsingle escapes\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpMatches2() throws Exception {
        String input = "type.toString matches 'something\\swith\\tsingle escapes'";
        String expected = "type.toString ~= \"something\\swith\\tsingle escapes\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpMatches3() throws Exception {
        String input = "this[\"content\"] matches \"hello ;=\"";
        String expected = "this[\"content\"] ~= \"hello ;=\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpContains() throws Exception {
        String input = "list contains \"b\"";
        String expected = "list contains \"b\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpContains2() throws Exception {
        String input = "list not contains \"b\"";
        String expected = "!( list contains \"b\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpExcludes() throws Exception {
        String input = "list excludes \"b\"";
        String expected = "!( list contains \"b\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpExcludes2() throws Exception {
        String input = "list not excludes \"b\"";
        String expected = "list contains \"b\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    @Ignore
    public void testDumpWithDateAttr() throws Exception {
        String input = "son.birthDate == \"01-jan-2000\"";
        String expected = "son.birthDate == org.drools.util.DateUtils.parseDate( \"01-jan-2000\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpComplex() throws Exception {
        String input = "a ( > 60 && < 70 ) || ( > 50 && < 55 ) && a3 == \"black\" || a == 40 && a3 == \"pink\" || a == 12 && a3 == \"yellow\" || a3 == \"blue\"";
        String expected = "( ( a > 60 && a < 70 || a > 50 && a < 55 ) && a3 == \"black\" || a == 40 && a3 == \"pink\" || a == 12 && a3 == \"yellow\" || a3 == \"blue\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpBindings() throws Exception {
        String input = "$x : property > value";
        String expected = "property > value";
        ConstraintConnectiveDescr descr = this.parse(input);
        MVELDumper.MVELDumperContext ctx = new MVELDumper.MVELDumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assertions.assertThat((String)result).isEqualTo(expected);
        Assertions.assertThat((int)ctx.getBindings().size()).isEqualTo(1);
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("property");
    }

    @Test
    public void testDumpBindings2() throws Exception {
        String input = "( $a : a > $b : b[10].prop || 10 != 20 ) && $x : someMethod(10) == 20";
        String expected = "( a > b[10].prop || 10 != 20 ) && someMethod(10) == 20";
        ConstraintConnectiveDescr descr = this.parse(input);
        MVELDumper.MVELDumperContext ctx = new MVELDumper.MVELDumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assertions.assertThat((String)result).isEqualTo(expected);
        Assertions.assertThat((int)ctx.getBindings().size()).isEqualTo(3);
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$a");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("a");
        bind = (BindingDescr)ctx.getBindings().get(1);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$b");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("b[10].prop");
        bind = (BindingDescr)ctx.getBindings().get(2);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("someMethod(10)");
    }

    @Test
    public void testDumpBindings3() throws Exception {
        String input = "( $a : a > $b : b[10].prop || 10 != 20 ) && $x : someMethod(10)";
        String expected = "( a > b[10].prop || 10 != 20 )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpBindings4() throws Exception {
        String input = "( $a : a > $b : b[10].prop || $x : someMethod(10) ) && 10 != 20";
        String expected = "( a > b[10].prop ) && 10 != 20";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testDumpBindingsWithRestriction() throws Exception {
        String input = "$x : age > 10 && < 20 || > 30";
        String expected = "( age > 10 && age < 20 || age > 30 )";
        ConstraintConnectiveDescr descr = this.parse(input);
        MVELDumper.MVELDumperContext ctx = new MVELDumper.MVELDumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assertions.assertThat((String)result).isEqualTo(expected);
        Assertions.assertThat((int)ctx.getBindings().size()).isEqualTo(1);
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("age");
    }

    @Test
    public void testDumpBindingsComplexOp() throws Exception {
        String input = "$x : age in (10, 20, $someVal)";
        String expected = "( age == 10 || age == 20 || age == $someVal )";
        ConstraintConnectiveDescr descr = this.parse(input);
        MVELDumper.MVELDumperContext ctx = new MVELDumper.MVELDumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assertions.assertThat((String)result).isEqualTo(expected);
        Assertions.assertThat((int)ctx.getBindings().size()).isEqualTo(1);
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("age");
    }

    @Test
    public void testDumpBindingsComplexOp2() throws Exception {
        String input = "$x : age not in (10, 20, $someVal)";
        String expected = "age != 10 && age != 20 && age != $someVal";
        ConstraintConnectiveDescr descr = this.parse(input);
        MVELDumper.MVELDumperContext ctx = new MVELDumper.MVELDumperContext();
        String result = this.dumper.dump((BaseDescr)descr, ctx);
        Assertions.assertThat((String)result).isEqualTo(expected);
        Assertions.assertThat((int)ctx.getBindings().size()).isEqualTo(1);
        BindingDescr bind = (BindingDescr)ctx.getBindings().get(0);
        Assertions.assertThat((String)bind.getVariable()).isEqualTo("$x");
        Assertions.assertThat((String)bind.getExpression()).isEqualTo("age");
    }

    @Test
    public void testProcessInlineCast() throws Exception {
        String expr = "field1#Class.field2";
        String expectedInstanceof = "field1 instanceof Class";
        String expectedcasted = "((Class)field1).field2";
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        ConstraintConnectiveDescr ccd = new ConstraintConnectiveDescr();
        ccd.addDescr((BaseDescr)atomicExpr);
        String[] instanceofAndCastedExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assertions.assertThat((int)ccd.getDescrs().size()).isEqualTo(2);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(0)).toString()).isEqualTo(expectedInstanceof);
        Assertions.assertThat((String)atomicExpr.getRewrittenExpression()).isEqualTo(expectedcasted);
        expr = "field1#Class1.field2#Class2.field3";
        String expectedInstanceof1 = "field1 instanceof Class1";
        String expectedInstanceof2 = "((Class1)field1).field2 instanceof Class2";
        expectedcasted = "((Class2)((Class1)field1).field2).field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        instanceofAndCastedExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(0)).toString()).isEqualTo(expectedInstanceof1);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(1)).toString()).isEqualTo(expectedInstanceof2);
        Assertions.assertThat((String)instanceofAndCastedExpr[1]).isEqualTo(expectedcasted);
        Assertions.assertThat((String)atomicExpr.getRewrittenExpression()).isEqualTo(expectedcasted);
    }

    @Test
    public void testProcessNullSafeDereferencing() throws Exception {
        String expr = "field1!.field2";
        String expectedNullCheck = "field1 != null";
        String expectedExpr = "field1.field2";
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        ConstraintConnectiveDescr ccd = new ConstraintConnectiveDescr();
        String[] nullCheckAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(0)).toString()).isEqualTo(expectedNullCheck);
        Assertions.assertThat((String)nullCheckAndExpr[1]).isEqualTo(expectedExpr);
        Assertions.assertThat((String)atomicExpr.getRewrittenExpression()).isEqualTo(expectedExpr);
        expr = "field1!.field2!.field3";
        String expectedNullCheck1 = "field1 != null";
        String expectedNullCheck2 = "field1.field2 != null";
        expectedExpr = "field1.field2.field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        nullCheckAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(0)).toString()).isEqualTo(expectedNullCheck1);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(1)).toString()).isEqualTo(expectedNullCheck2);
        Assertions.assertThat((String)nullCheckAndExpr[1]).isEqualTo(expectedExpr);
        Assertions.assertThat((String)atomicExpr.getRewrittenExpression()).isEqualTo(expectedExpr);
    }

    @Test
    public void testProcessImplicitConstraints() throws Exception {
        String expr = "field1#Class!.field2";
        String expectedConstraints = "field1 instanceof Class";
        String expectedExpr = "((Class)field1).field2";
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        ConstraintConnectiveDescr ccd = new ConstraintConnectiveDescr();
        String[] constraintsAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(0)).toString()).isEqualTo(expectedConstraints);
        Assertions.assertThat((String)constraintsAndExpr[1]).isEqualTo(expectedExpr);
        Assertions.assertThat((String)atomicExpr.getRewrittenExpression()).isEqualTo(expectedExpr);
        expr = "field1!.field2#Class.field3";
        String expectedConstraints1 = "field1 != null";
        String expectedConstraints2 = "field1.field2 instanceof Class";
        expectedExpr = "((Class)field1.field2).field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        constraintsAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(0)).toString()).isEqualTo(expectedConstraints1);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(1)).toString()).isEqualTo(expectedConstraints2);
        Assertions.assertThat((String)constraintsAndExpr[1]).isEqualTo(expectedExpr);
        Assertions.assertThat((String)atomicExpr.getRewrittenExpression()).isEqualTo(expectedExpr);
        expr = "field1#Class.field2!.field3";
        expectedConstraints1 = "field1 instanceof Class";
        expectedConstraints2 = "((Class)field1).field2 != null";
        expectedExpr = "((Class)field1).field2.field3";
        atomicExpr = new AtomicExprDescr(expr);
        ccd = new ConstraintConnectiveDescr();
        constraintsAndExpr = this.dumper.processImplicitConstraints(expr, atomicExpr, ccd, ccd.getDescrs().indexOf(atomicExpr), null);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(0)).toString()).isEqualTo(expectedConstraints1);
        Assertions.assertThat((String)((BaseDescr)ccd.getDescrs().get(1)).toString()).isEqualTo(expectedConstraints2);
        Assertions.assertThat((String)constraintsAndExpr[1]).isEqualTo(expectedExpr);
        Assertions.assertThat((String)atomicExpr.getRewrittenExpression()).isEqualTo(expectedExpr);
    }

    public ConstraintConnectiveDescr parse(String constraint) {
        DrlExprParser parser = new DrlExprParser(LanguageLevelOption.DRL6);
        ConstraintConnectiveDescr result = parser.parse(constraint);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parser.hasErrors()).as(parser.getErrors().toString(), new Object[0])).isFalse();
        return result;
    }
}

