/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang.descr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.util.StringUtils;
import org.drools.mvel.compiler.Person;
import org.junit.Test;

public class PackageDescrTest {
    @Test
    public void testAttributeOverriding() {
        PackageDescr desc = new PackageDescr("foo");
        AttributeDescr at1 = new AttributeDescr("foo", "bar");
        AttributeDescr at2 = new AttributeDescr("foo2", "default");
        desc.addAttribute(at1);
        desc.addAttribute(at2);
        RuleDescr rule = new RuleDescr("abc");
        rule.addAttribute(new AttributeDescr("foo", "overridden"));
        desc.addRule(rule);
        List pkgAts = desc.getAttributes();
        Assertions.assertThat((String)((AttributeDescr)pkgAts.get(0)).getValue()).isEqualTo("bar");
        Assertions.assertThat((String)((AttributeDescr)pkgAts.get(1)).getValue()).isEqualTo("default");
        desc.afterRuleAdded(rule);
        Map ruleAts = rule.getAttributes();
        Assertions.assertThat((String)((AttributeDescr)ruleAts.get("foo")).getValue()).isEqualTo("overridden");
        Assertions.assertThat((String)((AttributeDescr)ruleAts.get("foo2")).getValue()).isEqualTo("default");
    }

    @Test
    public void testSerializationImportDescr() {
        PackageDescrBuilder builder = DescrFactory.newPackage().name("foo");
        String className = Person.class.getName();
        builder.newImport().target(className).end();
        PackageDescr descr = (PackageDescr)builder.getDescr();
        ImportDescr importDescr = new ImportDescr(className);
        ImportDescr badImportDescr = new ImportDescr(null);
        Assertions.assertThat((boolean)descr.getImports().contains(importDescr)).isTrue();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            descr.writeExternal((ObjectOutput)out);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            PackageDescr newDescr = new PackageDescr();
            newDescr.readExternal((ObjectInput)in);
            Assertions.assertThat((boolean)newDescr.getImports().contains(badImportDescr)).isFalse();
            Assertions.assertThat((boolean)newDescr.getImports().contains(importDescr)).isTrue();
            Assertions.assertThat((boolean)newDescr.getPreferredPkgUUID().isPresent()).isFalse();
        }
        catch (IOException | ClassNotFoundException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerializationPkgUUID() {
        PackageDescrBuilder builder = DescrFactory.newPackage().name("foo");
        String className = Person.class.getName();
        builder.newImport().target(className).end();
        PackageDescr descr = (PackageDescr)builder.getDescr();
        String pkgUUID = StringUtils.generateUUID();
        descr.setPreferredPkgUUID(pkgUUID);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            descr.writeExternal((ObjectOutput)out);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            PackageDescr newDescr = new PackageDescr();
            newDescr.readExternal((ObjectInput)in);
            Assertions.assertThat((boolean)newDescr.getPreferredPkgUUID().isPresent()).isTrue();
            Assertions.assertThat((String)((String)newDescr.getPreferredPkgUUID().get())).isEqualTo(pkgUUID);
        }
        catch (IOException | ClassNotFoundException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetPreferredPkgUUID() {
        PackageDescr descr = new PackageDescr();
        Assertions.assertThat((boolean)descr.getPreferredPkgUUID().isPresent()).isFalse();
        String pkgUUID = StringUtils.generateUUID();
        descr.setPreferredPkgUUID(pkgUUID);
        Assertions.assertThat((boolean)descr.getPreferredPkgUUID().isPresent()).isTrue();
        Assertions.assertThat((String)((String)descr.getPreferredPkgUUID().get())).isEqualTo(pkgUUID);
    }
}

