/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.reteoo;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.mvel.integrationtests.LargeRuleBase;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.definition.rule.Rule;

@Ignore
public class ReteooBuilderPerformanceTest {
    private static final int RULE_COUNT = Integer.parseInt(System.getProperty("rule.count", "1000"));
    private static final int RETEBUILDER_COUNT = Integer.parseInt(System.getProperty("retebuilder.count", "1"));
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;

    @Test
    public void testReteBuilder() throws DroolsParserException {
        ReteooBuilderPerformanceTest.addRules(ReteooBuilderPerformanceTest.generatePackage(RULE_COUNT));
    }

    private static void addRules(InternalKnowledgePackage pkg) {
        ReteooBuilder[] reteBuilders = ReteooBuilderPerformanceTest.getReteBuilders(RETEBUILDER_COUNT);
        System.out.println("Adding rules to ReteBuilder");
        long start = System.currentTimeMillis();
        for (ReteooBuilder reteBuilder : reteBuilders) {
            for (Rule rule : pkg.getRules()) {
                reteBuilder.addRule((RuleImpl)rule);
            }
        }
        System.out.println("Added " + RULE_COUNT + " rules to each ReteBuilder's in " + ReteooBuilderPerformanceTest.format(System.currentTimeMillis() - start));
    }

    private static ReteooBuilder[] getReteBuilders(int count) {
        System.out.println("Creating " + count + " ReteBuilder's");
        ReteooBuilder[] reteBuilders = new ReteooBuilder[count];
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        for (int i = 0; i < reteBuilders.length; ++i) {
            reteBuilders[i] = new ReteooBuilder((InternalKnowledgeBase)new KnowledgeBaseImpl("id1", conf));
        }
        return reteBuilders;
    }

    private static InternalKnowledgePackage generatePackage(int ruleCount) throws DroolsParserException {
        StringReader reader = new StringReader(ReteooBuilderPerformanceTest.generateRules(ruleCount));
        System.out.println("Generating packages");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl();
        try {
            pkgBuilder.addPackageFromDrl((Reader)reader);
        }
        catch (IOException e) {
            Assertions.fail((String)("Unable to parse rules\n" + e.getMessage()));
        }
        if (pkgBuilder.hasErrors()) {
            Assertions.fail((String)pkgBuilder.getErrors().toString());
        }
        return pkgBuilder.getPackage("org.kie.test");
    }

    private static String generateRules(int ruleCount) {
        System.out.println("Generating " + ruleCount + " rules");
        StringBuilder sb = new StringBuilder(LargeRuleBase.getHeader());
        for (int i = 1; i <= ruleCount; ++i) {
            sb.append(LargeRuleBase.getTemplate1("testrule" + i, i));
        }
        return sb.toString();
    }

    private static String format(long time) {
        StringBuilder sb = new StringBuilder();
        sb.append(time / 3600000L).append(':');
        sb.append((time %= 3600000L) / 60000L).append(':');
        sb.append((double)(time %= 60000L) * 1.0 / 1000.0);
        return sb.toString();
    }
}

